import {createAsyncThunk, createSlice} from '@reduxjs/toolkit';

import serviceRequest from '../../app/serviceRequest';

import Utils from '../../utils';
import profileAPI from '../../api/profileAPI';

const initialState = {};

export const changeUserInfo = createAsyncThunk(
  'profile/changeUserInfo',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: profileAPI.requestChangeUserInfo,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const changeAvatar = createAsyncThunk(
  'profile/changeAvatar',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: profileAPI.requestChangeAvatar,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const changeCoverAvatar = createAsyncThunk(
  'profile/requestChangeCoverAvatar',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: profileAPI.requestChangeCoverAvatar,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
const profileSlice = createSlice({
  name: 'profile',
  initialState: initialState,
  reducers: {},
  extraReducers: builder => {
    builder.addCase(changeUserInfo.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
    });
  },
});

const {reducer} = profileSlice;
export default reducer;
