import {Dimensions, StyleSheet} from 'react-native';
import dimension from '../../values/dimension';
import colors from '../../values/colors';
const windowWidth = Dimensions.get('window').width;
const windowHeight = Dimensions.get('window').height;
const styles = StyleSheet.create({
  container: {
    flex: 1,
    padding: 10,
  },
  flexRow: {
    flexDirection: 'row',
  },
  centerContent: {
    alignItems: 'center',
    padding: 10,
  },
  viewImageProfile: {
    width: windowWidth - 20,
    height: 370,
    alignItems: 'center',
    borderWidth: 1,
    backgroundColor: colors.white,
    borderColor: colors.white,
    marginBottom: 10,
    borderRadius: 5,
  },
  viewCardProfile: {
    width: windowWidth - 20,
    height: 370,
    borderWidth: 1,
    backgroundColor: colors.white,
    borderColor: colors.white,
  },
  coverImage: {
    width: windowWidth - 20,
    height: 240,
    alignItems: 'flex-end',
    justifyContent: 'flex-end',
    resizeMode: 'contain',
  },
  viewAvatar: {
    borderWidth: 5,
    borderRadius: 60,
    borderColor: 'white',
    marginTop: -50,
    backgroundColor: 'white',
  },
  imgAvatar: {
    width: 80,
    height: 80,
    resizeMode: 'contain',
    alignSelf: 'center',
    borderRadius: 60,
  },
  imgFrame: {
    width: 120,
    height: 120,
    resizeMode: 'contain',
    alignSelf: 'center',
    justifyContent: 'center',
    borderRadius: 30,
  },
  imgAvatarFullScreen: {
    width: windowWidth,
    height: windowHeight,
  },
  btnClose: {
    position: 'absolute',
    top: 10,
    right: 10,
    zIndex: 100,
  },
  imgClose: {
    width: 30,
    height: 30,
    position: 'absolute',
    top: 10,
    right: 10,
    zIndex: 100,
  },
  viewFullScreen: {
    width: windowWidth,
    height: windowHeight,
  },
  viewInfo: {
    width: '100%',
    alignSelf: 'center',
    borderWidth: 1,
    borderRadius: 5,
    backgroundColor: colors.white,
    borderColor: colors.white,
    padding: 10,
    marginTop: 10,
  },
  viewTitle: {
    borderBottomColor: 'gray',
    borderBottomWidth: 1,
    marginBottom: 10,
    paddingHorizontal: 10,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
  },
  paddingView: {
    padding: 20,
  },
  marginBottom: {
    marginBottom: 20,
  },
  rightView: {
    flexDirection: 'row',
    flex: 1,
  },
  viewItem: {
    flexDirection: 'row',
    borderBottomWidth: 1,
    borderBottomColor: '#f6f6f6',
    paddingVertical: 10,
  },
  btnSubmit: {
    backgroundColor: '#5d78ff',
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
    borderRadius: 8,
    width: 100,
  },
  btnCancel: {
    backgroundColor: colors.white,
    justifyContent: 'center',
    alignItems: 'center',
    height: 40,
    borderRadius: 8,
    width: 100,
  },
  whiteTxt: {
    color: colors.white,
    fontWeight: '500',
  },
  blueTxt: {
    color: '#5d78ff',
    fontWeight: '500',
  },
  dropdown1DropdownStyle: {backgroundColor: '#EFEFEF'},
  dropdown1RowStyle: {},
  dropdown1RowTxtStyle: {color: '#444', textAlign: 'center'},
  dropdown1BtnStyle: {
    backgroundColor: '#FFF',
    borderColor: 'red',
    width: 130,
  },
  dropdown1BtnTxtStyle: {textAlign: 'left', fontSize: 14},
  centeredView: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: 22,
  },
  modalView: {
    margin: 20,
    backgroundColor: 'white',
    borderRadius: 20,
    padding: 35,
    alignItems: 'center',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 4,
    elevation: 5,
  },
  button: {
    borderRadius: 20,
    padding: 10,
    elevation: 2,
  },
  buttonOpen: {
    backgroundColor: '#F194FF',
  },
  buttonClose: {
    backgroundColor: '#2196F3',
  },
  textStyle: {
    color: 'white',
    fontWeight: 'bold',
    textAlign: 'center',
  },
  modalText: {
    marginBottom: 15,
    textAlign: 'center',
  },
  hiddenItem: {
    flexDirection: 'row',
    paddingTop: 10,
    flex: 1,
    justifyContent: 'flex-end',
  },
  item: {
    width: '90%',
    height: 70,
    marginVertical: 10,
    justifyContent: 'center',
    paddingLeft: 20,
    backgroundColor: '#FFFFFF',
    borderRadius: 10,

    shadowOpacity: 0.08,
    shadowOffset: {
      width: 0,
      height: 20,
    },
    shadowRadius: 10,
    elevation: 5,
    flexDirection: 'row',
  },
  activeDot: {
    backgroundColor: colors.purple_blue,
    width: 25,
    height: 8,
    borderRadius: 4,
  },
  avatarFrame: {
    width: 100,
    height: 100,
    resizeMode: 'contain',
    alignSelf: 'center',
    borderRadius: 60,
    zIndex: -100,
  },
  infoView: {flexDirection: 'row', paddingVertical: 10},
});

export default styles;
