import React from 'react';
import {SafeAreaView, ScrollView, View} from 'react-native';
import ButtonComponent from '../../../components/ButtonComponent';
import {IMAGES} from '../../../values/images';
import styles from '../style';
import DetailInformation from './components/DetailInformation';
import GeneralInformation from './components/GeneralInformation';
import IntroduceUser from './components/IntroduceUser';
import PersonalInformation from './components/PersonalInformation';

const ProfileMainView = ({
  userInfo,
  navigateToLogout,
  introduceUserProps,
  onEditUserInfo,
  editUserInfo,
  onSubmitChangeInfo,
}) => {
  return (
    <SafeAreaView style={styles.container}>
      <ScrollView nestedScrollEnabled={true}>
        <IntroduceUser {...introduceUserProps} />

        {/* General information  */}
        <GeneralInformation userInfo={userInfo} />
        {/* personal information  */}
        <PersonalInformation
          userInfo={userInfo}
          onEditUserInfo={onEditUserInfo}
          editUserInfo={editUserInfo}
          handleSubmitChangeInfo={onSubmitChangeInfo}
        />
        {/* detail information  */}
        <DetailInformation
          userInfo={userInfo}
          onEditUserInfo={onEditUserInfo}
          editUserInfo={editUserInfo}
          handleSubmitChangeInfo={onSubmitChangeInfo}
        />
        {/* Logout Btn */}
        <View
          style={{
            justifyContent: 'center',
            alignItems: 'center',
            marginTop: 10,
          }}>
          <ButtonComponent
            text={'Đăng xuất'}
            style={{marginBottom: 10, flexDirection: 'row'}}
            rightIcon={IMAGES.IcLogout}
            styleIcon={{width: 20, height: 20, marginLeft: 10}}
            onPress={navigateToLogout}
          />
        </View>
      </ScrollView>
    </SafeAreaView>
  );
};

export default ProfileMainView;
