import React, {memo} from 'react';
import {Image, TouchableOpacity, View} from 'react-native';
import AppText from '../../../../components/AppText';
import {IMAGES} from '../../../../values/images';
import string from '../../../../values/string';
import styles from '../../style';
import commonStyles from '../../../../styles/commonStyles';
import moment from 'moment';
import config from '../../../../config';
import {Formik} from 'formik';
import TextInputComponent from '../../../../components/TextInputComponent';
import ButtonComponent from '../../../../components/ButtonComponent';
import colors from '../../../../values/colors';

const DetailInformation = React.memo(
  ({userInfo, editUserInfo, onEditUserInfo, handleSubmitChangeInfo}) => {
    const personalInfo = [
      {
        name: 'Số CMND',
        value: userInfo?.id_card_number || '',
        icon: IMAGES.IcInfoGuess,
        width: '50%',
      },
      {
        name: 'Ngày cấp CMND',
        value: moment(userInfo?.id_card_issue_date).format('dd/MM/YYYY') || '',
        icon: IMAGES.IcInfoGuess,
        width: '50%',
      },
      {
        name: 'Nơi cấp CMND',
        value: userInfo?.id_card_issue_palce || '',
        icon: IMAGES.IcInfoGuess,
        width: '50%',
      },
      {
        name: 'Ngày sinh',
        value: userInfo?.birthday ? 'Nam' : 'Nữ',
        icon: IMAGES.IcInfoGuess,
        width: '50%',
      },
      {
        name: 'Nguyên quán',
        value: userInfo?.domicile || '',
        icon: IMAGES.IcPhone,
        width: '50%',
      },
      {
        name: 'Nơi sinh',
        value: userInfo?.birthplace || '',
        icon: IMAGES.IcPhone,
        width: '50%',
      },
      {
        name: 'Tôn giáo',
        value: userInfo?.religion || '',
        icon: IMAGES.IcMailGray,
        width: '50%',
      },
      {
        name: 'Dân tộc',
        value: userInfo?.ethnic || '',
        icon: IMAGES.IcMailGray,
        width: '50%',
      },
      {
        name: 'MST cá nhân',
        value: userInfo?.personal_tax_code || '',
        icon: IMAGES.IcCalendarGray,
        width: '50%',
      },
      {
        name: 'Quốc tịch',
        value: userInfo?.nationality || '',
        icon: IMAGES.IcMailGray,
        width: '50%',
      },
      {
        name: 'Địa chỉ liên hệ',
        value: userInfo?.address || '',
        icon: IMAGES.IcLocationGray,
        width: '100%',
      },
      {
        name: 'Địa chỉ thường trú',
        value: userInfo?.permanent_address || '',
        icon: IMAGES.IcLocationGray,
        width: '100%',
      },
    ];
    return (
      <View style={[styles.viewInfo]}>
        <View style={styles.viewTitle}>
          <AppText style={{fontSize: 17}}>
            {string.PERSONAL_INFORMATION}
          </AppText>
          <View>
            {!editUserInfo?.detailInfo ? (
              <TouchableOpacity
                onPress={() => onEditUserInfo(config.profileField.DETAIL_INFO)}>
                <Image source={IMAGES.IcEdit} style={{height: 30, width: 30}} />
              </TouchableOpacity>
            ) : (
              <TouchableOpacity onPress={() => onEditUserInfo()}>
                <Image source={IMAGES.IcReject} />
              </TouchableOpacity>
            )}
          </View>
        </View>
        <View style={[commonStyles.row, {flexWrap: 'wrap'}]}>
          {!editUserInfo?.detailInfo ? (
            personalInfo.map(item => (
              <View
                key={item.name}
                style={[styles.infoView, {width: item.width}]}>
                <Image source={item.icon} style={{width: 20, height: 20}} />
                <View style={{marginLeft: 5}}>
                  <AppText>{item.name}</AppText>
                  <AppText isSubText>{item?.value}</AppText>
                </View>
              </View>
            ))
          ) : (
            <Formik
              initialValues={{
                id_card_number: userInfo?.id_card_number || '',
                id_card_issue_date: userInfo?.id_card_issue_date || '',
                id_card_issue_palce: userInfo?.id_card_issue_palce || '',
                birthday: userInfo?.birthday ? 'Nam' : 'Nữ',
                domicile: userInfo?.domicile || '',
                birthplace: userInfo?.birthplace || '',
                religion: userInfo?.religion || '',
                ethnic: userInfo?.ethnic || '',
                personal_tax_code: userInfo?.personal_tax_code || '',
                nationality: userInfo?.personal_tax_code || '',
                address: userInfo?.address || '',
                permanent_address: userInfo?.permanent_address || '',
              }}
              onSubmit={values => handleSubmitChangeInfo(values)}>
              {({handleChange, handleBlur, handleSubmit, values}) => (
                <View style={[commonStyles.row, {flexWrap: 'wrap'}]}>
                  {personalInfo.map((item, index) => {
                    return (
                      <View
                        key={item.name}
                        style={{
                          width: item.width,
                          paddingHorizontal: 5,
                        }}>
                        <TextInputComponent
                          value={Object.values(values)[index]}
                          label={item.name}
                          placeholder={`Vui lòng nhập ${item.name} của bạn`}
                          styleAreaInput={{
                            backgroundColor: colors.white,
                            width: '100%',
                          }}
                          autoCompleteType={'postal-address'}
                          keyboardType={'email'}
                          onChangeText={handleChange(
                            Object.keys(values)[index],
                          )}
                        />
                      </View>
                    );
                  })}

                  <ButtonComponent
                    style={[styles.btnSubmit]}
                    text={'Đồng ý'}
                    textStyle={{color: colors.white}}
                    onPress={handleSubmit}
                  />
                </View>
              )}
            </Formik>
          )}
        </View>
      </View>
    );
  },
  // function (prevProps, nextProps) {
  //   return prevProps.userInfo === nextProps.userInfo;
  // },
);

export default memo(DetailInformation);
