import React, {memo} from 'react';
import {Image, View} from 'react-native';
import AppText from '../../../../components/AppText';
import {IMAGES} from '../../../../values/images';
import styles from '../../style';
import string from '../../../../values/string';
import commonStyles from '../../../../styles/commonStyles';

const GeneralInformation = React.memo(
  ({userInfo}) => {
    return (
      <View style={[styles.viewInfo, commonStyles.baseShadow]}>
        <View style={styles.viewTitle}>
          <AppText style={{color: 'black', fontSize: 18}}>
            {string.GENERAL_INFORMATION}
          </AppText>
        </View>
        <View style={{flexDirection: 'row', justifyContent: 'space-between'}}>
          <View style={{flexDirection: 'row'}}>
            <Image source={IMAGES.IcUser} style={{height: 45, width: 45}} />
            <View style={{marginLeft: 5}}>
              <AppText>{string.USER_ID}</AppText>
              <AppText style={{color: 'black', fontSize: 15}}>
                {userInfo?.employee_code}
              </AppText>
            </View>
          </View>
          <View style={{flexDirection: 'row'}}>
            <Image source={IMAGES.IcCheck} style={{height: 45, width: 45}} />
            <View style={{marginLeft: 5}}>
              <AppText>{string.TIME_ATTENDANCE_CODE}</AppText>
              <AppText style={{color: 'black', fontSize: 15}}>
                {userInfo?.employee_code}
              </AppText>
            </View>
          </View>
        </View>
        <View style={{flexDirection: 'row', marginTop: 10}}>
          <Image source={IMAGES.IcCalendar} style={{height: 45, width: 45}} />
          <View style={{marginLeft: 5}}>
            <AppText>{string.SHIFT}</AppText>
            <AppText style={{color: 'black', fontSize: 15}}>
              Meu Official working time
            </AppText>
          </View>
        </View>
        <View style={{flexDirection: 'row', marginTop: 10}}>
          <Image source={IMAGES.IcUserTag} style={{height: 45, width: 45}} />
          <View style={{marginLeft: 5}}>
            <AppText>{string.STATUS}</AppText>
            <AppText style={{color: 'black', fontSize: 15}}>
              Nhân viên chính thức
            </AppText>
          </View>
        </View>
      </View>
    );
  },
  function (prevProps, nextProps) {
    return prevProps.userInfo === nextProps.userInfo;
  },
);

export default memo(GeneralInformation);
