import React from 'react';
import {Image, ImageBackground, TouchableOpacity, View} from 'react-native';
import {Menu, MenuItem} from 'react-native-material-menu';
import Swiper from 'react-native-swiper';
import AppText from '../../../../components/AppText';
import ButtonComponent from '../../../../components/ButtonComponent';
import config from '../../../../config';
import colors from '../../../../values/colors';
import {IMAGES} from '../../../../values/images';
import styles from '../../style';
import commonStyles from '../../../../styles/commonStyles';

const CardInfo = React.memo(
  ({userInfo}) => {
    return (
      <ImageBackground
        source={IMAGES.BgProfileCard}
        style={[
          styles.viewCardProfile,
          {
            borderRadius: 10,
            paddingTop: 30,
          },
        ]}
        resizeMode="cover">
        <View style={{position: 'absolute', left: 15, top: 10}}>
          <Image source={IMAGES.ImageQrCode} style={{height: 45, width: 45}} />
        </View>
        <ImageBackground source={IMAGES.BgFrame} style={styles.imgFrame}>
          <Image
            source={
              userInfo?.avatar
                ? {uri: config.imageEndPoint + userInfo?.avatar}
                : IMAGES.IcAvatarDefault
            }
            style={styles.avatarFrame}
          />
        </ImageBackground>
        <View style={[commonStyles.centerView, commonStyles.marginVertical10]}>
          {userInfo?.position && <AppText>{userInfo?.position}</AppText>}
          <AppText style={{fontSize: 18, fontWeight: 'bold'}}>
            {`${userInfo?.first_name} ${
              userInfo?.middle_name ? userInfo?.middle_name : ''
            } ${userInfo?.last_name} `}
          </AppText>
          {userInfo?.email && (
            <View style={{flexDirection: 'row', marginTop: 10}}>
              <View style={{flex: 1, alignItems: 'flex-end', paddingRight: 5}}>
                <Image
                  source={IMAGES.IconMailGrey}
                  style={{height: 25, width: 25}}
                />
              </View>
              <AppText style={{flex: 2}}>{userInfo?.email}</AppText>
            </View>
          )}
          {userInfo?.cell_phone && (
            <View style={{flexDirection: 'row', marginTop: 10}}>
              <View style={{flex: 1, alignItems: 'flex-end', paddingRight: 5}}>
                <Image
                  source={IMAGES.IcPhoneGrey}
                  style={{height: 25, width: 25}}
                />
              </View>
              <AppText style={{flex: 2, color: 'black'}}>
                {userInfo?.cell_phone}
              </AppText>
            </View>
          )}
        </View>
        <View
          style={[
            commonStyles.row,
            {
              justifyContent: 'space-evenly',
            },
          ]}>
          <AppText style={{fontWeight: 'bold'}}>#willing-to-do</AppText>
          <AppText style={{fontWeight: 'bold'}}>#passion</AppText>
          <AppText style={{fontWeight: 'bold'}}>#hard-working</AppText>
        </View>
      </ImageBackground>
    );
  },
  function (prevProps, nextProps) {
    return prevProps.userInfo === nextProps.userInfo;
  },
);
const IntroduceUser = props => {
  const {
    userInfo,
    isEditField,
    avatar = [],
    onDeniedAvatar,
    onConfirmAvatar,
    showMenu,
    hideMenu,
    visibleMenu,
    openGallery,
    onChangeCoverAvatar,
    coverAvatar = [],
  } = props;
  return (
    <Swiper
      style={[commonStyles.baseShadow, {height: 380}]}
      showsButtons={false}
      loop={false}
      showsPagination={true}
      activeDot={<View style={styles.activeDot} />}>
      <View style={styles.viewImageProfile}>
        <ImageBackground
          source={
            coverAvatar.length > 0
              ? {uri: coverAvatar[0].uri}
              : userInfo?.cover_image
              ? {
                  uri: config.imageEndPoint + userInfo?.cover_image,
                }
              : IMAGES.ImageCoverBg
          }
          style={styles.coverImage}>
          <ButtonComponent
            iconSource={IMAGES.IcChangeCoverImage}
            styleIcon={{height: 20, width: 20}}
            style={{marginRight: 15, marginBottom: 10}}
            onPress={onChangeCoverAvatar}
          />
        </ImageBackground>
        <TouchableOpacity onPress={showMenu} style={styles.viewAvatar}>
          {avatar.length > 0 ? (
            <Image source={{uri: avatar[0].uri}} style={styles.imgAvatar} />
          ) : (
            <Image
              source={
                userInfo?.avatar
                  ? {uri: config.imageEndPoint + userInfo?.avatar}
                  : IMAGES.IcAvatarDefault
              }
              style={styles.imgAvatar}
            />
          )}

          {/* menu option */}
          <View style={{justifyContent: 'center', alignItems: 'center'}}>
            <Menu visible={visibleMenu} onRequestClose={hideMenu}>
              <MenuItem onPress={openGallery}>
                <AppText>Đổi hình nền</AppText>
              </MenuItem>
            </Menu>
          </View>
        </TouchableOpacity>
        {isEditField.avatar && (
          <View style={{flexDirection: 'row', justifyContent: 'space-around'}}>
            <TouchableOpacity onPress={onDeniedAvatar}>
              <Image source={IMAGES.IcDenied} style={{width: 25, height: 25}} />
            </TouchableOpacity>
            <TouchableOpacity onPress={onConfirmAvatar}>
              <Image
                source={IMAGES.IcCheckMark}
                style={{width: 25, height: 25}}
              />
            </TouchableOpacity>
          </View>
        )}
        <AppText style={{fontSize: 18}}>
          {`${userInfo?.first_name} ${
            userInfo?.middle_name ? userInfo?.middle_name : ''
          } ${userInfo?.last_name} (${userInfo?.employee_code})`}{' '}
        </AppText>
        <AppText style={{marginBottom: 20}}>{userInfo?.position}</AppText>
      </View>
      <CardInfo userInfo={userInfo} />
    </Swiper>
  );
};

export default IntroduceUser;
