import {Formik} from 'formik';
import React, {memo} from 'react';
import {Image, TouchableOpacity, View} from 'react-native';
import AppText from '../../../../components/AppText';
import ButtonComponent from '../../../../components/ButtonComponent';
import TextInputComponent from '../../../../components/TextInputComponent';
import config from '../../../../config';
import commonStyles from '../../../../styles/commonStyles';
import {IMAGES} from '../../../../values/images';
import string from '../../../../values/string';
import styles from '../../style';
import colors from '../../../../values/colors';

const PersonalInformation = React.memo(
  ({userInfo, onEditUserInfo, editUserInfo, handleSubmitChangeInfo}) => {
    const personalInfo = [
      {
        name: 'Họ',
        value: userInfo?.first_name || '',
        icon: IMAGES.IcInfoGuess,
        width: '50%',
      },
      {
        name: 'Tên lót',
        value: userInfo?.middle_name || '',
        icon: IMAGES.IcInfoGuess,
        width: '50%',
      },
      {
        name: 'Tên',
        value: userInfo?.last_name || '',
        icon: IMAGES.IcInfoGuess,
        width: '50%',
      },
      {
        name: 'Giới tính',
        value: userInfo?.gender ? 'Nam' : 'Nữ',
        icon: IMAGES.IcInfoGuess,
        width: '50%',
      },
      {
        name: 'Số điện thoại',
        value: userInfo?.cell_phone || '',
        icon: IMAGES.IcPhone,
        width: '100%',
      },
      {
        name: 'Email',
        value: userInfo?.email || '',
        icon: IMAGES.IcMailGray,
        width: '100%',
      },
    ];
    return (
      <View style={[styles.viewInfo]}>
        <View style={styles.viewTitle}>
          <AppText style={{fontSize: 17}}>
            {string.PERSONAL_INFORMATION}
          </AppText>
          <View>
            {!editUserInfo?.personalInfo ? (
              <TouchableOpacity
                onPress={() =>
                  onEditUserInfo(config.profileField.PERSONAL_INFO)
                }>
                <Image source={IMAGES.IcEdit} style={{height: 30, width: 30}} />
              </TouchableOpacity>
            ) : (
              <TouchableOpacity onPress={() => onEditUserInfo()}>
                <Image source={IMAGES.IcReject} />
              </TouchableOpacity>
            )}
          </View>
        </View>
        <View style={[commonStyles.row, {flexWrap: 'wrap'}]}>
          {!editUserInfo?.personalInfo ? (
            personalInfo.map(item => (
              <View
                key={item.name}
                style={[styles.infoView, {width: item.width}]}>
                <Image source={item.icon} style={{width: 20, height: 20}} />
                <View style={{marginLeft: 5}}>
                  <AppText>{item.name}</AppText>
                  <AppText isSubText>{item?.value}</AppText>
                </View>
              </View>
            ))
          ) : (
            <Formik
              initialValues={{
                first_name: userInfo?.first_name || '',
                middle_name: userInfo?.middle_name || '',
                last_name: userInfo?.last_name || '',
                gender: userInfo?.gender ? 'Nam' : 'Nữ',
                cell_phone: userInfo?.cell_phone || '',
              }}
              onSubmit={values => handleSubmitChangeInfo(values)}>
              {({handleChange, handleBlur, handleSubmit, values}) => (
                <View style={[commonStyles.row, {flexWrap: 'wrap'}]}>
                  {personalInfo.map((item, index) => {
                    if (index === personalInfo.length - 1) {
                      return null;
                    }
                    return (
                      <View
                        key={item.name}
                        style={{
                          width: item.width,
                          paddingHorizontal: 5,
                        }}>
                        <TextInputComponent
                          value={Object.values(values)[index]}
                          label={item.name}
                          placeholder={`Vui lòng nhập ${item.name} của bạn`}
                          styleAreaInput={{
                            backgroundColor: colors.white,
                            width: '100%',
                          }}
                          autoCompleteType={'postal-address'}
                          keyboardType={'email'}
                          onChangeText={handleChange(
                            Object.keys(values)[index],
                          )}
                        />
                      </View>
                    );
                  })}
                  <ButtonComponent
                    style={[styles.btnSubmit]}
                    text={'Đồng ý'}
                    textStyle={{color: colors.white}}
                    onPress={handleSubmit}
                  />
                </View>
              )}
            </Formik>
          )}
        </View>
      </View>
    );
  },
  // function (prevProps, nextProps) {
  //   return (
  //     prevProps.userInfo === nextProps.userInfo ||
  //     prevProps.editUserInfo === nextProps.editUserInfo ||
  //     prevProps.onEditUserInfo() === nextProps.onEditUserInfo()
  //   );
  // },
);

export default memo(PersonalInformation);
