/* eslint-disable prettier/prettier */
import React, {useCallback, useEffect, useState} from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {
  getPaySlipSections,
  getSalariesUser,
  getUserSheet,
} from '../../store/actions/UserAction';
import SalaryScreen from './SalaryScreen';
const SalaryContainer = props => {
  const {userDetails} = props;
  const dispatch = useDispatch();
  const bankAccount = useSelector(state => state.SalaryUser.bankAccount);
  const saBooksInfo = useSelector(state => state.SalaryUser.saBooks);
  const [tableData, setTableData] = useState([]);
  const [isShow, setIsShow] = useState(false);
  const [showNamePayItem, setShowNamePayItem] = useState();
  const [indexPayItem, setIndexPayItem] = useState();
  const showSalary = useCallback(value => setIsShow(value), [isShow]);

  const loadTableDataByPayItem = async sheetId => {
    //console.log(sheetId);
    const res = await dispatch(getPaySlipSections(sheetId));
    if (res.length > 0) {
      setTableData(res);
      //console.log(res);
    }
  };

  const setDefaultPayItem = () => {
    if (saBooksInfo && saBooksInfo.length > 0) {
      //console.log('setDefaultPayItem');
      setIndexPayItem(saBooksInfo.length - 1);
    }
  };
  const showInfoSlip = () => {
    //console.log('showInfoSlip');
    if (saBooksInfo && saBooksInfo.length > 0 && indexPayItem) {
      //console.log(indexPayItem);
      setShowNamePayItem(saBooksInfo[indexPayItem].name);
      loadTableDataByPayItem(saBooksInfo[indexPayItem].id);
    }
  };
  const nextPayItem = () => {
    if (indexPayItem < saBooksInfo.length - 1) {
      setIndexPayItem(indexPayItem + 1);
      //console.log('nextPayItem');
    }
  };
  const prevPayItem = () => {
    if (indexPayItem <= saBooksInfo.length - 1 && indexPayItem > 0) {
      //console.log('prevPayItem');

      setIndexPayItem(indexPayItem - 1);
    }
  };
  //   console.log('allowanceData', allowanceData);
  //   console.log('salaryData', salaryData);
  //console.log('saBooksInfo', saBooksInfo);
  //   const loadTableData = () => {
  //     if (salaryData && allowanceData) {
  //       const merge = salaryData.concat(...allowanceData);
  //       //console.log('merge', merge);
  //       setTableData(merge);
  //     }
  //   };
  function currencyFormat(num) {
    return (parseFloat(num).toFixed(0) + '').replace(
      /(\d)(?=(\d{3})+(?!\d))/g,
      '$1.',
    );
  }

  useEffect(() => {
    userDetails && dispatch(getSalariesUser(userDetails.id));
  }, [userDetails]);
  useEffect(() => {
    saBooksInfo && setDefaultPayItem();
  }, [saBooksInfo]);
  useEffect(() => {
    showInfoSlip();
  }, [indexPayItem]);

  //   useEffect(() => {
  //     bankAccount && salaryData && allowanceData && loadTableData();
  //   }, [bankAccount, salaryData, allowanceData]);
  // useEffect(() => {
  //     tableData && console.log("tableData", tableData)
  // }, [tableData])
  useEffect(() => {
    dispatch(getUserSheet());
  }, []);

  const salaryProps = {
    userDetails,
    bankAccount,
    // salaryData,
    // allowanceData,
    showNamePayItem,
    saBooksInfo,
    tableData,
    isShow,
    currencyFormat,
    showSalary,
    nextPayItem,
    prevPayItem,
  };
  return <SalaryScreen {...salaryProps} />;
};

export default SalaryContainer;
