/* eslint-disable prettier/prettier */
import Moment from 'moment';
import React from 'react';
import {Image, SafeAreaView, ScrollView, View} from 'react-native';
import FastImage from 'react-native-fast-image';
import AppText from '../../components/AppText';
import ButtonComponent from '../../components/ButtonComponent';
import {GifType, IMAGES} from '../../values/images';
import styles from './style';
const SalaryScreen = ({
  userDetails,
  bankAccount,
  tableData,
  currencyFormat,
  showNamePayItem,
  isShow,
  showSalary,
  saBooksInfo,
  nextPayItem,
  prevPayItem,
}) => {
  //console.log('tableData', tableData);
  return (
    <SafeAreaView>
      <ScrollView nestedScrollEnabled={true}>
        <View style={styles.view}>
          <AppText
            style={{fontWeight: 'bold', marginBottom: 10, color: 'black'}}>
            Phiếu lương
          </AppText>
          <View style={{flexDirection: 'row', justifyContent: 'space-between'}}>
            <AppText>Kỳ lương tháng 11</AppText>
            <AppText>01/11/2021 - 30/11/2021</AppText>
          </View>
          <View style={[styles.marginTop, {marginTop: 10}]}>
            <View style={{flex: 1}}>
              {!isShow ? (
                <ButtonComponent
                  style={{flexDirection: 'row', alignItems: 'center'}}
                  text={'Hiện thị tất cả'}
                  textStyle={{color: 'blue'}}
                  iconSource={IMAGES.IcVisibleEye}
                  styleIcon={{width: 20, height: 20, marginRight: 5}}
                  onPress={() => showSalary(true)}
                />
              ) : (
                <ButtonComponent
                  style={{flexDirection: 'row', alignItems: 'center'}}
                  text={'Ẩn'}
                  textStyle={{color: 'blue'}}
                  iconSource={IMAGES.IcHideEye}
                  styleIcon={{width: 20, height: 20, marginRight: 5}}
                  onPress={() => showSalary(false)}
                />
              )}
            </View>
            <View
              style={{flex: 1, flexDirection: 'row', justifyContent: 'center'}}>
              {saBooksInfo && (
                <View style={{flexDirection: 'row'}}>
                  <ButtonComponent
                    iconSource={IMAGES.IcArrowLeft}
                    styleIcon={{width: 20, height: 20}}
                    onPress={prevPayItem}
                  />
                  <AppText>{showNamePayItem}</AppText>
                  <ButtonComponent
                    iconSource={IMAGES.IcArrowRight}
                    styleIcon={{width: 20, height: 20}}
                    onPress={nextPayItem}
                  />
                </View>
              )}
            </View>
          </View>
          <View
            style={{
              flexDirection: 'row',
              borderBottomWidth: 1,
              paddingBottom: 10,
            }}>
            <Image
              source={{uri: 'https://meu.anawork.com' + userDetails.avatar}}
              style={{width: 80, height: 80}}
            />
            <View style={{marginLeft: 15}}>
              <AppText style={{color: 'black', fontWeight: 'bold'}}>{`${
                userDetails.first_name
              } ${userDetails.middle_name ? userDetails.middle_name : ''} ${
                userDetails.last_name
              }`}</AppText>
              <AppText style={{paddingTop: 5}}>{userDetails.position}</AppText>
            </View>
          </View>
          <View style={[styles.marginTop, {marginTop: 10}]}>
            <AppText style={{color: 'black', fontWeight: '500'}}>
              Ngày vào công ty
            </AppText>
            <AppText>
              {userDetails.join_date &&
                Moment(userDetails.join_date).format('DD/MM/YYYY')}
            </AppText>
          </View>
          <View style={styles.marginTop}>
            <AppText style={{color: 'black', fontWeight: '500', flex: 1}}>
              Tên ngân hàng
            </AppText>
            {bankAccount && bankAccount.length > 0 && (
              <AppText style={{textAlign: 'right', flex: 1}}>
                {bankAccount[0].extend_bank_brand_name}
              </AppText>
            )}
          </View>
          <View style={[styles.marginTop, {marginBottom: 30}]}>
            <AppText style={{color: 'black', fontWeight: '500'}}>
              Số tài khoản
            </AppText>
            {bankAccount && bankAccount.length > 0 && (
              <AppText>{bankAccount[0].bank_account}</AppText>
            )}
          </View>
          <View>
            <View style={{borderWidth: 1}}>
              <View
                style={{
                  borderBottomWidth: 1,
                  backgroundColor: '#e3e5ed',
                  padding: 5,
                }}>
                <AppText style={{color: 'black', fontWeight: 'bold'}}>
                  Phiếu lương
                </AppText>
              </View>
              {tableData &&
                tableData.map((item, index) => {
                  return (
                    <View
                      key={item.id + '_' + index}
                      style={{borderBottomWidth: 1, flexDirection: 'row'}}>
                      <View style={{flex: 1, borderRightWidth: 1, padding: 10}}>
                        <AppText>{item.extend_collumn_name}</AppText>
                      </View>
                      <View
                        style={{
                          flex: 1,
                          justifyContent: 'center',
                          alignItems: 'flex-end',
                          padding: 10,
                        }}>
                        <AppText>
                          {isShow
                            ? (
                                parseFloat(item.extend_value).toFixed(0) + ''
                              ).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.')
                            : '*****'}
                        </AppText>
                      </View>
                    </View>
                  );
                })}
            </View>
            {tableData.length === 0 && (
              <View
                style={{
                  justifyContent: 'center',
                  alignItems: 'center',
                  backgroundColor: 'white',
                  marginTop: 10,
                  padding: 20,
                }}>
                <AppText style={{textAlign: 'center'}}>
                  Bạn chưa có bảng lương nào, Cùng làm việc thật chăm chỉ nhé!
                </AppText>
                <FastImage
                  source={GifType.gifSalary}
                  style={{width: '90%', height: 250}}
                />
              </View>
            )}
          </View>
        </View>
      </ScrollView>
    </SafeAreaView>
  );
};

export default SalaryScreen;
