/* eslint-disable prettier/prettier */
/* eslint-disable react-hooks/exhaustive-deps */
/* eslint-disable prettier/prettier */
/* eslint-disable no-unused-vars */
import Moment from 'moment';
import React, {useEffect, useRef, useState} from 'react';
import {useDispatch} from 'react-redux';
import {getTimeSheetApprovalProject} from '../../../../store/actions/UserAction';
import ConfirmedShiftScreen from './ConfirmedShiftScreen';

const ConfirmedShiftContainer = () => {
  const dispatch = useDispatch();
  //Search
  const [searchValue, setSearchValue] = useState('');
  //Week
  const [numberWeekOfYear, setNumberWeekOfYear] = useState();
  const [managerDate, setManagerDate] = useState({
    currentDate: Moment().startOf('week').add(1, 'day').toDate(),
    theWeekend: Moment().endOf('week').add(1, 'day').toDate(),
  });
  //Table list
  const [myApprovalRequestList, setMyApprovalRequestList] = useState([]);
  const [currentPage, setCurrentPage] = useState(1);
  const [totalPage, setTotalPage] = useState(1);

  //API
  const fetchMyApprovalRequestList = async (
    numberOfWeek,
    page,
    searchContent,
  ) => {
    let searchQuery = '';
    if (searchContent !== '') {
      searchQuery = `department|employee_code|extend_user_full_name@=${searchContent}`;
    }

    const res = await dispatch(
      getTimeSheetApprovalProject(
        encodeURIComponent(numberOfWeek),
        page,
        encodeURIComponent(searchQuery),
      ),
    );
    setMyApprovalRequestList(res);
    setTotalPage(Math.ceil(Number.parseInt(res.length) / 10));
  };

  //Others
  const getNumberWeekOfYear = currentDate => {
    setNumberWeekOfYear(Number(Moment(new Date(currentDate)).format('W')));
  };

  const nextWeek = () => {
    const monday_in_next_week = Moment(managerDate.currentDate).add(7, 'days');
    const sunday_in_next_week = Moment(monday_in_next_week).add(6, 'days');

    setManagerDate({
      currentDate: monday_in_next_week,
      theWeekend: sunday_in_next_week,
    });
    getNumberWeekOfYear(new Date(monday_in_next_week));
  };

  const prevWeek = () => {
    console.log('Previous');
    const monday_in_next_week = Moment(managerDate.currentDate).subtract(
      7,
      'days',
    );
    const sunday_in_next_week = Moment(managerDate.currentDate).subtract(
      1,
      'days',
    );
    setManagerDate({
      currentDate: monday_in_next_week,
      theWeekend: sunday_in_next_week,
    });
    getNumberWeekOfYear(new Date(monday_in_next_week));
  };

  const onPageNext = () => {
    setCurrentPage(currentPage + 1);
  };

  const onPagePrevious = () => {
    setCurrentPage(currentPage - 1);
  };

  useEffect(() => {
    getNumberWeekOfYear(new Date());
  }, []);

  useEffect(() => {
    if (numberWeekOfYear) {
      fetchMyApprovalRequestList(numberWeekOfYear, currentPage, searchValue);
    }
  }, [numberWeekOfYear, currentPage, searchValue]);

  const confirmShiftProps = {
    numberWeekOfYear,
    myApprovalRequestList,
    managerDate,
    currentPage,
    totalPage,
    setSearchValue,
    prevWeek,
    nextWeek,
    onPageNext,
    onPagePrevious,
  };
  return <ConfirmedShiftScreen {...confirmShiftProps} />;
};

export default ConfirmedShiftContainer;
