/* eslint-disable prettier/prettier */
import moment from 'moment';
import React from 'react';
import {
  FlatList,
  Image,
  SafeAreaView,
  ScrollView,
  TouchableOpacity,
  View,
} from 'react-native';
import AppText from '../../../../../components/AppText';
import ButtonComponent from '../../../../../components/ButtonComponent';
import TextInputComponent from '../../../../../components/TextInputComponent';
import colors from '../../../../../values/colors';
import {IconTimeSheet, IMAGES} from '../../../../../values/images';
import {mainStyle} from './style';
const ConfirmedShiftDetailScreen = ({
  numberWeekOfYear,
  managerDate,
  confirmSheetDetail,
  userInfo,
  prevWeek,
  nextWeek,
  getNumberWeekOfYear,
  totalTime,
  onCollapseView,
  onExpandView,
  feedBack,
  setFeedback,
  onSubmitApproveReq,
  onRejectApproveReq,
}) => {
  const renderItem = (item, index) => {
    return (
      <View
        key={`${item.title} ${index}`}
        style={{flex: 1, flexDirection: 'row'}}>
        {index !== 7 ? (
          <TouchableOpacity
            key={index}
            style={{
              flex: 1,
              flexDirection: 'row',
              margin: 5,
              borderWidth: 0.5,
              height: 30,
            }}>
            <View style={mainStyle.viewItemDay}>
              <AppText>{item.title ? item.title : ''}</AppText>
            </View>
            <View
              style={{
                flex: 4,
                justifyContent: 'center',
                alignItems: 'center',
              }}>
              <AppText>
                {item.time && item.time.toString().includes(':')
                  ? item.time
                  : item.time !== 0 && item.time !== ''
                  ? moment(item.time).format('HH:mm')
                  : '00:00'}
              </AppText>
            </View>
          </TouchableOpacity>
        ) : (
          <View
            style={{
              flex: 1,
              justifyContent: 'center',
              alignItems: 'center',
              margin: 5,
              borderWidth: 0.5,
              height: 30,
            }}>
            <AppText style={{color: '#ffa117', fontWeight: '500'}}>{`${
              item.title
            } ${totalTime || 0}`}</AppText>
          </View>
        )}
      </View>
    );
  };
  const NEED_APPROVE = 'cae086d1-38bb-40ac-bb12-708fc3c60959';
  const APPROVED = 'cdcda9f8-a051-49bc-b14b-927c98a9d17a';
  const REJECT_APPROVE = '0455039f-fa00-4b36-928d-5055b1498121';
  return (
    <SafeAreaView>
      {/* <HeaderComponent {...props} /> */}
      <ScrollView nestedScrollEnabled={true} style={{padding: 5}}>
        <View>
          <AppText style={{marginBottom: 16, fontWeight: 'bold'}}>
            {userInfo?.extend_user_full_name} -{userInfo?.employee_code}
          </AppText>
          <View style={[mainStyle.row, {justifyContent: 'space-between'}]}>
            <ButtonComponent
              style={{
                backgroundColor: '#e9eaf9',
                padding: 5,
              }}
              iconSource={IconTimeSheet.IcLeftForward}
              styleIcon={{height: 20, width: 20}}
              onPress={() => prevWeek()}
            />
            <View
              style={{
                flexDirection: 'row',
                backgroundColor: '#e9eaf9',
                justifyContent: 'center',
                alignItems: 'center',
                paddingLeft: 10,
                paddingRight: 10,
              }}>
              <AppText style={{color: '#615f71', fontWeight: '500'}}>
                {`Tuần ${numberWeekOfYear} `}{' '}
              </AppText>
              <AppText>{`${moment(managerDate?.currentDate).format(
                'DD/MM/YYYY',
              )} - ${moment(managerDate?.theWeekend).format(
                'DD/MM/YYYY',
              )}`}</AppText>
              <Image
                source={IMAGES.IcCalendarGray}
                style={{height: 20, width: 20, marginLeft: 10}}
              />
            </View>
            <ButtonComponent
              style={{
                backgroundColor: '#e9eaf9',
                padding: 5,
              }}
              iconSource={IconTimeSheet.IcRightForward}
              styleIcon={{height: 20, width: 20}}
              onPress={() => nextWeek()}
            />
          </View>
        </View>
        <View
          style={{
            flexDirection: 'row',
            alignItems: 'center',
            justifyContent: 'space-between',
            marginTop: 16,
          }}>
          <View style={mainStyle.boxButton}>
            <AppText style={{color: '#646c9a', fontWeight: 'bold'}}>
              Tổng giờ tuần này:{' '}
              <AppText style={{color: '#f9bf5a', fontWeight: 'bold'}}>
                22:00
              </AppText>
            </AppText>
          </View>
          <TouchableOpacity
            style={mainStyle.boxButton}
            onPress={() => getNumberWeekOfYear(new Date())}>
            <AppText style={{color: '#646c9a', fontWeight: 'bold'}}>
              Tuần này
            </AppText>
          </TouchableOpacity>
        </View>
        <View style={{marginTop: 10}}>
          {confirmSheetDetail?.timesheet?.length === 0 ? (
            <AppText style={{textAlign: 'center'}}>Không có dữ liệu</AppText>
          ) : (
            <View>
              {confirmSheetDetail &&
                confirmSheetDetail.map((item, index_arr) => {
                  return (
                    (item.isExpand && (
                      <View
                        key={item.timesheet_id}
                        style={{
                          backgroundColor: 'white',
                          padding: 5,
                        }}>
                        <ButtonComponent
                          iconSource={IconTimeSheet.IcCollapse}
                          styleIcon={{width: 30, height: 30}}
                          onPress={() => onCollapseView(index_arr)}
                          style={{alignItems: 'flex-end'}}
                        />
                        <View style={{padding: 10}}>
                          <View style={{marginBottom: 10}}>
                            <AppText style={mainStyle.subtitle}>Dự án</AppText>
                            <AppText style={mainStyle.txtItem}>
                              {item.projectName}
                            </AppText>
                          </View>
                          <View style={{marginBottom: 10}}>
                            <AppText style={mainStyle.subtitle}>
                              Tên công việc
                            </AppText>
                            <AppText style={mainStyle.txtItem}>
                              {item.taskName}
                            </AppText>
                          </View>
                          <View style={{marginBottom: 10}}>
                            <AppText style={mainStyle.subtitle}>
                              Ghi chú trong tuần
                            </AppText>
                            <AppText style={mainStyle.txtItem}>
                              {item.description}
                            </AppText>
                          </View>
                        </View>
                        <View>
                          <FlatList
                            data={item.calendar}
                            renderItem={({item, index}) =>
                              renderItem(item, index, index_arr)
                            }
                            listKey={(item, index) => `_key${index.toString()}`}
                            keyExtractor={(item, index) =>
                              `_key${index.toString()}`
                            }
                            numColumns={2}
                          />
                        </View>
                      </View>
                    )) || (
                      // collapse view
                      <TouchableOpacity
                        onPress={() => onExpandView(index_arr)}
                        key={`_key${index_arr.toString()}`}
                        style={[
                          mainStyle.collapseView,
                          {
                            borderLeftColor:
                              index_arr % 2 === 0 ? '#0abb87' : '#959595',
                          },
                        ]}>
                        <View style={{flexDirection: 'row'}}>
                          <View style={{justifyContent: 'flex-start', flex: 6}}>
                            <AppText
                              style={{
                                fontSize: 14,
                                color: 'black',
                                fontWeight: 'bold',
                              }}>
                              {item.projectName}
                            </AppText>
                            <AppText>{item.taskName}</AppText>
                          </View>
                          <TouchableOpacity
                            onPress={() => onExpandView(index_arr)}
                            style={{flex: 1, justifyContent: 'center'}}>
                            <Image
                              source={IMAGES.IcArrowRight}
                              style={{height: 20, width: 20}}
                            />
                          </TouchableOpacity>
                        </View>
                      </TouchableOpacity>
                    )
                  );
                })}
              {confirmSheetDetail.length > 0 &&
                confirmSheetDetail[0]?.equalApproveId && (
                  <View>
                    {confirmSheetDetail[0]?.isApproved == APPROVED && (
                      <View style={mainStyle.viewBtn}>
                        <ButtonComponent
                          style={[
                            mainStyle.viewSaveAndSendBtn,
                            {
                              backgroundColor: colors.grayE9,
                              marginRight: 10,
                            },
                          ]}
                          text={'Timesheet đã duyệt'}
                          textStyle={[
                            mainStyle.saveAndSendBtn,
                            {color: colors.blue5c},
                          ]}
                        />
                      </View>
                    )}
                    {confirmSheetDetail[0]?.isApproved == NEED_APPROVE && (
                      <View style={{marginTop: 10}}>
                        <TextInputComponent
                          styleAreaInput={{backgroundColor: 'white'}}
                          placeholder={'Nhận xét'}
                          keyboardType={'email-address'}
                          autoCapitalize="none"
                          noBorder={true}
                          value={feedBack}
                          onChangeText={text => setFeedback(text)}
                        />
                        {feedBack.length == 0 && (
                          <AppText
                            style={{
                              marginTop: -20,
                              color: 'red',
                              marginBottom: 10,
                            }}>
                            *Vui lòng nhập nhận xét
                          </AppText>
                        )}
                        <View style={mainStyle.viewBtn}>
                          <ButtonComponent
                            style={[
                              mainStyle.viewSaveAndSendBtn,
                              {
                                backgroundColor: colors.white,
                                marginRight: 10,
                                borderColor: colors.green0a,
                                borderWidth: 1.5,
                              },
                            ]}
                            text={'Duyệt'}
                            textStyle={[
                              mainStyle.saveAndSendBtn,
                              {color: colors.green0a},
                            ]}
                            onPress={onSubmitApproveReq}
                          />
                          <ButtonComponent
                            style={[
                              mainStyle.viewSaveAndSendBtn,
                              {
                                backgroundColor: colors.grayE9,
                              },
                            ]}
                            text={'Từ chối'}
                            textStyle={[
                              mainStyle.saveAndSendBtn,
                              {color: colors.blue5c},
                            ]}
                            onPress={onRejectApproveReq}
                          />
                        </View>
                      </View>
                    )}
                    {confirmSheetDetail[0]?.isApproved == REJECT_APPROVE && (
                      <View style={mainStyle.viewBtn}>
                        <ButtonComponent
                          style={[
                            mainStyle.viewSaveAndSendBtn,
                            {
                              backgroundColor: '#fae1ea',
                              marginRight: 10,
                            },
                          ]}
                          text={'Timesheet đã từ chối'}
                          textStyle={[
                            mainStyle.saveAndSendBtn,
                            {color: '#de3a71'},
                          ]}
                        />
                      </View>
                    )}
                  </View>
                )}
            </View>
          )}
        </View>
      </ScrollView>
    </SafeAreaView>
  );
};

export default ConfirmedShiftDetailScreen;
