/* eslint-disable prettier/prettier */
import {StyleSheet} from 'react-native';

export const mainStyle = StyleSheet.create({
  bodyContainer: {
    marginTop: 16,
  },
  rowSpaceBetween: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  row: {
    flexDirection: 'row',
    marginTop: 10,
  },
  boxButton: {
    backgroundColor: '#eef0fc',
    paddingLeft: 12,
    paddingRight: 12,
    paddingTop: 8,
    paddingBottom: 8,
    borderRadius: 8,
  },
  searchIcon: {
    width: 20,
    height: 20,
    position: 'absolute',
    left: 10,
    top: 12,
  },
  searchInput: {
    borderWidth: 1,
    borderColor: '#d3d2d3',
    borderRadius: 4,
    paddingTop: 8,
    paddingRight: 208,
    paddingBottom: 8,
    paddingLeft: 40,
    marginBottom: 16,
    position: 'relative',
  },
  textTitle: {
    fontSize: 16,
    fontWeight: '500',
    color: '#313131',
  },
  statusButtonDropdown: {
    borderRadius: 4,
    borderWidth: 1,
    borderColor: '#c4c4c4',
    height: 32,
    width: 160,
  },
  statusButtonTextDropdown: {
    color: '#959595',
    fontSize: 14,
  },
  tableContainer: {
    borderColor: '#c6d1dd',
    borderWidth: 1,
    borderRadius: 4,
    width: '100%',
    marginTop: 16,
  },
  tableHeaderContainer: {
    paddingBottom: 12,
    paddingTop: 12,
  },
  tableHeader: {
    backgroundColor: '#ffffff',
    flexDirection: 'row',
    borderTopLeftRadius: 4,
    borderTopRightRadius: 4,
  },
  tableHeaderTitle: {
    color: '#434349',
    fontSize: 12,
    fontWeight: 'bold',
  },
  tableBody: {
    backgroundColor: '#f6faff',
  },
  tableRowContent: {
    flexDirection: 'row',
    paddingBottom: 14,
    paddingTop: 14,
  },
  tableButtonView: {
    backgroundColor: '#f6faff',
    borderWidth: 1,
    borderColor: '#5d78ff',
    width: '90%',
    paddingTop: 8,
    paddingBottom: 8,
    borderRadius: 4,
  },
  tableButtonTextView: {
    color: '#5d78ff',
    fontSize: 13,
    fontWeight: 'bold',
    textAlign: 'center',
  },
  dotStatus: {
    width: 8,
    height: 8,
    borderRadius: 4,
  },
  paginationContainer: {
    width: '100%',
    flexDirection: 'row',
    justifyContent: 'flex-end',
  },
  pagination: {
    flexDirection: 'row',
    alignItems: 'center',
    marginTop: 8,
  },
  subtitle: {
    fontSize: 11,
    color: '#ababab',
  },
  viewItemDay: {
    backgroundColor: '#eff0f5',
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtItem: {},
  collapseView: {
    padding: 10,
    borderWidth: 0.1,
    borderBottomLeftRadius: 8,
    borderTopLeftRadius: 8,
    borderLeftWidth: 5,
    marginTop: 15,
    backgroundColor: 'white',
  },
  viewBtn: {
    flex: 1,
    flexDirection: 'row',
    padding: 10,
    justifyContent: 'space-around',
    marginBottom: 30,
  },
  viewSaveAndSendBtn: {
    justifyContent: 'center',
    alignItems: 'center',
    padding: 15,
    flex: 1,
  },
  saveAndSendBtn: {fontWeight: 'bold'},
});
