import React, {useEffect, useRef} from 'react';
import {View, StyleSheet, Button} from 'react-native';
import LottieView from 'lottie-react-native';
import VirtualAssistant from '../../../mockup/assistant.json';
import {
  Gesture,
  GestureHandlerRootView,
  TapGestureHandler,
} from 'react-native-gesture-handler';
const VirtualAssistantMainView = props => {
  const {animationRef, handleInteraction} = props;
  const onTap = () => {
    alert('Bạn vừa chạm vào tôi!');
  };
  return (
    <GestureHandlerRootView style={{flex: 1}}>
      <View style={styles.container}>
        <LottieView
          ref={animationRef}
          source={VirtualAssistant} // File Lottie của bạn
          style={styles.assistant}
          loop={true}
        />
      </View>
      <Button title="Nói chuyện với tôi" onPress={handleInteraction} />
    </GestureHandlerRootView>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
  },
  assistant: {
    width: 200,
    height: 200,
  },
});

export default VirtualAssistantMainView;
