import React, {useEffect, useRef} from 'react';
import Tts from 'react-native-tts';
import VirtualAssistantMainView from './template/virtualAssistantMainView';
const INTRODUCE_VOICE =
  'Xin chào! Tôi là trợ lý ảo của bạn. Tôi ở đây để hỗ trợ bạn trong công việc, giải đáp thắc mắc và mang đến những giây phút thú vị. Hôm nay tôi có thể giúp gì cho bạn?';

const VirtualAssistantContainer = () => {
  const animationRef = useRef(null);

  // Hàm để trợ lý nói
  const assistantSpeak = text => {
    animationRef.current?.play(); // Phát hoạt hình khi nói
    Tts.speak(text); // Chuyển văn bản thành giọng nói
  };
  // Hàm xử lý khi người dùng tương tác
  const handleInteraction = () => {
    assistantSpeak(INTRODUCE_VOICE);
  };

  useEffect(() => {
    Tts.setDefaultLanguage('vi-VN'); // Ngôn ngữ tiếng Việt, thay bằng 'en-US' nếu muốn tiếng Anh
    Tts.setDefaultRate(0.5); // Tốc độ nói (0.5 là bình thường)
    Tts.addEventListener('tts-finish', () => {
      animationRef.current?.reset(); // Dừng hoạt hình khi nói xong
    });
    animationRef.current?.play();
    return () => {
      Tts.stop(); // Dừng TTS khi component unmount
    };
  }, []);

  const virtualProps = {animationRef, handleInteraction};
  return <VirtualAssistantMainView {...virtualProps} />;
};

export default VirtualAssistantContainer;
