/* eslint-disable prettier/prettier */
import CheckBox from '@react-native-community/checkbox';
import Moment from 'moment';
import React from 'react';
import {Dimensions, Image, SafeAreaView, View} from 'react-native';
import {BarChart} from 'react-native-chart-kit';
import DateTimePickerModal from 'react-native-modal-datetime-picker';
import SelectDropdown from 'react-native-select-dropdown';
import {ScrollView} from 'react-native-virtualized-view';
import AppText from '../../components/AppText';
import ButtonComponent from '../../components/ButtonComponent';
import LoadingProgress from '../../components/LoadingProgress';
import {IMAGES} from '../../values/images';
import {contentStyle, mainStyle, styles} from './style';
const WorkLoadScreen = ({
  userDetails,
  table,
  openTimePicker,
  timeFilter,
  toggleCheckBox,
  setToggleCheckBox,
  showDatePicker,
  hideDatePicker,
  handleConfirm,
  onSubmitFilter,
  dataChart,
  isLoading,
  chooseMonth,
  setChooseMonth,
  nextPage,
  prevPage,
  infoTable,
  lastPage,
  payload,
  firstPage,
}) => {
  const chartConfig = {
    backgroundGradientFrom: '#FFF',
    backgroundGradientFromOpacity: 1,
    backgroundGradientTo: '#FFF',
    backgroundGradientToOpacity: 0.5,
    color: () => '#ed642d',
    labelColor: () => '#3d3737',
    strokeWidth: 2, // optional, default 3
    barPercentage: 1,
    useShadowColorFromDataset: false, // optional
  };
  //console.log("table")
  return (
    <SafeAreaView>
      <ScrollView nestedScrollEnabled={true}>
        <View
          style={{
            flexDirection: 'row',
            justifyContent: 'space-between',
            backgroundColor: 'white',
            marginTop: 10,
          }}>
          <AppText style={contentStyle.txtTitle}>
            Thống kê phạm vi trong kỳ
          </AppText>
          <SelectDropdown
            data={[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]}
            defaultValue={chooseMonth.getMonth() + 1}
            dropdownIconPosition={'right'}
            buttonStyle={{
              ...styles.dropdown1BtnStyle,
              width: '40%',
              backgroundColor: 'white',
            }}
            onSelect={selectedItem =>
              setChooseMonth(
                new Date(`${selectedItem}/01/${new Date().getFullYear()}`),
              )
            }
            dropdownStyle={{
              ...styles.dropdown1DropdownStyle,
            }}
            rowStyle={styles.dropdown1RowStyle}
            rowTextStyle={{color: '#444', textAlign: 'center'}}
            buttonTextStyle={{color: '#444', textAlign: 'center'}}
            renderDropdownIcon={isOpened => {
              return (
                <Image
                  source={isOpened ? IMAGES.IcUpArrow : IMAGES.IcDownArrow}
                  style={{
                    width: 20,
                    height: 20,
                    marginRight: 10,
                  }}
                />
              );
            }}
          />
        </View>
        <ScrollView horizontal={true} style={mainStyle.viewChart}>
          <View>
            {dataChart && (
              <BarChart
                data={dataChart}
                width={
                  dataChart && dataChart.labels.length > 10
                    ? Dimensions.get('window').width +
                      (dataChart.labels.length / 2) * 100
                    : Dimensions.get('window').width
                }
                withInnerLines={false}
                height={220}
                chartConfig={chartConfig}
                showValuesOnTopOfBars={true}
              />
            )}
          </View>
        </ScrollView>
        <View style={[mainStyle.viewChart, {marginBottom: 30}]}>
          <AppText style={contentStyle.txtTitle}>Chi tiết chấm công</AppText>
          <View style={{paddingLeft: 10, marginBottom: 20}}>
            <View style={{flexDirection: 'row', marginBottom: 5}}>
              {/* start */}
              <View style={{flex: 1, marginRight: 10}}>
                <AppText style={contentStyle.subText}>Từ ngày</AppText>
                <ButtonComponent
                  style={[contentStyle.viewCalendar]}
                  text={Moment(timeFilter.start).format('DD/MM/YYYY')}
                  onPress={() => showDatePicker('start')}
                  iconSource={IMAGES.IcCalendarGray}
                  styleIcon={contentStyle.btnIcon}
                />
                <AppText style={contentStyle.subText}>Lọc từ ngày...</AppText>
                <View style={{flexDirection: 'row', alignItems: 'center'}}>
                  <CheckBox
                    disabled={false}
                    value={toggleCheckBox.start}
                    onValueChange={newValue =>
                      setToggleCheckBox({start: newValue})
                    }
                  />
                  <AppText style={{fontSize: 12}}>
                    Chỉ hiện đi trễ, về sớm
                  </AppText>
                </View>
                <DateTimePickerModal
                  isVisible={openTimePicker.start}
                  mode="date"
                  date={timeFilter.start}
                  onConfirm={time => handleConfirm('start', time)}
                  onCancel={() => hideDatePicker('start')}
                />
              </View>

              {/* from */}
              <View style={{flex: 1}}>
                <AppText style={contentStyle.subText}>Đến ngày</AppText>
                <ButtonComponent
                  style={contentStyle.viewCalendar}
                  text={Moment(timeFilter.finish).format('DD/MM/YYYY')}
                  onPress={() => showDatePicker('finish')}
                  iconSource={IMAGES.IcCalendarGray}
                  styleIcon={contentStyle.btnIcon}
                />
                <AppText style={contentStyle.subText}>Lọc đến ngày...</AppText>
                <View style={{flexDirection: 'row', alignItems: 'center'}}>
                  <CheckBox
                    disabled={false}
                    value={toggleCheckBox.finish}
                    onValueChange={newValue =>
                      setToggleCheckBox({finish: newValue})
                    }
                  />
                  <AppText style={{fontSize: 12}}>Chỉ hiện đi trễ</AppText>
                </View>
                <DateTimePickerModal
                  isVisible={openTimePicker.finish}
                  mode="date"
                  date={timeFilter.finish}
                  minimumDate={timeFilter.start}
                  onConfirm={time => handleConfirm('finish', time)}
                  onCancel={() => hideDatePicker('finish')}
                />
              </View>
            </View>
            <ButtonComponent
              style={contentStyle.btnFilter}
              text={'Lọc'}
              textStyle={{color: 'white'}}
              onPress={onSubmitFilter}
            />
            <View style={{marginBottom: 20}}>
              <View
                style={{flexDirection: 'row', borderWidth: 0.2, padding: 5}}>
                <AppText style={{flex: 2, fontWeight: '500'}}>Ngày</AppText>
                <AppText style={{flex: 2, fontWeight: '500'}}>Giờ vào</AppText>
                <AppText style={{flex: 2, fontWeight: '500'}}>Giờ ra</AppText>
                <AppText style={{flex: 1, fontWeight: '500'}}>Tổng</AppText>
              </View>
              {table &&
                table.length >= 1 &&
                table.map((item, index) => {
                  return (
                    <View
                      key={index}
                      style={{
                        justifyContent: 'space-between',
                        borderWidth: 0.2,
                        padding: 5,
                      }}>
                      <View style={{flexDirection: 'row'}}>
                        <AppText
                          style={[
                            {flex: 2, fontWeight: '500', color: 'black'},
                            item.isError && styles.errText,
                          ]}>
                          {item.date}
                        </AppText>
                        <AppText
                          style={[{flex: 2}, item.isError && styles.errText]}>
                          {item.time_input}
                        </AppText>
                        <AppText
                          style={[{flex: 2}, item.isError && styles.errText]}>
                          {item.time_output}
                        </AppText>
                        <AppText
                          style={[
                            {flex: 1, fontWeight: '500', color: 'black'},
                            item.isError && styles.errText,
                          ]}>{`${item.total} giờ`}</AppText>
                      </View>
                      <View style={{flexDirection: 'row'}}>
                        <AppText
                          style={[{flex: 1}, item.isError && styles.errText]}>
                          Đi trễ{' '}
                        </AppText>
                        <AppText
                          style={[
                            contentStyle.boldTxt,
                            item.isError && styles.errText,
                          ]}>
                          {item.time_work_late}
                        </AppText>
                      </View>
                      <View style={{flexDirection: 'row'}}>
                        <AppText
                          style={[{flex: 1}, item.isError && styles.errText]}>
                          Về sớm{' '}
                        </AppText>
                        <AppText
                          style={[
                            contentStyle.boldTxt,
                            item.isError && styles.errText,
                          ]}>
                          {item.leave_early}
                        </AppText>
                      </View>
                    </View>
                  );
                })}
            </View>
          </View>
          {/* footer  */}
          {table && (
            <View
              style={{
                flexDirection: 'row',
                justifyContent: 'flex-end',
                marginBottom: 50,
              }}>
              <AppText
                style={{
                  marginRight: 10,
                }}>{`${infoTable.from}-${infoTable.to} của ${infoTable.total}`}</AppText>
              <ButtonComponent
                style={{marginRight: 10}}
                iconSource={
                  infoTable.total < 10 || payload.page == 1
                    ? IMAGES.IcDoubleArrowLeftGrey
                    : IMAGES.IcDoubleArrowLeft
                }
                onPress={firstPage}
                styleIcon={{width: 20, height: 20}}
                disable={
                  infoTable.total < 10 || payload.page == 1 ? true : false
                }
              />
              <ButtonComponent
                style={{marginRight: 10}}
                iconSource={
                  payload.page == 1 || infoTable.total < 10
                    ? IMAGES.IcArrowLeftGrey
                    : IMAGES.IcArrowLeft
                }
                onPress={prevPage}
                styleIcon={{width: 20, height: 20}}
                disable={
                  payload.page == 1 || infoTable.total < 10 ? true : false
                }
              />
              <ButtonComponent
                style={{marginRight: 10}}
                iconSource={
                  infoTable.isLastPage
                    ? IMAGES.IcArrowRightGrey
                    : IMAGES.IcArrowRight
                }
                onPress={nextPage}
                styleIcon={{width: 20, height: 20}}
                disable={infoTable.isLastPage}
              />
              <ButtonComponent
                style={{marginRight: 10}}
                iconSource={
                  infoTable.isLastPage
                    ? IMAGES.IcDoubleArrowRightGrey
                    : IMAGES.IcDoubleArrowRight
                }
                onPress={lastPage}
                styleIcon={{width: 20, height: 20}}
                disable={infoTable.isLastPage}
              />
            </View>
          )}
        </View>
        {isLoading && <LoadingProgress />}
      </ScrollView>
    </SafeAreaView>
  );
};

export default WorkLoadScreen;
