import { Dimensions, StyleSheet } from 'react-native'
import dimension from '../../values/dimension'
import colors from '../../values/colors'
import { color } from 'react-native-reanimated';
const windowWidth = Dimensions.get('window').width;
export const headerStyle = StyleSheet.create({

})
export const contentStyle = StyleSheet.create({
    btnFilter: {
        backgroundColor: "#5d78ff",
        justifyContent: 'center',
        alignItems: 'center',
        height: 40,
        borderRadius: 5,
        marginBottom: 30,
        marginTop: 20
    },
    txtTitle: {
        fontSize: 14,
        fontWeight: 'bold',
        color: 'black',
        marginBottom: 10,
        paddingLeft: 10,
        paddingTop: 10,
    },
    viewCalendar: {
        borderBottomWidth: 0.2,
        flexDirection: 'row'
    },
    btnIcon: {
        width: 20,
        height: 20,
        position: 'absolute',
        right: 0
    },
    subText: {
        fontSize: 10
    },
    boldTxt: {
        flex: 1,
        textAlign: 'right',
        marginRight: 10,
        fontWeight: '500',
        color: 'black'
    }
})

export const mainStyle = StyleSheet.create({
    row: {
        flexDirection: 'row',
        marginTop: 5,
    },
    marginSpaceAround: {
        justifyContent: 'space-around'
    },
    viewChart: {
        marginTop: 10,
        borderWidth: 0.5,
        borderColor: 'white',
        backgroundColor: 'white',
        padding: 5,
    }
})
export const styles = StyleSheet.create({
    container: { flex: 1, padding: 16, paddingTop: 30, backgroundColor: '#fff' },
    head: { height: 40, backgroundColor: '#f1f8ff' },
    text: { alignSelf: 'center' },
    marginTop: { marginTop: 10 },
    errText: {
        color: 'red',
    }
});