import RootNavigation from '../../navigation/RootNavigation';
import CommonApi from '../../network/api/commonApi';
import AsyncStorageService from '../../utils/AsyncStorageService';
import AuthApi from '../../network/api/authApi';
import {APP_NAVIGATE_SCREEN} from '../../utils/constant';
import ActionType from '../actions/types';
import OneSignal from 'react-native-onesignal';
import api from '../../network/axios';
export const getMyInfo = () => {
  return async (dispatch, getState) => {
    const response = await CommonApi.requestGetMyInfo();
    //console.log("response", response);
    if (response.success) {
      dispatch({
        type: ActionType.GET_USER_INFO_SUCCESS,
        data: response.user,
      });
      OneSignal.removeExternalUserId();
      return response;
      // RootNavigation.navigate(APP_NAVIGATE_SCREEN.MAIN)
    }
  };
};
export const getUserLeaves = () => {
  return async (dispatch, getState) => {
    const response = await CommonApi.requestGetLeavesDay();
    // console.log("response getUserLeaves", response);

    if (response.success) {
      dispatch({
        type: ActionType.GET_LEAVES_SUCCESS,
        data: response.data.collection,
      });
    }
  };
};

export const logoutApp = () => {
  return async (dispatch, getState) => {
    const token = await AsyncStorageService.getToken();
    const response = await AuthApi.requestLogoutApp({token: token});
    //console.log("response", response);
    if (response.success) {
      await AsyncStorageService.clear();
      api.setBaseURL('');
      //RootNavigation.replace(APP_NAVIGATE_SCREEN.LOGIN, {index: 5});
    }
  };
};
export const getUserInfoById = userId => {
  return async (dispatch, getState) => {
    try {
      const response = await CommonApi.requestGetUserInfoById(userId);
      if (response.success) {
        return response.data;
      }
    } catch {
      console.log('Have an error when getUserInfoById');
    }
  };
};
