import { combineReducers } from 'redux'
import UserInfoReducer from './user/UserInfoReducer'
import UserOnLeavesReducer from './user/UserOnLeavesReducer'
import UserLeavesDayPendingReducer from './user/UserLeavesDayPendingReducer'
import GetRandomQuotation from './user/GetQuotationReducer'
import GetBirthdayUserByDay from './user/GetBirthdayUserReducer'
import GetOtVoucher from './user/GetOTUserReducer'
import GetOtVoucherPending from './user/GetOTPendingReducer'
import GetUserDirectManagers from './user/GetUserDirectManagersReducer'
import GetSalaryUser from './user/GetSalaryUserReducer'
import GetSheetUser from './user/GetSheetUserReducer'
import GetConfirmDay from './user/GetConfirmDayReducer'
import GetApproveConfirmDay from './user/GetApproveConfirmDay'
import GetTimeSheetProject from './user/GetTimeSheetProjectReducer'
import GetDataChart from './user/GetDataChartReducer'
import GetTimeKeeping from './user/GetTimeKeepingReducer'
import GetJobOfUser from './user/GetJobOfUserReducer'
import GetNotificationsList from './user/GetNotificationListReducer'
const reducers = combineReducers({
    UserInfo: UserInfoReducer,
    UserLeaves: UserOnLeavesReducer,
    UserLeavesPending: UserLeavesDayPendingReducer,
    Quotation: GetRandomQuotation,
    BirthDayUser: GetBirthdayUserByDay,
    OTVoucher: GetOtVoucher,
    OTVoucherPending: GetOtVoucherPending,
    MyDirectManagers: GetUserDirectManagers,
    SalaryUser: GetSalaryUser,
    SheetInfo: GetSheetUser,
    ConfirmDay: GetConfirmDay,
    ApproveDay: GetApproveConfirmDay,
    TimeSheetProjectInfo: GetTimeSheetProject,
    LoadingDataChart: GetDataChart,
    LoadingTimeKeeping: GetTimeKeeping,
    LoadingJobOfUser: GetJobOfUser,
    NotiList: GetNotificationsList
})

export default (state, action) => reducers(state, action)
