import ActionType from '../../actions/types';
// khởi tạo một init state
const initialState = {
  approveConfirm: [],
  isLoading: false,
};

// bắt từng action type
function GetApproveConfirmDay(state = initialState, action) {
  switch (action.type) {
    case ActionType.START_GET_APPROVE_CONFIRM_DAY:
      return {
        ...state,
        isLoading: true,
      };

    case ActionType.GET_APPROVE_CONFIRM_DAY_SUCCESS:
      return {
        approveConfirm: action.data,
        isLoading: false,
      };
    case ActionType.GET_APPROVE_CONFIRM_DAY_FAILED:
      return {
        ...state,
        isLoading: false,
      };
    default:
      return state;
  }
}

export default GetApproveConfirmDay;
