
import ActionType from '../../actions/types'
// khởi tạo một init state
const initialState = {
    birthday: [],
    isLoading: false,
}

// bắt từng action type
function GetBirthdayUserByDay(state = initialState, action) {
    switch (action.type) {
        case ActionType.START_GET_BIRTHDAY_USER:
            return {
                ...state,
                isLoading: true,
            }

        case ActionType.GET_BIRTHDAY_USER_SUCCESS:
            return {
                birthday: action.data,
                isLoading: false,
            }
        case ActionType.GET_BIRTHDAY_USER_FAILED:
            return {
                ...state,
                isLoading: false,
            }
        default:
            return state
    }
}

export default GetBirthdayUserByDay
