
import ActionType from '../../actions/types'
// khởi tạo một init state
const initialState = {
    confirmDay: [],
    isLoading: false,
}

// bắt từng action type
function GetConfirmDay(state = initialState, action) {
    switch (action.type) {
        case ActionType.START_GET_CONFIRM_DAY:
            return {
                ...state,
                isLoading: true,
            }

        case ActionType.GET_CONFIRM_DAY_SUCCESS:
            return {
                confirmDay: action.data,
                isLoading: false,
            }
        case ActionType.GET_CONFIRM_DAY_FAILED:
            return {
                ...state,
                isLoading: false,
            }
        default:
            return state
    }
}

export default GetConfirmDay
