
import ActionType from '../../actions/types'
// khởi tạo một init state
const initialState = {
    notiList: [],
    isLoading: false,
}

// bắt từng action type
function GetNotifications(state = initialState, action) {
    switch (action.type) {
        case ActionType.START_GET_NOTIFICATION:
            return {
                ...state,
                isLoading: true,
            }

        case ActionType.GET_NOTIFICATION_SUCCESS:
            return {
                notiList: action.data,
                isLoading: false,
            }
        case ActionType.GET_NOTIFICATION_FAILED:
            return {
                ...state,
                isLoading: false,
            }
        default:
            return state
    }
}

export default GetNotifications
