
import ActionType from '../../actions/types'
// khởi tạo một init state
const initialState = {
    quotation: [],
    isLoading: false,
}

// bắt từng action type
function GetRandomQuotation(state = initialState, action) {
    switch (action.type) {
        case ActionType.START_GET_QUOTES:
            return {
                ...state,
                isLoading: true,
            }

        case ActionType.GET_QUOTES_SUCCESS:
            return {
                quotation: action.data,
                isLoading: false,
            }
        case ActionType.GET_QUOTES_FAILED:
            return {
                ...state,
                isLoading: false,
            }
        default:
            return state
    }
}

export default GetRandomQuotation
