import ActionType from '../../actions/types';
// khởi tạo một init state
const initialState = {
  bankAccount: [],
  salaryData: [],
  allowanceData: [],
  saBooks: [],
  isLoading: false,
};

// bắt từng action type
function GetSalaryUser(state = initialState, action) {
  switch (action.type) {
    case ActionType.START_GET_USER_SALARY:
      return {
        ...state,
        isLoading: true,
      };

    case ActionType.GET_USER_SALARY_SUCCESS:
      return {
        bankAccount: action.bank,
        salaryData: action.data,
        allowanceData: action.allowance,
        saBooks: action.saBooks,
        isLoading: false,
      };
    case ActionType.GET_USER_SALARY_FAILED:
      return {
        ...state,
        isLoading: false,
      };
    default:
      return state;
  }
}

export default GetSalaryUser;
