
import ActionType from '../../actions/types'
// khởi tạo một init state
const initialState = {
    sheetInfo: [],
    isLoading: false,
}

// bắt từng action type
function GetSheetUser(state = initialState, action) {
    switch (action.type) {
        case ActionType.START_GET_USER_SHEET:
            return {
                ...state,
                isLoading: true,
            }

        case ActionType.GET_USER_SHEET_SUCCESS:
            return {
                sheetInfo: action.data,
                isLoading: false,
            }
        case ActionType.GET_USER_SHEET_FAILED:
            return {
                ...state,
                isLoading: false,
            }
        default:
            return state
    }
}

export default GetSheetUser
