
import ActionType from '../../actions/types'
// khởi tạo một init state
const initialState = {
    timeSheetProject: [],
    isLoading: false,
}

// bắt từng action type
function GetTimeSheetProject(state = initialState, action) {
    switch (action.type) {
        case ActionType.START_GET_TIME_SHEET_PROJECT:
            return {
                ...state,
                isLoading: true,
            }

        case ActionType.GET_TIME_SHEET_PROJECT_SUCCESS:
            return {
                timeSheetProject: action.data,
                isLoading: false,
            }
        case ActionType.GET_TIME_SHEET_PROJECT_FAILED:
            return {
                ...state,
                isLoading: false,
            }
        default:
            return state
    }
}

export default GetTimeSheetProject
