
import ActionType from '../../actions/types'
// khởi tạo một init state
const initialState = {
    userInfo: [],
    isLoading: false,
}

// bắt từng action type
function UserInfoReducer(state = initialState, action) {
    switch (action.type) {
        case ActionType.START_GET_USER_INFO:
            return {
                ...state,
                isLoading: true,
            }

        case ActionType.GET_USER_INFO_SUCCESS:
            return {
                userInfo: action.data,
                isLoading: false,
            }
        case ActionType.GET_USER_INFO_FAILED:
            return {
                ...state,
                isLoading: false,
            }
        case ActionType.EDIT_USER_INFO_SUCCESS:
            return {
                ...state,
                userInfo: action.data,
            }
        default:
            return state
    }
}

export default UserInfoReducer
