
import ActionType from '../../actions/types'
// khởi tạo một init state
const initialState = {
    userLeavesPending: [],
    leaveCategories: [],
    isLoading: false,
}

// bắt từng action type
function AllUserLeavesDayReducer(state = initialState, action) {
    switch (action.type) {
        case ActionType.START_GET_USER_LEAVES_PENDING:
            return {
                ...state,
                isLoading: true,
            }

        case ActionType.GET_USER_LEAVES_PENDING_SUCCESS:
            return {
                userLeavesPending: action.data,
                leaveCategories: action.category,
                isLoading: false,
            }
        case ActionType.GET_USER_LEAVES_PENDING_FAILED:
            return {
                ...state,
                isLoading: false,
            }
        default:
            return state
    }
}

export default AllUserLeavesDayReducer
