import ActionType from '../../actions/types';
// khởi tạo một init state
const initialState = {
  userLeaves: [],
  restDay: [],
  isLoading: false,
};

// bắt từng action type
function UserOnLeavesReducer(state = initialState, action) {
  switch (action.type) {
    case ActionType.START_GET_LEAVES:
      return {
        ...state,
        isLoading: true,
      };

    case ActionType.GET_LEAVES_SUCCESS:
      return {
        userLeaves: action.data,
        restDay: action.rest,
        isLoading: false,
      };
    case ActionType.GET_LEAVES_FAILED:
      return {
        ...state,
        isLoading: false,
      };
    default:
      return state;
  }
}

export default UserOnLeavesReducer;
