import { Dimensions, StyleSheet } from 'react-native';
import colors from '../values/colors';
const windowWidth = Dimensions.get('window').width;
const windowHeight = Dimensions.get('window').height;
const commonStyles = StyleSheet.create({
  container: {
    flex: 1,
  },
  baseShadow: {
    shadowColor: colors.baseShadowColor,
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,

    elevation: 5,
  },
  row: {
    flexDirection: 'row',
  },
  spaceBetweenCenter: {justifyContent: 'space-between', alignItems: 'center'},
  marginVertical10: {
    marginVertical: 10,
  },
  marginVertical20: {
    marginVertical: 20,
  },
  centerView: {justifyContent: 'center', alignItems: 'center'},
});
export default commonStyles;
