import AsyncStorage from '@react-native-async-storage/async-storage';
import React, {useEffect, useState} from 'react';
import AppNavigation from './navigation/AppNavigation';
import AsyncStorageKeys from './utils/AsyncStorageKeys';

const Main = () => {
  const [firstLaunch, setFirstLaunch] = useState(null);
  const [isLogged, setIsLogged] = useState(null);
  const [isHavingDomain, setIsHavingDomain] = useState(null);
  const [isTimeOut, setTimeout] = useState(null);

  const getTimeLogin = async () => {
    const time = await AsyncStorage.getItem(AsyncStorageKeys.timeLogin);
    var currentMonth = new Date().getMonth() + 5;
    if (currentMonth % time === 0) {
      setTimeout(true);
    }
  };
  const checkIsUserLoggedIn = () => {
    AsyncStorage.getItem(AsyncStorageKeys.isLogged).then(value => {
      if (value == null) {
        AsyncStorage.setItem(AsyncStorageKeys.isLogged, 'false');
        setIsLogged(false);
      } else {
        setIsLogged(value);
      }
    });
  };

  const checkIsHavingDomain = () => {
    AsyncStorage.getItem(AsyncStorageKeys.isInputDomain).then(value => {
      if (value == null) {
        AsyncStorage.setItem(AsyncStorageKeys.isInputDomain, 'false');
        AsyncStorage.setItem(AsyncStorageKeys.storeCurrentDomain, 'false');
        setIsHavingDomain(false);
      } else {
        setIsHavingDomain(value);
      }
    });
  };

  const checkFirstTimeUseApp = () => {
    AsyncStorage.getItem(AsyncStorageKeys.isFirstTime).then(value => {
      if (value == null) {
        setFirstLaunch(true);
      } else {
        setFirstLaunch(false);
      }
    });
    // TODO: Add some error handling, also you can simply do this.setState({fistLaunch: value == null})
  };
  useEffect(() => {
    checkFirstTimeUseApp();
    checkIsHavingDomain();
    checkIsUserLoggedIn();
    getTimeLogin();
  }, []);

  if (firstLaunch === null) {
    return null;
  } else if (firstLaunch) {
    return <AppNavigation screenName="welcome" />;
  } else if (!firstLaunch && !isHavingDomain) {
    return <AppNavigation screenName="server" />;
  } else if (isLogged) {
    if (isTimeOut) {
      return <AppNavigation screenName="time_out" />;
    }
    return <AppNavigation isLogged={isLogged} />;
  } else {
    return <AppNavigation screenName="login_step_1" isLogged={isLogged} />;
  }
};
export default Main;
