import axios from 'axios';
import Utils from '../utils';
import {apiEndpoint, axiosTimeout, storeKey} from '../config';

const axiosClient = axios.create({
  baseURL: apiEndpoint,
  headers: {
    'content-type': 'application/json',
  },
  validateStatus: () => true,
  timeout: axiosTimeout,
});

axiosClient.interceptors.request.use(async configAxios => {
  const auth = await Utils.getData(storeKey.AUTH);
  // configAxios.headers.Authorization = `Bearer eyJhbGciOiJodHRwOi8vd3d3LnczLm9yZy8yMDAxLzA0L3htbGRzaWctbW9yZSNobWFjLXNoYTI1NiIsInR5cCI6IkpXVCJ9.eyJodHRwOi8vc2NoZW1hcy54bWxzb2FwLm9yZy93cy8yMDA1LzA1L2lkZW50aXR5L2NsYWltcy9uYW1lIjoiZGFuZ2RvYW5AbWV1LXNvbHV0aW9ucy5jb20iLCJleHAiOjE3NTA4NDAyOTIsImlzcyI6ImFuYXdvcmsuY29tIiwiYXVkIjoiYW5hd29yay5jb20ifQ.yCWlui0YDxrEVmbR7IDts7GZDfzgHJ3SgVpTCy-6aes`;
  if (auth) {
    configAxios.headers.Authorization = `Bearer ${auth}`;
  }
  return configAxios;
});

axiosClient.interceptors.response.use(
  response => {
    if (response?.data) {
      return response.data;
    }
    return response;
  },
  error => {
    console.log(error);

    throw error;
  },
);

export {axiosClient};
