import {axiosClient} from './axiosClient';
import EZCheckApi from './network/AppApi';

const homeAPI = {
  requestGetUserInfo: params => {
    return axiosClient.get(EZCheckApi.getMyInfo);
  },
  requestGetUserPermissions: params => {
    return axiosClient.get(EZCheckApi.getMyPermissions);
  },
  requestGetValidateOffice: url => {
    return axiosClient.get(url);
  },
  requestGetCheckWorkingStatus: params => {
    return axiosClient.get(EZCheckApi.getWorkingStatus + params);
  },
  requestCheckIn: url => {
    return axiosClient.post(url);
  },
  requestCheckOut: url => {
    return axiosClient.post(url);
  },
  requestGetAttendanceLog: url => {
    return axiosClient.get(url);
  },
  requestGetBannerImages: url => {
    return axiosClient.get(url);
  },
};
export default homeAPI;
