import React, {Component} from 'react';
import {View, Text, Button, Modal} from 'react-native';
class ErrorModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: this.props.isVisible,
      mes: this.props.errorMes,
    };
  }

  toggleModal() {
    //this.props.isVisible = !this.props.isVisible
    this.setState({
      visible: !this.state.visible,
    });
    // this._click()
  }

  render() {
    return (
      <Modal
        isVisible={this.state.visible}
        coverScreen={true}
        onBackdropPress={() => this.toggleModal()}
        hasBackdrop={true}
        backdropOpacity={0.6}
        backdropColor="#f2f2f2">
        <View
          style={{
            width: '100%',
            height: '50%',
            zIndex: 5,
            backgroundColor: 'white',
          }}>
          <Text style={{width: '100%', height: '50%', zIndex: 10}}>
            {this.state.mes}
          </Text>
          <Button title="Press me" onPress={() => this.toggleModal()} />
        </View>
      </Modal>
    );
  }
}
export default ErrorModal;
