import AsyncStorage from '@react-native-async-storage/async-storage';
import React, {useEffect, useState} from 'react';
import {
  Alert,
  AppState,
  BackHandler,
  Linking,
  PermissionsAndroid,
  Platform,
} from 'react-native';
import Geolocation from 'react-native-geolocation-service';
import {PERMISSIONS, RESULTS, request} from 'react-native-permissions';
import {useDispatch} from 'react-redux';
import EZCheckApi from '../../api/network/AppApi';
import Utils from '../../utils';
import {
  checkWorkingStatus,
  getUserInfo,
  getUserPermissions,
  validateOffice,
} from './homeSlice';
import HomeMainView from './template/HomeMainView';
import propsProvider from './template/homePropsProvider';
import {storeKey} from '../../config';
const secretCode = 'abc';
const HomeContainer = props => {
  const {
    isAtOffice,
    officeInfo,
    navigation,
    isWorkingStatus,
    userInfo,
    currentLatitude,
    currentLongitude,
  } = props;
  const dispatch = useDispatch();
  const [appState, setAppState] = useState('abc');
  const [showingAlert, setShowingAlert] = useState(false);
  const [showingLoadingLocationModal, setShowingLoadingLocationModal] =
    useState(true);
  const shouldHandleAppStateChange = React.createRef(false);

  const DeniedPermission = () => {
    Alert.alert(
      'Alert',
      'Im Checkin cần truy cập vào vị trí hiện tại của điện thoại',
      [
        {
          text: 'Cancel',
          style: 'cancel',
          onPress: () => {
            setTimeout(() => (shouldHandleAppStateChange.current = true), 100);
          },
        },
        {
          text: 'Go to settings',
          onPress: () => {
            shouldHandleAppStateChange.current = true;
            Linking.openSettings();
          },
        },
      ],
      {cancelable: false},
    );
  };
  const checkLocationPermission = async () => {
    setShowingLoadingLocationModal(true);
    try {
      if (Platform.OS === 'ios') {
        let IOSGranted = await request(
          Platform.select({
            ios: PERMISSIONS.IOS.LOCATION_WHEN_IN_USE,
          }),
          {
            title: 'Im Checkin',
            message: 'Im Checkin cần truy cập vào vị trí',
          },
        );
        console.log('IOSGranted', IOSGranted);
        if (IOSGranted === RESULTS.GRANTED) {
          refreshGeolocation();
          return;
        }
        if (IOSGranted === RESULTS.UNAVAILABLE) {
          DeniedPermission();
        }
        if (IOSGranted === RESULTS.BLOCKED) {
          DeniedPermission();
        }
      } else {
        const AndroidGranted = await PermissionsAndroid.request(
          PermissionsAndroid.PERMISSIONS.ACCESS_FINE_LOCATION,
        );
        if (AndroidGranted === PermissionsAndroid.RESULTS.GRANTED) {
          refreshGeolocation();
        } else {
          Alert.alert(
            'Alert',
            'Im Checkin cần truy cập vào vị trí hiện tại của điện thoại',
            [
              {
                text: 'Cancel',
                style: 'cancel',
                onPress: () => {
                  showingAlert(false);
                  setTimeout(
                    () => (shouldHandleAppStateChange.current = true),
                    100,
                  );
                },
              },
              {
                text: 'Go to settings',
                onPress: () => {
                  shouldHandleAppStateChange.current = true;
                  Linking.openSettings();
                },
              },
            ],
            {cancelable: false},
          );
        }
        setShowingLoadingLocationModal(false);
      }
    } catch (err) {
      setShowingLoadingLocationModal(false);
    }
    //Checking for the permission just after component loaded
  };

  const getUserCurrentLocation = afterValidateOffice => {
    setShowingLoadingLocationModal(true);
    Geolocation.getCurrentPosition(
      position => {
        if (position.mocked) {
          if (!showingAlert) {
            setShowingAlert(true);
            Alert.alert(
              'Alert',
              'Phát hiện GPS giả, vui lòng sử dụng vị trí thật!',
              [
                {
                  text: 'Cancel',
                  style: 'cancel',
                  onPress: () => {
                    setShowingAlert(false);
                    setTimeout(
                      () => (shouldHandleAppStateChange.current = true),
                      100,
                    );
                  },
                },
                {
                  text: 'Go to settings',
                  onPress: () => {
                    setShowingAlert(false);
                    shouldHandleAppStateChange.current = true;
                    Linking.openSettings();
                  },
                },
              ],
              {cancelable: false},
            );
          }
        } else {
          const currentLongitude = JSON.stringify(position.coords.longitude);
          const currentLatitude = JSON.stringify(position.coords.latitude);

          let validateOfficeApi =
            EZCheckApi.validateOffice +
            '?latitude=' +
            encodeURIComponent(currentLatitude) +
            '&longitude=' +
            encodeURIComponent(currentLongitude) +
            '&secretCode=' +
            encodeURIComponent(secretCode);
          // console.log('validateOfficeApi', validateOfficeApi);
          dispatch(validateOffice(validateOfficeApi)).then(res => {
            setShowingLoadingLocationModal(false);
          });
        }
      },
      error => {
        setShowingLoadingLocationModal(false);
        // See error code charts below.
        if (!showingAlert) {
          setShowingAlert(true);
          Alert.alert(
            'Alert',
            'Error ' + error.message,
            [
              {
                text: 'Cancel',
                style: 'cancel',
                onPress: () => {
                  setShowingAlert(false);
                  setTimeout(
                    () => (shouldHandleAppStateChange.current = true),
                    100,
                  );
                },
              },
              {
                text: 'Go to settings',
                onPress: () => {
                  setShowingAlert(true);
                  shouldHandleAppStateChange.current = true;
                  Linking.openSettings();
                },
              },
            ],
            {cancelable: false},
          );
        }
      },
      {timeout: 12000},
    );
    setShowingLoadingLocationModal(false);
  };

  const startNotInOfficeLocationFetchingLoop = () => {
    var locationNotInOfficeFetchTimer = setTimeout(() => {
      if (appState === 'active') {
        startNotInOfficeLocationFetchingLoop();
        shouldHandleAppStateChange.current = false;
        const afterValidateOffice = inOffice => {
          if (inOffice) {
            try {
              if (locationNotInOfficeFetchTimer != null) {
                clearTimeout(locationNotInOfficeFetchTimer);
                locationNotInOfficeFetchTimer = null;
              }
            } catch (err) {
              console.log(err);
            } finally {
              startInOfficeLocationFetchingLoop();
            }
          } else {
            //if this schedule location fetch overlap the refreshGeolocation validateoffice, the timers will be clear by the
            //refresh geo process but the timer cant be restart since 'afterValidate' function of the refresh geo process
            // does not run, instead this function will run when validation is completed. So it's important to check if
            //such situation happens
            if (
              locationNotInOfficeFetchTimer == null &&
              appState === 'active'
            ) {
              startNotInOfficeLocationFetchingLoop();
            }
          }
          if (showingLoadingLocationModal) {
            setShowingLoadingLocationModal(false);
          }
          shouldHandleAppStateChange.current = true;
        };
        getUserCurrentLocation(afterValidateOffice);
      }
    }, 10000);
  };
  const startInOfficeLocationFetchingLoop = () => {
    var locationInOfficeFetchTimer = setTimeout(() => {
      if (appState === 'active') {
        startInOfficeLocationFetchingLoop();
        shouldHandleAppStateChange.current = false;
        const afterValidateOffice = inOffice => {
          if (!inOffice) {
            try {
              if (locationInOfficeFetchTimer != null) {
                clearTimeout(locationInOfficeFetchTimer);
                locationInOfficeFetchTimer = null;
              }
            } catch (err) {
              console.log(err);
            } finally {
              startNotInOfficeLocationFetchingLoop();
            }
          } else {
            if (locationInOfficeFetchTimer == null && appState === 'active') {
              startInOfficeLocationFetchingLoop();
            }
          }
          if (showingLoadingLocationModal) {
            showingLoadingLocationModal(false);
          }
          shouldHandleAppStateChange.current = true;
        };
        getUserCurrentLocation(afterValidateOffice);
      }
    }, 120000);
  };

  const handleBackButton = () => {
    return true;
  };
  const handleAppStateChange = nextAppState => {
    const currentAppState = appState;
    if (
      currentAppState.match(/inactive|background/) &&
      nextAppState === 'active'
    ) {
      console.log('/inactive|background/');
      if (isAtOffice) {
        dispatch(checkWorkingStatus());
      }
      if (shouldHandleAppStateChange.current) {
        refreshGeolocation();
      }
    }
    if (
      currentAppState === 'active' &&
      nextAppState.toString().match(/inactive|background/)
    ) {
      console.log('active');
      if (isAtOffice) {
        dispatch(checkWorkingStatus());
      }
      if (shouldHandleAppStateChange.current) {
      }
    }
    setAppState(nextAppState.toString());
  };

  const refreshGeolocation = () => {
    shouldHandleAppStateChange.current = false;
    getUserCurrentLocation();
  };

  useEffect(() => {
    checkLocationPermission();
    dispatch(getUserInfo());
    dispatch(getUserPermissions());
    // Handle back button
    BackHandler.addEventListener('hardwareBackPress', handleBackButton);
    AppState.addEventListener('change', handleAppStateChange);
  }, []);

  const homeProps = {
    isAtOffice,
    navigation,
    refreshGeolocation,
    showingLoadingLocationModal,
    officeInfo,
    isWorkingStatus,
    userInfo,
    currentLatitude,
    currentLongitude,
  };

  return <HomeMainView {...propsProvider(homeProps)} />;
};

export default HomeContainer;
