import {createAsyncThunk, createSlice} from '@reduxjs/toolkit';

import homeAPI from '../../api/homeAPI';
import serviceRequest from '../../app/serviceRequest';
import {alertErrorMessage} from '../../actions/AlertAction';
import Utils from '../../utils';
import {storeKey} from '../../config/config';

const initial = {
  listEvent: [],
  officeInfo: null,
  isAtOffice: false,
  isWorkingStatus: false,
  isChecking: false,
  currentLongitude: 0,
  currentLatitude: 0,
  userInfo: null,
};

export const getUserInfo = createAsyncThunk('home', async (data, thunkAPI) => {
  return serviceRequest({
    dispatch: thunkAPI.dispatch,
    serviceMethod: homeAPI.requestGetUserInfo,
    payload: data,
    options: {
      skipLoader: false,
    },
  });
});
export const getUserPermissions = createAsyncThunk(
  'home/getUserPermissions',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: homeAPI.requestGetUserPermissions,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const validateOffice = createAsyncThunk(
  'home/validateOffice',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: homeAPI.requestGetValidateOffice,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const checkWorkingStatus = createAsyncThunk(
  'home/checkWorkingStatus',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: homeAPI.requestGetCheckWorkingStatus,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const checkIn = createAsyncThunk(
  'home/checkIn',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: homeAPI.requestCheckIn,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const checkOut = createAsyncThunk(
  'home/checkOut',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: homeAPI.requestCheckOut,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const getAttendanceLog = createAsyncThunk(
  'home/getAttendanceLog',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: homeAPI.requestCheckOut,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);
export const getBannerImages = createAsyncThunk(
  'home/getBannerImages',
  async (data, thunkAPI) => {
    return serviceRequest({
      dispatch: thunkAPI.dispatch,
      serviceMethod: homeAPI.requestGetBannerImages,
      payload: data,
      options: {
        skipLoader: false,
      },
    });
  },
);

const homeSlice = createSlice({
  name: 'home',
  initialState: initial,
  reducers: {},
  extraReducers: builder => {
    builder.addCase(getUserInfo.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        state.userInfo = Utils.getValues(action, 'payload.user', null);
      }
    });
    builder.addCase(getUserPermissions.fulfilled, (state, action) => {});
    builder.addCase(validateOffice.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        const {latitude, longitude} = Utils.getValues(
          action,
          'payload.data',
          0,
        );
        state.currentLatitude = latitude;
        state.currentLongitude = longitude;
        state.isAtOffice = true;
        state.officeInfo = Utils.getValues(action, 'payload.data', false);
      }
    });
    builder.addCase(checkWorkingStatus.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        // state.isWorkingStatus = true;
      }
    });
    builder.addCase(checkIn.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        state.isWorkingStatus = true;
      }
    });
    builder.addCase(checkOut.fulfilled, (state, action) => {
      const {success} = Utils.getValues(action, 'payload', false);
      if (success) {
        state.isWorkingStatus = false;
      }
    });
  },
});

const {reducer, actions} = homeSlice;
export default reducer;
