import React from 'react';
import HomeContainer from './homeContainer';
import {useSelector} from 'react-redux';
import {homeSelector} from '../../app/selectors';
const Home = props => {
  const {navigation} = props;
  const homeSelect = useSelector(homeSelector);

  const {
    isAtOffice,
    officeInfo,
    isWorkingStatus,
    currentLatitude,
    currentLongitude,
    userInfo,
  } = homeSelect;

  const homeProps = {
    isAtOffice,
    officeInfo,
    navigation,
    isWorkingStatus,
    currentLatitude,
    currentLongitude,
    userInfo,
  };
  return <HomeContainer {...homeProps} />;
};

export default Home;
