import {Platform, StyleSheet} from 'react-native';
import colors from '../../values/color';
import {
  widthPercentageToDP as wp,
  heightPercentageToDP as hp,
} from 'react-native-responsive-screen';
const wratio = wp('100%') / 375;
const hratio = hp('100%') / 812;
const homeStyles = StyleSheet.create({
  container: {
    flex: 1,
  },
  activityIndicatorContainer: {
    position: 'absolute',
    top: 0,
    left: 0,
    bottom: 0,
    right: 0,
    backgroundColor: colors.white,
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
});
const inOfficeStyles = StyleSheet.create({
  main: {
    flex: 1,
    backgroundColor: colors.white,
  },
  checkInButton: {
    borderColor: 'rgba(0,0,0,0.2)',
    alignSelf: 'center',
    justifyContent: 'center',
    width: 343 * wratio,
    height: 48,
    backgroundColor: colors.primary_blue,
    borderRadius: 40,
    color: colors.white,
  },
  checkInButtonText: {
    color: colors.light_grey,
    fontSize: 16,
    alignSelf: 'center',
    fontFamily: 'Nunito-Bold',
  },
  checkOutButton: {
    borderColor: 'rgba(0,0,0,0.2)',
    alignSelf: 'center',
    justifyContent: 'center',
    width: 343 * wratio,
    height: 48,
    backgroundColor: colors.orange,
    borderRadius: 40,
    color: colors.white,
  },
  checkOutButtonText: {
    color: colors.light_grey,
    fontSize: 16,
    alignSelf: 'center',
    fontFamily: 'Nunito-Bold',
  },
  main_title: {
    alignItems: 'center',
    width: '100%',
    height: 50,
    borderColor: '#f2f2f2',
    borderWidth: 1,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
  },

  header_title: {
    fontSize: 20,
    alignSelf: 'center',
  },
  timeImage: {
    width: wp('100%'),
    height: hp('100%'),
    position: 'absolute',
    top: 0,
    left: 0,
    right: 0,
  },
  container: {
    //height: hp('20%'),
    width: wp('100%'),
    flexDirection: 'column',
    backgroundColor: colors.white,
    position: 'absolute',
    flex: 1,
    //top: hp('65%'),
    bottom: 0,
    borderTopLeftRadius: 40,
  },
  locationScroll: {
    maxHeight: 100,
    borderColor: '#EAEAEA',
    borderWidth: 1,
    borderRadius: 16,
    marginHorizontal: 12,
    marginTop: 20,
  }, //<ScrollView showsVerticalScrollIndicator={false} style={styles.locationScroll}>
  locationView: {
    width: wp('90%'),
    alignSelf: 'center',
    padding: 12,

    //borderColor: '#EAEAEA',
    //borderWidth: 1,
    //padding: 12,
    //borderRadius: 16,
    //marginTop: 20,
  },
  icMapPin: {
    justifyContent: 'center',
  },
  locationContainer: {
    width: wp('78%'),
    flexDirection: 'row',
    justifyContent: 'flex-start',
  },
  locationInLine: {
    flexDirection: 'row',
    alignContent: 'flex-start',
    flexWrap: 'wrap',
  },
  locationTitle: {
    color: colors.dark_grey,
    fontSize: 16,
    marginLeft: 4,
    marginRight: 5,
    fontFamily: 'Nunito-Bold',
  },
  locationAddress: {
    marginLeft: 16,
  },
  locationContent: {
    color: colors.medium_grey,
    fontSize: 14,
    marginLeft: 4,
    fontFamily: 'Nunito-Regular',
  },
  isAtOffice: {
    color: colors.green,
    fontSize: 16,
    fontFamily: 'Nunito-Bold',
  },
  time: {
    color: colors.primary_blue,
    fontSize: 40,
    fontWeight: 'normal',
  },
  buttonView: {
    justifyContent: 'center',
    marginTop: 20,
    marginBottom: 15,
  },
  header: {
    alignSelf: 'flex-end',
    marginTop: 75 * hratio,
    height: 35,
    justifyContent: 'center',
    backgroundColor: 'rgba(15,15,15,0.25)',
    borderBottomLeftRadius: 4,
    borderTopLeftRadius: 4,
  },
  userAvatar: {
    width: 20,
    height: 20,
    borderRadius: 50,
    marginHorizontal: 10,
    borderWidth: 1,
    borderColor: colors.white,
  },
  greeting: {
    fontSize: 14,
    fontFamily: 'Nunito-Regular',
    paddingRight: 10,
    color: colors.white,
  },
  date: {
    fontWeight: 'normal',
    fontSize: 18,
  },
  timeView: {
    flexDirection: 'row',
    width: wp('80%'),
    marginLeft: 40,
    marginBottom: 10,
  },
  timeColumn: {
    flexDirection: 'column',
    justifyContent: 'space-between',
  },
  timeTitle: {
    fontSize: 16,
    color: colors.black,
    marginBottom: 20,
    fontFamily: 'Nunito-Bold',
    flexDirection: 'row',
  },
  timeContent: {
    marginLeft: 8,
    fontSize: 16,
    fontWeight: 'bold',
    color: colors.primary_blue,
    alignSelf: 'flex-start',
    marginBottom: 20,
  },
  timeInLineSuccess: {
    flexDirection: 'row',
    justifyContent: 'center',
  },
  timeTitleSuccess: {
    fontSize: 14,
    alignSelf: 'flex-start',
    color: colors.black,
  },
  timeContentSuccess: {
    marginLeft: 8,
    fontSize: 16,
    fontWeight: 'bold',
    color: colors.primary_blue,
    alignSelf: 'flex-start',
  },
  modalText: {
    textAlign: 'center',
  },
  modalImage: {
    height: 330,
    width: 350,
    alignSelf: 'center',
    resizeMode: 'center',
    marginTop: 30,
    marginBottom: 20,
  },
  modalMessage: {
    height: hp('15%'),
    flexDirection: 'column',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  checkSuccess: {
    justifyContent: 'center',
    alignSelf: 'center',
    fontWeight: 'bold',
    fontSize: 24,
    color: colors.primary_blue,
  },
  modalFooter: {
    height: hp('20%'),
    width: wp('100%'),
    justifyContent: 'center',
    alignItems: 'center',
  },
  textMessage: {
    fontSize: 14,
    alignSelf: 'center',
    color: colors.black,
  },

  ///new styles

  buttonLogin: {
    marginLeft: 30,
    marginTop: 30,
    textAlign: 'center',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: colors.primary_blue,
    width: wp('100%') - 80,
    height: 40,
    borderRadius: 19,
    zIndex: 100,
    padding: 20,
  },
  buttonText: {
    color: colors.white,
    backgroundColor: 'transparent',
    fontFamily: 'Nunito-Bold',
    fontSize: 15,
    fontWeight: '500',
    letterSpacing: 1,
  },
  modalConfirm: {
    width: wp('100%'),
    height: hp('40%'),
    flexDirection: 'column',
    alignItems: 'center',
    backgroundColor: colors.red,
  },
  modalConfirmContent: {
    width: wp('90%'),
    height: hp('35%'),
    marginTop: -5,
    flexDirection: 'column',
  },
  modalConfirmContainer: {
    width: wp('90%'),
    height: hp('35%'),
    flexDirection: 'column',
    justifyContent: 'space-around',
  },
  modalConfirmTitle: {
    width: wp('100%'),
    justifyContent: 'center',
    alignSelf: 'center',
    fontSize: 16,
    textAlign: 'center',
    fontFamily: 'Nunito-Bold',
  },
  buttonContainer: {
    flexDirection: 'column',
    alignSelf: 'center',
    height: hp('15%'),
  },
  positiveButton: {
    alignSelf: 'center',
    justifyContent: 'center',
    width: wp('80%'),
    height: 48,
    backgroundColor: colors.primary_blue,
    borderRadius: 40,
    marginBottom: 20,
  },
  negativeButton: {
    borderWidth: 1,
    borderColor: colors.primary_blue,
    alignSelf: 'center',
    justifyContent: 'center',
    width: wp('80%'),
    height: 48,
    backgroundColor: colors.white,
    borderRadius: 40,
  },
  positiveButtonText: {
    color: colors.white,
    fontWeight: 'normal',
    fontSize: 14,
    alignSelf: 'center',
    fontFamily: Platform.OS === 'ios' ? 'System' : 'Nunito-Bold',
    paddingBottom: 15,
    paddingTop: 15,
  },
  negativeButtonText: {
    color: colors.primary_blue,
    fontWeight: 'normal',
    fontSize: 14,
    alignSelf: 'center',
    fontFamily: Platform.OS === 'ios' ? 'System' : 'Nunito-Bold',
    paddingBottom: Platform.OS === 'ios' ? 30 : 15,
    paddingTop: 15,
  },
  slideDownButton: {
    height: 3,
    width: 50,
    backgroundColor: colors.medium_grey,
    alignSelf: 'center',
    borderRadius: 5,
  },
  checkInValue: {
    fontSize: 16,
    color: colors.primary_blue,
    marginBottom: 20,
    fontFamily: 'Nunito-Bold',
  },
  loadingIndicator: {
    position: 'absolute',
    top: hp('40%'),
    alignSelf: 'center',
  },
});
const notInOfficeStyles = StyleSheet.create({
  main: {
    flex: 1,
    backgroundColor: colors.white,
  },
  main_title: {
    alignItems: 'center',
    width: '100%',
    height: 50,
    borderColor: '#f2f2f2',
    borderWidth: 1,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
  },
  timeImage: {
    width: wp('100%'),
    height: hratio * 540,
    top: 0,
    justifyContent: 'center',
  },
  headerContainer: {
    height: '50%',
  },
  header: {
    height: '100%',
    // backgroundColor: colors.primary_blue,
    justifyContent: 'center',
    alignItems: 'flex-end',
    paddingBottom: hp('7%'),
    flex: 1,
    flexDirection: 'row',
  },
  headerBackIconBtn: {
    color: 'white',
    position: 'absolute',
    top: 60,
    left: 30,
  },
  bgNotInOfficeContent: {
    // marginTop: -(100*hratio),
  },
  container: {
    paddingTop: 10,
    height: '52%',
    marginTop: '-10%',
    width: wp('100%'),
    flexDirection: 'column',
    justifyContent: 'space-around',
    backgroundColor: colors.white,
    borderTopLeftRadius: 40,
    paddingBottom: 5,
  },
  locationView: {
    width: wp('90%'),
    alignSelf: 'center',
    borderColor: '#EAEAEA',
    borderWidth: 1,
    padding: 14,
    borderRadius: 16,
    marginTop: 10,
  },
  icMapPin: {
    marginRight: 5,
    height: 16,
    width: 16,
    justifyContent: 'center',
  },
  locationContainer: {
    flexDirection: 'row',
  },
  locationInLine: {
    flex: 1,
    flexWrap: 'wrap',
    height: 24,
    flexDirection: 'row',
    alignContent: 'flex-start',
  },
  locationTitle: {
    color: colors.dark_grey,
    fontSize: 14,
    marginLeft: 4,
    marginRight: 5,
    fontFamily: 'Nunito-Bold',
  },
  address: {
    marginTop: 15,
    marginLeft: 21,
  },
  locationContent: {
    color: colors.medium_grey,
    fontSize: 14,
    marginLeft: 4,
    fontFamily: 'Nunito-Regular',
  },
  isAtOffice: {
    color: colors.green,
    fontSize: 14,
    fontFamily: 'Nunito-Bold',
  },
  isNotAtOffice: {
    color: colors.red,
    fontSize: 14,
    fontFamily: 'Nunito-Bold',
  },
  notAtOfficeMessage: {
    color: colors.dark_grey,
    width: wp('80'),
    fontSize: 18,
    textAlign: 'center',
    alignSelf: 'center',
    marginTop: 8,
    fontFamily: 'Nunito-Bold',
    padding: 5,
  },
  refreshContainer: {
    flexDirection: 'row',
    alignItems: 'center',
    alignSelf: 'center',
    paddingLeft: 36,
    paddingRight: 36,
    paddingTop: 5,
    paddingBottom: 5,
    textAlign: 'center',
    backgroundColor: colors.white,
  },
  refreshText: {
    height: 24,
    color: colors.primary_blue,
    fontSize: 16,
    paddingLeft: 5,
    fontFamily: 'Nunito-Bold',
  },
});
const attendanceCheckModalStyles = StyleSheet.create({
  modalContent: {
    flex: 1,
    width: wp('100%'),
    height: hp('100%'),
    alignItems: 'center',
  },
  headerPic: {
    marginTop: hp('15%'),
  },
  modalMessage: {
    alignItems: 'center',
    justifyContent: 'center',
    marginTop: 32,
    fontFamily: 'Nunito-Regular',
  },
  checkInSuccess: {
    fontSize: 20,
    color: colors.primary_blue,
    fontFamily: 'Merriweather-Bold',
  },
  checkOutSuccess: {
    fontSize: 20,
    color: colors.orange,
    fontFamily: 'Merriweather-Bold',
  },
  timeTitleSuccess: {
    fontSize: 16,
    flexDirection: 'row',
    marginTop: 16,
    color: colors.black,
    fontFamily: 'Nunito-Bold',
  },
  timeContentSuccess: {
    marginLeft: 8,
    fontSize: 16,
    color: colors.primary_blue,
    fontFamily: 'Nunito-Regular',
  },

  textMessage: {
    width: hp('100%'),
    fontSize: 16,
    marginTop: hp('2%'),
    color: colors.black,
    alignSelf: 'flex-start',
    fontFamily: 'Nunito-Regular',
    textAlign: 'center',
  },

  modalFooter: {
    height: hp('20%'),
    width: wp('100%'),
    justifyContent: 'center',
    alignItems: 'flex-end',
    position: 'absolute',
    bottom: 0,
  },
  checkInButton: {
    borderColor: 'rgba(0,0,0,0.2)',
    alignSelf: 'center',
    justifyContent: 'center',
    width: 320 * wratio,
    height: 48,
    backgroundColor: colors.primary_blue,
    borderRadius: 40,
    color: colors.white,
  },

  checkInButtonText: {
    color: colors.white,
    fontSize: 16,
    alignSelf: 'center',
    fontFamily: 'Nunito-Bold',
  },

  IcCancel: {
    position: 'absolute',
    top: 50,
    left: 20,
  },
});

export {inOfficeStyles, notInOfficeStyles, attendanceCheckModalStyles};
export default homeStyles;
