import React from 'react';
import {ActivityIndicator, Text, View} from 'react-native';
import colors from '../../../values/color.js';
import homeStyles from '../styles';
import InOffice from './subViews/InOffice.js';
import NotInOffice from './subViews/NotInOffice';
const HomeMainView = props => {
  const {
    isAtOffice,
    navigation,
    refreshGeolocation,
    showingLoadingLocationModal,
    officeList,
    officeInfo,
    inOfficeProps,
  } = props;
  return (
    <View style={{flex: 1}}>
      <>
        {!isAtOffice ? (
          <NotInOffice
            refreshGeolocation={refreshGeolocation}
            officeList={officeList}
          />
        ) : (
          <InOffice {...inOfficeProps} />
        )}
      </>
      {showingLoadingLocationModal && (
        <View style={homeStyles.activityIndicatorContainer}>
          <ActivityIndicator size="large" color={colors.primary_blue} />
        </View>
      )}
    </View>
  );
};

export default HomeMainView;
