import moment from 'moment';
import React from 'react';
import {Modal, Text, TouchableOpacity, View} from 'react-native';
import {
  BgConfirmCheckInSuccess,
  BgConfirmCheckOutSuccess,
  IcCancel,
} from '../../../../values/images';
import strings from '../../../../values/strings.js';
import {attendanceCheckModalStyles} from '../../styles.js';
const AttendanceCheckModal = ({visible, toggleModal, isCheckIn}) => {
  return (
    <Modal visible={visible} animationType="slide">
      <View style={attendanceCheckModalStyles.modalContent}>
        {isCheckIn ? (
          <BgConfirmCheckInSuccess
            style={attendanceCheckModalStyles.headerPic}
          />
        ) : (
          <BgConfirmCheckOutSuccess
            style={attendanceCheckModalStyles.headerPic}
          />
        )}
        <TouchableOpacity
          activeOpacity={0.8}
          onPress={() => toggleModal()}
          style={attendanceCheckModalStyles.IcCancel}>
          <IcCancel />
        </TouchableOpacity>

        <View style={attendanceCheckModalStyles.modalMessage}>
          {isCheckIn ? (
            <Text style={attendanceCheckModalStyles.checkInSuccess}>
              {strings.CheckInSuccessTitle}
            </Text>
          ) : (
            <Text style={attendanceCheckModalStyles.checkOutSuccess}>
              {strings.CheckOutSuccessTitle}
            </Text>
          )}
          <Text style={attendanceCheckModalStyles.timeTitleSuccess}>
            {isCheckIn
              ? strings.CheckInSuccessTime
              : strings.CheckOutSuccessTime}
            <Text style={attendanceCheckModalStyles.timeContentSuccess}>
              {moment(moment()).format('HH : mm : ss')}
            </Text>
          </Text>
          <Text style={attendanceCheckModalStyles.textMessage}>
            {isCheckIn
              ? strings.CheckInSuccessMessage
              : strings.CheckOutSuccessMessage}
          </Text>
        </View>
        <View style={attendanceCheckModalStyles.modalFooter}>
          <TouchableOpacity
            delayPressIn={0}
            activeOpacity={0.8}
            style={attendanceCheckModalStyles.checkInButton}
            onPress={() => toggleModal()}>
            <Text style={attendanceCheckModalStyles.checkInButtonText}>OK</Text>
          </TouchableOpacity>
        </View>
      </View>
    </Modal>
  );
};
export default AttendanceCheckModal;
