import React, {Component} from 'react';
import {
  View,
  Modal,
  StyleSheet,
  Dimensions,
  Text,
  TouchableWithoutFeedback,
} from 'react-native';
import colors from '../../../../values/color.js';
import {Animated} from 'react-native';

export default class BottomModal extends Component {
  constructor(props) {
    super(props);
    const {height} = Dimensions.get('window');
    this.height = height;
    this.state = {
      top: new Animated.Value(900),
    };
  }

  clickOutsideModal() {
    this.props.outsideClick();
  }

  render() {
    const modalHeight = this.props.bottomHalf ? this.height * 0.6 : this.height;
    const styles = StyleSheetFactory.getSheet({
      boxBgColor: this.props.boxBackgroundColor,
      fullscreen: this.props.fullscreen,
      modalHeight: modalHeight,
      bottomHalf: this.props.bottomHalf,
    });
    
    return (
      <Modal
        onPress={() => this.clickOutsideModal()}
        animationType={this.props.animation}
        transparent={true}
        visible={this.props.visible}
        presentationStyle={this.props.mode}>
        <View style={styles.mainContainer}>
          <TouchableWithoutFeedback onPress={() => this.clickOutsideModal()}>
            <View style={styles.background} />
          </TouchableWithoutFeedback>   
          <View style={styles.modalWrapper}>
            <View style={styles.modalContainer}>{this.props.children}</View>
          </View>
        </View>
      </Modal>
    );
  }
}

class StyleSheetFactory {
  static getSheet({fullscreen, bottomHalf, modalHeight}) {
    const styles = StyleSheet.create({
      mainContainer: {flex: 1},
      background: {
        position: 'absolute',
        top: 0,
        bottom: 0,
        left: 0,
        right: 0,
        backgroundColor: 'rgba(0,0,0,0.8)',
      },
      modalWrapper: {
        justifyContent: 'center',
        alignItems: 'center',
        backgroundColor: 'transparent',
        height: modalHeight,
      },
      modalContainer: {
        backgroundColor: colors.white,
        paddingHorizontal: 20,
        paddingVertical: 10,
        borderRadius: 30,
        shadowColor: '#000',
        shadowOffset: {width: 0, height: 2},
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
      },
    });

    if (fullscreen) {
      styles.modalWrapper = {
        ...styles.modalWrapper,
        flex: 1,
      };

      styles.modalContainer = {
        ...styles.modalContainer,
        flex: 1,
      };
    } else if (bottomHalf) {
      styles.modalWrapper = {
        ...styles.modalWrapper,
        marginTop: modalHeight - 20,
      };

      styles.modalContainer = {
        ...styles.modalContainer,
        flex: 1,
      };
    } else {
      styles.modalWrapper = {
        ...styles.modalWrapper,
        flex: 1,
      };

      styles.modalContainer = {
        ...styles.modalContainer,
        marginHorizontal: 10,
      };
    }

    return styles;
  }
}
