// export default InOffice;
import moment from 'moment';
import React, {useState} from 'react';
import {
  ActivityIndicator,
  Animated,
  Image,
  ImageBackground,
  Keyboard,
  ScrollView,
  Text,
  TouchableOpacity,
  View,
} from 'react-native';
import {useDispatch} from 'react-redux';
import EZCheckApi from '../../../../api/network/AppApi.js';
import DefaultBGImage from '../../../../assets/images/bg_home.png';
import colors from '../../../../values/color.js';
import {IcDefaultUserPlaceholder, IcMapPin} from '../../../../values/images';
import strings from '../../../../values/strings.js';
import {checkIn, checkOut, getAttendanceLog} from '../../homeSlice.js';
import {inOfficeStyles} from '../../styles.js';
import AttendanceCheckModal from './AttendanceCheckModal';
import BottomModal from './BottomModal';
const InOffice = props => {
  const {
    currentLongitude,
    currentLatitude,
    userInfo,
    officeInfo,
    isWorkingStatus,
  } = props;
  const dispatch = useDispatch();
  const [visible, setIsVisible] = useState(false);
  const [visibleAttendanceCheckModal, setVisibleAttendanceCheckModal] =
    useState(false);
  const [startTime, setStartTime] = useState('');
  const [greeting, setGreeting] = useState('');
  const [userAvatarUri, setUserAvatarUri] = useState(
    'assets/images/ic_default_user_icon.svg',
  );
  const [visibleBanner, setIsVisibleBanner] = useState(false);
  const [loadingState, setLoadingState] = useState(0);

  const toggleAttendanceCheckModal = () =>
    setVisibleAttendanceCheckModal(!visibleAttendanceCheckModal);

  const attendanceCheck = async () => {
    if (isWorkingStatus) {
      setIsVisible(true);
    } else {
      let checkInApi =
        EZCheckApi.checkIn +
        '?latitude=' +
        encodeURIComponent(currentLatitude) +
        '&longitude=' +
        encodeURIComponent(currentLongitude);
      console.log('checkInApi', checkInApi);
      dispatch(checkIn(checkInApi));
      if (startTime === '') {
        getCheckInTime();
      }
      // setIsVisible(true);
      toggleAttendanceCheckModal();
    }
  };

  const getCheckInTime = () => {
    if (startTime === '') {
      let startMonth = moment(moment()).startOf('month').format();
      let endMonth = moment(moment()).endOf('month').format();
      let getMyInOutLog =
        EZCheckApi.myInOutLog +
        '?start=' +
        encodeURI(moment(startMonth).format('YYYY-MM-DD 00:00')) +
        '&finish=' +
        encodeURI(moment(endMonth).format('YYYY-MM-DD 23:59'));
      dispatch(getAttendanceLog(getMyInOutLog));
    }
  };

  const toggleConfirmModal = async () => {
    let checkOutApi =
      EZCheckApi.checkOut +
      '?latitude=' +
      encodeURIComponent(currentLatitude) +
      '&longitude=' +
      encodeURIComponent(currentLongitude);
    dispatch(checkOut(checkOutApi)).then(response => {
      console.log('response', response);
      setIsVisible(false);
      Keyboard.dismiss();
      toggleAttendanceCheckModal();
    });
    // Fix case keyboard sometime appear after check-in/check-out
  };

  const checkAttendance = () => {
    attendanceCheck();
    Keyboard.dismiss();
  };
  return (
    <View style={inOfficeStyles.main}>
      <BottomModal
        animation="fade"
        visible={visible}
        mode="overFullScreen"
        bottomHalf={true}
        outsideClick={() => {
          setIsVisible(false);
        }}>
        <View style={inOfficeStyles.modalConfirmContent}>
          <View style={inOfficeStyles.slideDownButton} />
          <View style={inOfficeStyles.modalConfirmContainer}>
            <View>
              <Text style={inOfficeStyles.modalConfirmTitle} numberOfLines={2}>
                {strings.ConfirmCheckOutTitle}
              </Text>
            </View>
            <View style={inOfficeStyles.buttonContainer}>
              <TouchableOpacity
                delayPressIn={0}
                activeOpacity={0.8}
                style={inOfficeStyles.positiveButton}
                onPress={() => toggleConfirmModal()}>
                <View>
                  <Text style={inOfficeStyles.positiveButtonText}>
                    {strings.ConfirmModalYesButtonTitle}
                  </Text>
                </View>
              </TouchableOpacity>
              <TouchableOpacity
                delayPressIn={0}
                activeOpacity={0.3}
                style={inOfficeStyles.negativeButton}
                onPress={() => {
                  setIsVisible(false);
                }}>
                <View>
                  <Text style={inOfficeStyles.negativeButtonText}>
                    {strings.ConfirmModalCancelButtonTitle}
                  </Text>
                </View>
              </TouchableOpacity>
            </View>
          </View>
        </View>
      </BottomModal>

      <AttendanceCheckModal
        isCheckIn={isWorkingStatus}
        visible={visibleAttendanceCheckModal}
        toggleModal={toggleAttendanceCheckModal}
      />
      {loadingState === -1 ? (
        <View style={{...inOfficeStyles.timeImage, backgroundColor: '#ccc'}}>
          <Animated.View>
            <View style={inOfficeStyles.header}>
              <View style={{flexDirection: 'row', textAlign: 'left'}}>
                {userAvatarUri !== null ? (
                  <Image
                    style={inOfficeStyles.userAvatar}
                    source={{uri: userAvatarUri}}
                  />
                ) : (
                  <IcDefaultUserPlaceholder />
                )}
                <Text style={inOfficeStyles.greeting}>
                  {greeting}
                  {userInfo?.first_name}
                </Text>
              </View>
            </View>
          </Animated.View>
          <ActivityIndicator
            style={inOfficeStyles.loadingIndicator}
            color={colors.secondary_grey}
          />
        </View>
      ) : (
        <ImageBackground
          source={loadingState === 1 ? {uri: visibleBanner} : DefaultBGImage}
          style={inOfficeStyles.timeImage}>
          <Animated.View>
            <View style={inOfficeStyles.header}>
              <View style={{flexDirection: 'row', textAlign: 'left'}}>
                {userAvatarUri !== null ? (
                  <Image
                    style={inOfficeStyles.userAvatar}
                    source={{uri: userAvatarUri}}
                  />
                ) : (
                  <IcDefaultUserPlaceholder />
                )}
                <Text style={inOfficeStyles.greeting}>
                  {greeting}
                  {userInfo?.first_name}
                </Text>
              </View>
            </View>
          </Animated.View>
        </ImageBackground>
      )}

      <View style={inOfficeStyles.container}>
        <ScrollView
          bounces={false}
          showsVerticalScrollIndicator={false}
          style={inOfficeStyles.locationScroll}>
          <View style={inOfficeStyles.locationView}>
            <View style={inOfficeStyles.locationContainer}>
              <View style={inOfficeStyles.icMapPin}>
                <IcMapPin />
              </View>
              <View style={inOfficeStyles.locationInLine}>
                <Text style={inOfficeStyles.locationTitle}>
                  {officeInfo.name ?? '...'}
                </Text>
                <Text
                  style={[
                    inOfficeStyles.isAtOffice,
                    officeInfo?.length >= 25
                      ? {paddingLeft: 5}
                      : {paddingLeft: 0},
                  ]}>
                  {strings.IsAtOffice}
                </Text>
              </View>
            </View>

            <View style={inOfficeStyles.locationAddress}>
              <Text style={inOfficeStyles.locationContent}>
                {officeInfo?.full_address ?? '...'}
              </Text>
            </View>
          </View>
        </ScrollView>
        <View style={inOfficeStyles.buttonView}>
          <TouchableOpacity
            delayPressIn={0}
            activeOpacity={0.8}
            style={
              isWorkingStatus
                ? inOfficeStyles.checkOutButton
                : inOfficeStyles.checkInButton
            }
            onPress={() => checkAttendance()}>
            <View>
              <Text
                style={
                  isWorkingStatus
                    ? inOfficeStyles.checkOutButtonText
                    : inOfficeStyles.checkInButtonText
                }>
                {isWorkingStatus
                  ? strings.CheckOutButton
                  : strings.CheckInButton}
              </Text>
            </View>
          </TouchableOpacity>
        </View>
      </View>
    </View>
  );
};

export default InOffice;
