import moment from 'moment';
import React, {Component} from 'react';
import {FlatList, Text, TouchableOpacity, View} from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import {
  BgNotInOfficeContent,
  IcMapPin,
  IcRefreshCircle,
} from '../../../../values/images';
import {notInOfficeStyles} from '../../styles';
import {NotInOfficeEmptyView} from './EmptyView';
const NotInOffice = ({refreshGeolocation, officeList = []}) => {
  const renderItem = item => {
    let locationOverflow = item.name.length >= 25;
    return (
      <View style={notInOfficeStyles.locationView}>
        <View style={notInOfficeStyles.locationContainer}>
          <View style={notInOfficeStyles.icMapPin}>
            <IcMapPin />
          </View>
          <View style={notInOfficeStyles.locationInLine}>
            <Text style={notInOfficeStyles.locationTitle}>{item.name}:</Text>
            {item.distance > 1000 ? (
              <Text
                style={[
                  notInOfficeStyles.isNotAtOffice,
                  locationOverflow ? {paddingLeft: 5} : {paddingLeft: 0},
                ]}>
                {Math.round(item.distance / 10) / 100} km{' '}
              </Text>
            ) : (
              <Text
                style={[
                  notInOfficeStyles.isNotAtOffice,
                  locationOverflow ? {paddingLeft: 5} : {paddingLeft: 0},
                ]}>
                {item.distance}
              </Text>
            )}
          </View>
        </View>

        <View
          style={[
            notInOfficeStyles.address,
            locationOverflow ? {marginTop: 15} : {marginTop: 0},
          ]}>
          <Text style={notInOfficeStyles.locationContent}>
            {item.full_address}
          </Text>
        </View>
      </View>
    );
  };
  const renderHeader = () => {
    return (
      <View style={notInOfficeStyles.headerContainer}>
        <LinearGradient
          start={{x: 0, y: 0}}
          end={{x: 1, y: 0}}
          useAngle={true}
          angle={75}
          locations={[0, 0.15, 1]}
          colors={['#1ef9ec', '#60bdff', '#1c6fef']}
          style={notInOfficeStyles.header}>
          <View style={notInOfficeStyles.bgNotInOfficeContent}>
            <BgNotInOfficeContent />
          </View>
        </LinearGradient>
      </View>
    );
  };

  return (
    <View style={notInOfficeStyles.main}>
      {renderHeader()}
      <View style={notInOfficeStyles.locationView}>
        <View style={notInOfficeStyles.locationContainer}>
          <View style={notInOfficeStyles.icMapPin}>
            <IcMapPin />
          </View>
        </View>
      </View>
      <View style={notInOfficeStyles.container}>
        <Text style={notInOfficeStyles.notAtOfficeMessage}>
          Bạn đang ở ngoài văn phòng
        </Text>
        <TouchableOpacity
          delayPressIn={0}
          style={notInOfficeStyles.refreshContainer}
          onPress={() => refreshGeolocation()}>
          <IcRefreshCircle />
          <Text style={notInOfficeStyles.refreshText}>Tải lại</Text>
        </TouchableOpacity>
        {officeList.length > 0 && (
          <FlatList
            bounces={false}
            data={officeList.data}
            renderItem={({item}) => renderItem(item)}
            keyExtractor={item => item.id}
          />
        )}
      </View>
    </View>
  );
};

export default NotInOffice;
