package Fosco.com.commom;
import io.github.bonigarcia.wdm.WebDriverManager;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.*;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.testng.ITestResult;
import org.testng.annotations.*;
import trinhQC.com.drivers.DriverManager;
import trinhQC.com.reports.ExtentReportManager;
import trinhQC.com.reports.ExtentReportTestManager;

import java.awt.*;
import java.io.File;
import java.io.IOException;

public class BaseTest {

    @BeforeMethod
    @Parameters({"browser"})
    public static void createDriver(@Optional("chrome") String browser) {
        WebDriver driver = setupDriver(browser);
        DriverManager.setDriver(driver);
    }

    public static WebDriver setupDriver(String browserName) {
        WebDriver driver;
        switch (browserName.trim().toLowerCase()) {
            case "edge":
                driver = initEdgeDriver();
                break;
            case "firefox":
                driver = initFirefoxDriver();
                break;
            case "chrome":
            default:
                System.out.println("Browser: " + browserName + " → launching Chrome by default...");
                driver = initChromeDriver();
        }
        return driver;
    }

    private static WebDriver initEdgeDriver() {
        System.out.println("Launching Edge browser...");
        WebDriverManager.edgedriver().setup();
        EdgeOptions options = new EdgeOptions();
        options.setAcceptInsecureCerts(true); // ✅ Bỏ qua lỗi HTTPS
        WebDriver driver = new EdgeDriver(options);
        driver.manage().window().maximize();
        return driver;
    }

    private static WebDriver initChromeDriver() {
        System.out.println("Launching Chrome browser...");
        WebDriverManager.chromedriver().setup();
        ChromeOptions options = new ChromeOptions();
        options.setAcceptInsecureCerts(true); // ✅ Bỏ qua lỗi HTTPS
        WebDriver driver = new ChromeDriver(options);
        driver.manage().window().maximize();
        return driver;
    }

    private static WebDriver initFirefoxDriver() {
        System.out.println("Launching Firefox browser...");
        WebDriverManager.firefoxdriver().setup();
        WebDriver driver = new FirefoxDriver();
        driver.manage().window().maximize();
        return driver;
    }

    @AfterMethod
    public void takeScreenshotOnFailure(ITestResult result) {
        // Chỉ thực hiện nếu test bị FAIL
        if (ITestResult.FAILURE == result.getStatus()) {
            WebDriver driver = DriverManager.getDriver(); // Lấy driver hiện tại

            if (driver != null) {
                try {
                    // Chụp ảnh màn hình
                    TakesScreenshot ts = (TakesScreenshot) driver;
                    File source = ts.getScreenshotAs(OutputType.FILE);

                    // Tạo thư mục nếu chưa tồn tại
                    String screenshotDir = "./screenshots";
                    File dir = new File(screenshotDir);
                    if (!dir.exists()) {
                        dir.mkdirs(); // tạo thư mục nếu chưa có
                    }

                    // Đặt tên file: tên của test case + .png
                    String screenshotName = result.getName() + ".png";
                    File destFile = new File(dir, screenshotName);

                    // Lưu file
                    FileUtils.copyFile(source, destFile);

                    // In ra đường dẫn ảnh lưu
                    System.out.println("✅ Screenshot saved: " + destFile.getAbsolutePath());

                } catch (IOException e) {
                    System.err.println("❌ Failed to save screenshot: " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                System.err.println("⚠️ WebDriver is null, cannot capture screenshot.");
            }
        }
    }
    @AfterMethod

    public void closeDriver() {

        if (DriverManager.getDriver() != null) {
            DriverManager.quit();
        }
    }
}