/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  Department,
  GetDepartmentParams,
  Response
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get
 */
export type getDepartmentIdResponse200 = {
  data: Response
  status: 200
}
    
export type getDepartmentIdResponseSuccess = (getDepartmentIdResponse200) & {
  headers: Headers;
};
;

export type getDepartmentIdResponse = (getDepartmentIdResponseSuccess)

export const getGetDepartmentIdUrl = (id: string,) => {


  

  return `/department/${id}`
}

export const getDepartmentId = async (id: string, options?: RequestInit): Promise<getDepartmentIdResponse> => {
  
  return useCustomClient<getDepartmentIdResponse>(getGetDepartmentIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetDepartmentIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/department/${id}`
    ] as const;
    }

export const getGetDepartmentIdQueryKey = (id?: string,) => {
    return [
    `/department/${id}`
    ] as const;
    }

    
export const getGetDepartmentIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getDepartmentId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetDepartmentIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getDepartmentId>>> = ({ signal }) => getDepartmentId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetDepartmentIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getDepartmentId>>>
export type GetDepartmentIdInfiniteQueryError = ErrorType<unknown>


export function useGetDepartmentIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getDepartmentId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getDepartmentId>>,
          TError,
          Awaited<ReturnType<typeof getDepartmentId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetDepartmentIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getDepartmentId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getDepartmentId>>,
          TError,
          Awaited<ReturnType<typeof getDepartmentId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetDepartmentIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getDepartmentId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetDepartmentIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getDepartmentId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetDepartmentIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetDepartmentIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getDepartmentId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetDepartmentIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetDepartmentIdQueryOptions = <TData = Awaited<ReturnType<typeof getDepartmentId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetDepartmentIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getDepartmentId>>> = ({ signal }) => getDepartmentId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetDepartmentIdQueryResult = NonNullable<Awaited<ReturnType<typeof getDepartmentId>>>
export type GetDepartmentIdQueryError = ErrorType<unknown>


export function useGetDepartmentId<TData = Awaited<ReturnType<typeof getDepartmentId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getDepartmentId>>,
          TError,
          Awaited<ReturnType<typeof getDepartmentId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetDepartmentId<TData = Awaited<ReturnType<typeof getDepartmentId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getDepartmentId>>,
          TError,
          Awaited<ReturnType<typeof getDepartmentId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetDepartmentId<TData = Awaited<ReturnType<typeof getDepartmentId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetDepartmentId<TData = Awaited<ReturnType<typeof getDepartmentId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetDepartmentIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetDepartmentIdQuery = async <TData = Awaited<ReturnType<typeof getDepartmentId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartmentId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetDepartmentIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putDepartmentIdResponse200 = {
  data: Response
  status: 200
}
    
export type putDepartmentIdResponseSuccess = (putDepartmentIdResponse200) & {
  headers: Headers;
};
;

export type putDepartmentIdResponse = (putDepartmentIdResponseSuccess)

export const getPutDepartmentIdUrl = (id: string,) => {


  

  return `/department/${id}`
}

export const putDepartmentId = async (id: string,
    department: Department, options?: RequestInit): Promise<putDepartmentIdResponse> => {
  
  return useCustomClient<putDepartmentIdResponse>(getPutDepartmentIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      department,)
  }
);}




export const getPutDepartmentIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putDepartmentId>>, TError,{id: string;data: BodyType<Department>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putDepartmentId>>, TError,{id: string;data: BodyType<Department>}, TContext> => {

const mutationKey = ['putDepartmentId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putDepartmentId>>, {id: string;data: BodyType<Department>}> = (props) => {
          const {id,data} = props ?? {};

          return  putDepartmentId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutDepartmentIdMutationResult = NonNullable<Awaited<ReturnType<typeof putDepartmentId>>>
    export type PutDepartmentIdMutationBody = BodyType<Department>
    export type PutDepartmentIdMutationError = ErrorType<unknown>

    export const usePutDepartmentId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putDepartmentId>>, TError,{id: string;data: BodyType<Department>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putDepartmentId>>,
        TError,
        {id: string;data: BodyType<Department>},
        TContext
      > => {

      const mutationOptions = getPutDepartmentIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteDepartmentIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteDepartmentIdResponseSuccess = (deleteDepartmentIdResponse200) & {
  headers: Headers;
};
;

export type deleteDepartmentIdResponse = (deleteDepartmentIdResponseSuccess)

export const getDeleteDepartmentIdUrl = (id: string,) => {


  

  return `/department/${id}`
}

export const deleteDepartmentId = async (id: string, options?: RequestInit): Promise<deleteDepartmentIdResponse> => {
  
  return useCustomClient<deleteDepartmentIdResponse>(getDeleteDepartmentIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteDepartmentIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteDepartmentId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteDepartmentId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteDepartmentId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteDepartmentId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteDepartmentId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteDepartmentIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteDepartmentId>>>
    
    export type DeleteDepartmentIdMutationError = ErrorType<unknown>

    export const useDeleteDepartmentId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteDepartmentId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteDepartmentId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteDepartmentIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getDepartmentResponse200 = {
  data: Response
  status: 200
}
    
export type getDepartmentResponseSuccess = (getDepartmentResponse200) & {
  headers: Headers;
};
;

export type getDepartmentResponse = (getDepartmentResponseSuccess)

export const getGetDepartmentUrl = (params?: GetDepartmentParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/department?${stringifiedParams}` : `/department`
}

export const getDepartment = async (params?: GetDepartmentParams, options?: RequestInit): Promise<getDepartmentResponse> => {
  
  return useCustomClient<getDepartmentResponse>(getGetDepartmentUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetDepartmentInfiniteQueryKey = (params?: GetDepartmentParams,) => {
    return [
    'infinite', `/department`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetDepartmentQueryKey = (params?: GetDepartmentParams,) => {
    return [
    `/department`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetDepartmentInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getDepartment>>>, TError = ErrorType<unknown>>(params?: GetDepartmentParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetDepartmentInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getDepartment>>> = ({ signal }) => getDepartment(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetDepartmentInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getDepartment>>>
export type GetDepartmentInfiniteQueryError = ErrorType<unknown>


export function useGetDepartmentInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getDepartment>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetDepartmentParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getDepartment>>,
          TError,
          Awaited<ReturnType<typeof getDepartment>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetDepartmentInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getDepartment>>>, TError = ErrorType<unknown>>(
 params?: GetDepartmentParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getDepartment>>,
          TError,
          Awaited<ReturnType<typeof getDepartment>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetDepartmentInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getDepartment>>>, TError = ErrorType<unknown>>(
 params?: GetDepartmentParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetDepartmentInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getDepartment>>>, TError = ErrorType<unknown>>(
 params?: GetDepartmentParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetDepartmentInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetDepartmentInfiniteQuery = async <TData = Awaited<ReturnType<typeof getDepartment>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetDepartmentParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetDepartmentInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetDepartmentQueryOptions = <TData = Awaited<ReturnType<typeof getDepartment>>, TError = ErrorType<unknown>>(params?: GetDepartmentParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetDepartmentQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getDepartment>>> = ({ signal }) => getDepartment(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetDepartmentQueryResult = NonNullable<Awaited<ReturnType<typeof getDepartment>>>
export type GetDepartmentQueryError = ErrorType<unknown>


export function useGetDepartment<TData = Awaited<ReturnType<typeof getDepartment>>, TError = ErrorType<unknown>>(
 params: undefined |  GetDepartmentParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getDepartment>>,
          TError,
          Awaited<ReturnType<typeof getDepartment>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetDepartment<TData = Awaited<ReturnType<typeof getDepartment>>, TError = ErrorType<unknown>>(
 params?: GetDepartmentParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getDepartment>>,
          TError,
          Awaited<ReturnType<typeof getDepartment>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetDepartment<TData = Awaited<ReturnType<typeof getDepartment>>, TError = ErrorType<unknown>>(
 params?: GetDepartmentParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetDepartment<TData = Awaited<ReturnType<typeof getDepartment>>, TError = ErrorType<unknown>>(
 params?: GetDepartmentParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetDepartmentQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetDepartmentQuery = async <TData = Awaited<ReturnType<typeof getDepartment>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetDepartmentParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getDepartment>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetDepartmentQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postDepartmentResponse200 = {
  data: Response
  status: 200
}
    
export type postDepartmentResponseSuccess = (postDepartmentResponse200) & {
  headers: Headers;
};
;

export type postDepartmentResponse = (postDepartmentResponseSuccess)

export const getPostDepartmentUrl = () => {


  

  return `/department`
}

export const postDepartment = async (department: Department[], options?: RequestInit): Promise<postDepartmentResponse> => {
  
  return useCustomClient<postDepartmentResponse>(getPostDepartmentUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      department,)
  }
);}




export const getPostDepartmentMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postDepartment>>, TError,{data: BodyType<Department[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postDepartment>>, TError,{data: BodyType<Department[]>}, TContext> => {

const mutationKey = ['postDepartment'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postDepartment>>, {data: BodyType<Department[]>}> = (props) => {
          const {data} = props ?? {};

          return  postDepartment(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostDepartmentMutationResult = NonNullable<Awaited<ReturnType<typeof postDepartment>>>
    export type PostDepartmentMutationBody = BodyType<Department[]>
    export type PostDepartmentMutationError = ErrorType<unknown>

    export const usePostDepartment = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postDepartment>>, TError,{data: BodyType<Department[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postDepartment>>,
        TError,
        {data: BodyType<Department[]>},
        TContext
      > => {

      const mutationOptions = getPostDepartmentMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    