/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  Category,
  GetCategoryParams,
  PostCategoryBody,
  Response
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get category by id
 */
export type getCategoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type getCategoryIdResponseSuccess = (getCategoryIdResponse200) & {
  headers: Headers;
};
;

export type getCategoryIdResponse = (getCategoryIdResponseSuccess)

export const getGetCategoryIdUrl = (id: string,) => {


  

  return `/category/${id}`
}

export const getCategoryId = async (id: string, options?: RequestInit): Promise<getCategoryIdResponse> => {
  
  return useCustomClient<getCategoryIdResponse>(getGetCategoryIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetCategoryIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/category/${id}`
    ] as const;
    }

export const getGetCategoryIdQueryKey = (id?: string,) => {
    return [
    `/category/${id}`
    ] as const;
    }

    
export const getGetCategoryIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getCategoryId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetCategoryIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getCategoryId>>> = ({ signal }) => getCategoryId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetCategoryIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getCategoryId>>>
export type GetCategoryIdInfiniteQueryError = ErrorType<unknown>


export function useGetCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetCategoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getCategoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetCategoryIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetCategoryIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getCategoryId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetCategoryIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetCategoryIdQueryOptions = <TData = Awaited<ReturnType<typeof getCategoryId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetCategoryIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getCategoryId>>> = ({ signal }) => getCategoryId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetCategoryIdQueryResult = NonNullable<Awaited<ReturnType<typeof getCategoryId>>>
export type GetCategoryIdQueryError = ErrorType<unknown>


export function useGetCategoryId<TData = Awaited<ReturnType<typeof getCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetCategoryId<TData = Awaited<ReturnType<typeof getCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getCategoryId>>,
          TError,
          Awaited<ReturnType<typeof getCategoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetCategoryId<TData = Awaited<ReturnType<typeof getCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetCategoryId<TData = Awaited<ReturnType<typeof getCategoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetCategoryIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetCategoryIdQuery = async <TData = Awaited<ReturnType<typeof getCategoryId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetCategoryIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Update category by id
 */
export type putCategoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type putCategoryIdResponseSuccess = (putCategoryIdResponse200) & {
  headers: Headers;
};
;

export type putCategoryIdResponse = (putCategoryIdResponseSuccess)

export const getPutCategoryIdUrl = (id: string,) => {


  

  return `/category/${id}`
}

export const putCategoryId = async (id: string,
    category: Category, options?: RequestInit): Promise<putCategoryIdResponse> => {
  
  return useCustomClient<putCategoryIdResponse>(getPutCategoryIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      category,)
  }
);}




export const getPutCategoryIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putCategoryId>>, TError,{id: string;data: BodyType<Category>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putCategoryId>>, TError,{id: string;data: BodyType<Category>}, TContext> => {

const mutationKey = ['putCategoryId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putCategoryId>>, {id: string;data: BodyType<Category>}> = (props) => {
          const {id,data} = props ?? {};

          return  putCategoryId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutCategoryIdMutationResult = NonNullable<Awaited<ReturnType<typeof putCategoryId>>>
    export type PutCategoryIdMutationBody = BodyType<Category>
    export type PutCategoryIdMutationError = ErrorType<unknown>

    export const usePutCategoryId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putCategoryId>>, TError,{id: string;data: BodyType<Category>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putCategoryId>>,
        TError,
        {id: string;data: BodyType<Category>},
        TContext
      > => {

      const mutationOptions = getPutCategoryIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete category by id
 */
export type deleteCategoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteCategoryIdResponseSuccess = (deleteCategoryIdResponse200) & {
  headers: Headers;
};
;

export type deleteCategoryIdResponse = (deleteCategoryIdResponseSuccess)

export const getDeleteCategoryIdUrl = (id: string,) => {


  

  return `/category/${id}`
}

export const deleteCategoryId = async (id: string, options?: RequestInit): Promise<deleteCategoryIdResponse> => {
  
  return useCustomClient<deleteCategoryIdResponse>(getDeleteCategoryIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteCategoryIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteCategoryId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteCategoryId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteCategoryId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteCategoryId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteCategoryId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteCategoryIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteCategoryId>>>
    
    export type DeleteCategoryIdMutationError = ErrorType<unknown>

    export const useDeleteCategoryId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteCategoryId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteCategoryId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteCategoryIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get all categories
 */
export type getCategoryResponse200 = {
  data: Response
  status: 200
}
    
export type getCategoryResponseSuccess = (getCategoryResponse200) & {
  headers: Headers;
};
;

export type getCategoryResponse = (getCategoryResponseSuccess)

export const getGetCategoryUrl = (params?: GetCategoryParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/category?${stringifiedParams}` : `/category`
}

export const getCategory = async (params?: GetCategoryParams, options?: RequestInit): Promise<getCategoryResponse> => {
  
  return useCustomClient<getCategoryResponse>(getGetCategoryUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetCategoryInfiniteQueryKey = (params?: GetCategoryParams,) => {
    return [
    'infinite', `/category`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetCategoryQueryKey = (params?: GetCategoryParams,) => {
    return [
    `/category`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetCategoryInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getCategory>>>, TError = ErrorType<unknown>>(params?: GetCategoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetCategoryInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getCategory>>> = ({ signal }) => getCategory(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetCategoryInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getCategory>>>
export type GetCategoryInfiniteQueryError = ErrorType<unknown>


export function useGetCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getCategory>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetCategoryParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getCategory>>,
          TError,
          Awaited<ReturnType<typeof getCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getCategory>>>, TError = ErrorType<unknown>>(
 params?: GetCategoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getCategory>>,
          TError,
          Awaited<ReturnType<typeof getCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getCategory>>>, TError = ErrorType<unknown>>(
 params?: GetCategoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetCategoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getCategory>>>, TError = ErrorType<unknown>>(
 params?: GetCategoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetCategoryInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetCategoryInfiniteQuery = async <TData = Awaited<ReturnType<typeof getCategory>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetCategoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetCategoryInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetCategoryQueryOptions = <TData = Awaited<ReturnType<typeof getCategory>>, TError = ErrorType<unknown>>(params?: GetCategoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetCategoryQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getCategory>>> = ({ signal }) => getCategory(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetCategoryQueryResult = NonNullable<Awaited<ReturnType<typeof getCategory>>>
export type GetCategoryQueryError = ErrorType<unknown>


export function useGetCategory<TData = Awaited<ReturnType<typeof getCategory>>, TError = ErrorType<unknown>>(
 params: undefined |  GetCategoryParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getCategory>>,
          TError,
          Awaited<ReturnType<typeof getCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetCategory<TData = Awaited<ReturnType<typeof getCategory>>, TError = ErrorType<unknown>>(
 params?: GetCategoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getCategory>>,
          TError,
          Awaited<ReturnType<typeof getCategory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetCategory<TData = Awaited<ReturnType<typeof getCategory>>, TError = ErrorType<unknown>>(
 params?: GetCategoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetCategory<TData = Awaited<ReturnType<typeof getCategory>>, TError = ErrorType<unknown>>(
 params?: GetCategoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetCategoryQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetCategoryQuery = async <TData = Awaited<ReturnType<typeof getCategory>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetCategoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getCategory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetCategoryQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Create new category
 */
export type postCategoryResponse200 = {
  data: Response
  status: 200
}

export type postCategoryResponse400 = {
  data: void
  status: 400
}
    
export type postCategoryResponseSuccess = (postCategoryResponse200) & {
  headers: Headers;
};
export type postCategoryResponseError = (postCategoryResponse400) & {
  headers: Headers;
};

export type postCategoryResponse = (postCategoryResponseSuccess | postCategoryResponseError)

export const getPostCategoryUrl = () => {


  

  return `/category`
}

export const postCategory = async (postCategoryBody: PostCategoryBody, options?: RequestInit): Promise<postCategoryResponse> => {
  
  return useCustomClient<postCategoryResponse>(getPostCategoryUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      postCategoryBody,)
  }
);}




export const getPostCategoryMutationOptions = <TError = ErrorType<void>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postCategory>>, TError,{data: BodyType<PostCategoryBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postCategory>>, TError,{data: BodyType<PostCategoryBody>}, TContext> => {

const mutationKey = ['postCategory'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postCategory>>, {data: BodyType<PostCategoryBody>}> = (props) => {
          const {data} = props ?? {};

          return  postCategory(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostCategoryMutationResult = NonNullable<Awaited<ReturnType<typeof postCategory>>>
    export type PostCategoryMutationBody = BodyType<PostCategoryBody>
    export type PostCategoryMutationError = ErrorType<void>

    export const usePostCategory = <TError = ErrorType<void>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postCategory>>, TError,{data: BodyType<PostCategoryBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postCategory>>,
        TError,
        {data: BodyType<PostCategoryBody>},
        TContext
      > => {

      const mutationOptions = getPostCategoryMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    