/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteMembershipFeeParams,
  GetMembershipFeeParams,
  GetMembershipFeePrintParams,
  MembershipFee,
  MembershipFeeBody,
  PutMembershipFeeParams,
  Response
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get
 */
export type getMembershipFeeIdResponse200 = {
  data: Response
  status: 200
}
    
export type getMembershipFeeIdResponseSuccess = (getMembershipFeeIdResponse200) & {
  headers: Headers;
};
;

export type getMembershipFeeIdResponse = (getMembershipFeeIdResponseSuccess)

export const getGetMembershipFeeIdUrl = (id: string,) => {


  

  return `/membershipFee/${id}`
}

export const getMembershipFeeId = async (id: string, options?: RequestInit): Promise<getMembershipFeeIdResponse> => {
  
  return useCustomClient<getMembershipFeeIdResponse>(getGetMembershipFeeIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetMembershipFeeIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/membershipFee/${id}`
    ] as const;
    }

export const getGetMembershipFeeIdQueryKey = (id?: string,) => {
    return [
    `/membershipFee/${id}`
    ] as const;
    }

    
export const getGetMembershipFeeIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeeId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetMembershipFeeIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getMembershipFeeId>>> = ({ signal }) => getMembershipFeeId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetMembershipFeeIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getMembershipFeeId>>>
export type GetMembershipFeeIdInfiniteQueryError = ErrorType<unknown>


export function useGetMembershipFeeIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeeId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeeId>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeeId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeeIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeeId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeeId>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeeId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeeIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeeId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetMembershipFeeIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeeId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetMembershipFeeIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetMembershipFeeIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getMembershipFeeId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetMembershipFeeIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetMembershipFeeIdQueryOptions = <TData = Awaited<ReturnType<typeof getMembershipFeeId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetMembershipFeeIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getMembershipFeeId>>> = ({ signal }) => getMembershipFeeId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetMembershipFeeIdQueryResult = NonNullable<Awaited<ReturnType<typeof getMembershipFeeId>>>
export type GetMembershipFeeIdQueryError = ErrorType<unknown>


export function useGetMembershipFeeId<TData = Awaited<ReturnType<typeof getMembershipFeeId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeeId>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeeId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeeId<TData = Awaited<ReturnType<typeof getMembershipFeeId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeeId>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeeId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeeId<TData = Awaited<ReturnType<typeof getMembershipFeeId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetMembershipFeeId<TData = Awaited<ReturnType<typeof getMembershipFeeId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetMembershipFeeIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetMembershipFeeIdQuery = async <TData = Awaited<ReturnType<typeof getMembershipFeeId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetMembershipFeeIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putMembershipFeeIdResponse200 = {
  data: Response
  status: 200
}
    
export type putMembershipFeeIdResponseSuccess = (putMembershipFeeIdResponse200) & {
  headers: Headers;
};
;

export type putMembershipFeeIdResponse = (putMembershipFeeIdResponseSuccess)

export const getPutMembershipFeeIdUrl = (id: string,) => {


  

  return `/membershipFee/${id}`
}

export const putMembershipFeeId = async (id: string,
    membershipFeeBody: MembershipFeeBody, options?: RequestInit): Promise<putMembershipFeeIdResponse> => {
  
  return useCustomClient<putMembershipFeeIdResponse>(getPutMembershipFeeIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      membershipFeeBody,)
  }
);}




export const getPutMembershipFeeIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putMembershipFeeId>>, TError,{id: string;data: BodyType<MembershipFeeBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putMembershipFeeId>>, TError,{id: string;data: BodyType<MembershipFeeBody>}, TContext> => {

const mutationKey = ['putMembershipFeeId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putMembershipFeeId>>, {id: string;data: BodyType<MembershipFeeBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putMembershipFeeId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutMembershipFeeIdMutationResult = NonNullable<Awaited<ReturnType<typeof putMembershipFeeId>>>
    export type PutMembershipFeeIdMutationBody = BodyType<MembershipFeeBody>
    export type PutMembershipFeeIdMutationError = ErrorType<unknown>

    export const usePutMembershipFeeId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putMembershipFeeId>>, TError,{id: string;data: BodyType<MembershipFeeBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putMembershipFeeId>>,
        TError,
        {id: string;data: BodyType<MembershipFeeBody>},
        TContext
      > => {

      const mutationOptions = getPutMembershipFeeIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteMembershipFeeIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteMembershipFeeIdResponseSuccess = (deleteMembershipFeeIdResponse200) & {
  headers: Headers;
};
;

export type deleteMembershipFeeIdResponse = (deleteMembershipFeeIdResponseSuccess)

export const getDeleteMembershipFeeIdUrl = (id: string,) => {


  

  return `/membershipFee/${id}`
}

export const deleteMembershipFeeId = async (id: string, options?: RequestInit): Promise<deleteMembershipFeeIdResponse> => {
  
  return useCustomClient<deleteMembershipFeeIdResponse>(getDeleteMembershipFeeIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteMembershipFeeIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteMembershipFeeId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteMembershipFeeId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteMembershipFeeId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteMembershipFeeId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteMembershipFeeId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteMembershipFeeIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteMembershipFeeId>>>
    
    export type DeleteMembershipFeeIdMutationError = ErrorType<unknown>

    export const useDeleteMembershipFeeId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteMembershipFeeId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteMembershipFeeId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteMembershipFeeIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getMembershipFeeCheckFeeOrganizationIdResponse200 = {
  data: Response
  status: 200
}
    
export type getMembershipFeeCheckFeeOrganizationIdResponseSuccess = (getMembershipFeeCheckFeeOrganizationIdResponse200) & {
  headers: Headers;
};
;

export type getMembershipFeeCheckFeeOrganizationIdResponse = (getMembershipFeeCheckFeeOrganizationIdResponseSuccess)

export const getGetMembershipFeeCheckFeeOrganizationIdUrl = (organizationId: string,) => {


  

  return `/membershipFee/checkFee/${organizationId}`
}

export const getMembershipFeeCheckFeeOrganizationId = async (organizationId: string, options?: RequestInit): Promise<getMembershipFeeCheckFeeOrganizationIdResponse> => {
  
  return useCustomClient<getMembershipFeeCheckFeeOrganizationIdResponse>(getGetMembershipFeeCheckFeeOrganizationIdUrl(organizationId),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetMembershipFeeCheckFeeOrganizationIdInfiniteQueryKey = (organizationId?: string,) => {
    return [
    'infinite', `/membershipFee/checkFee/${organizationId}`
    ] as const;
    }

export const getGetMembershipFeeCheckFeeOrganizationIdQueryKey = (organizationId?: string,) => {
    return [
    `/membershipFee/checkFee/${organizationId}`
    ] as const;
    }

    
export const getGetMembershipFeeCheckFeeOrganizationIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>>, TError = ErrorType<unknown>>(organizationId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetMembershipFeeCheckFeeOrganizationIdInfiniteQueryKey(organizationId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>> = ({ signal }) => getMembershipFeeCheckFeeOrganizationId(organizationId, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(organizationId), ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetMembershipFeeCheckFeeOrganizationIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>>
export type GetMembershipFeeCheckFeeOrganizationIdInfiniteQueryError = ErrorType<unknown>


export function useGetMembershipFeeCheckFeeOrganizationIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>>, TError = ErrorType<unknown>>(
 organizationId: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeeCheckFeeOrganizationIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeeCheckFeeOrganizationIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetMembershipFeeCheckFeeOrganizationIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetMembershipFeeCheckFeeOrganizationIdInfiniteQueryOptions(organizationId,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetMembershipFeeCheckFeeOrganizationIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, organizationId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetMembershipFeeCheckFeeOrganizationIdInfiniteQueryOptions(organizationId,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetMembershipFeeCheckFeeOrganizationIdQueryOptions = <TData = Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError = ErrorType<unknown>>(organizationId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetMembershipFeeCheckFeeOrganizationIdQueryKey(organizationId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>> = ({ signal }) => getMembershipFeeCheckFeeOrganizationId(organizationId, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(organizationId), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetMembershipFeeCheckFeeOrganizationIdQueryResult = NonNullable<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>>
export type GetMembershipFeeCheckFeeOrganizationIdQueryError = ErrorType<unknown>


export function useGetMembershipFeeCheckFeeOrganizationId<TData = Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError = ErrorType<unknown>>(
 organizationId: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeeCheckFeeOrganizationId<TData = Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeeCheckFeeOrganizationId<TData = Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetMembershipFeeCheckFeeOrganizationId<TData = Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError = ErrorType<unknown>>(
 organizationId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetMembershipFeeCheckFeeOrganizationIdQueryOptions(organizationId,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetMembershipFeeCheckFeeOrganizationIdQuery = async <TData = Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, organizationId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeeCheckFeeOrganizationId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetMembershipFeeCheckFeeOrganizationIdQueryOptions(organizationId,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getMembershipFeeResponse200 = {
  data: Response
  status: 200
}
    
export type getMembershipFeeResponseSuccess = (getMembershipFeeResponse200) & {
  headers: Headers;
};
;

export type getMembershipFeeResponse = (getMembershipFeeResponseSuccess)

export const getGetMembershipFeeUrl = (params?: GetMembershipFeeParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/membershipFee?${stringifiedParams}` : `/membershipFee`
}

export const getMembershipFee = async (params?: GetMembershipFeeParams, options?: RequestInit): Promise<getMembershipFeeResponse> => {
  
  return useCustomClient<getMembershipFeeResponse>(getGetMembershipFeeUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetMembershipFeeInfiniteQueryKey = (params?: GetMembershipFeeParams,) => {
    return [
    'infinite', `/membershipFee`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetMembershipFeeQueryKey = (params?: GetMembershipFeeParams,) => {
    return [
    `/membershipFee`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetMembershipFeeInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFee>>>, TError = ErrorType<unknown>>(params?: GetMembershipFeeParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetMembershipFeeInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getMembershipFee>>> = ({ signal }) => getMembershipFee(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetMembershipFeeInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getMembershipFee>>>
export type GetMembershipFeeInfiniteQueryError = ErrorType<unknown>


export function useGetMembershipFeeInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFee>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetMembershipFeeParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFee>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFee>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeeInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFee>>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeeParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFee>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFee>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeeInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFee>>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeeParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetMembershipFeeInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFee>>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeeParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetMembershipFeeInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetMembershipFeeInfiniteQuery = async <TData = Awaited<ReturnType<typeof getMembershipFee>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetMembershipFeeParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetMembershipFeeInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetMembershipFeeQueryOptions = <TData = Awaited<ReturnType<typeof getMembershipFee>>, TError = ErrorType<unknown>>(params?: GetMembershipFeeParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetMembershipFeeQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getMembershipFee>>> = ({ signal }) => getMembershipFee(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetMembershipFeeQueryResult = NonNullable<Awaited<ReturnType<typeof getMembershipFee>>>
export type GetMembershipFeeQueryError = ErrorType<unknown>


export function useGetMembershipFee<TData = Awaited<ReturnType<typeof getMembershipFee>>, TError = ErrorType<unknown>>(
 params: undefined |  GetMembershipFeeParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFee>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFee>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFee<TData = Awaited<ReturnType<typeof getMembershipFee>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeeParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFee>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFee>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFee<TData = Awaited<ReturnType<typeof getMembershipFee>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeeParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetMembershipFee<TData = Awaited<ReturnType<typeof getMembershipFee>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeeParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetMembershipFeeQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetMembershipFeeQuery = async <TData = Awaited<ReturnType<typeof getMembershipFee>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetMembershipFeeParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFee>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetMembershipFeeQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postMembershipFeeResponse200 = {
  data: Response
  status: 200
}
    
export type postMembershipFeeResponseSuccess = (postMembershipFeeResponse200) & {
  headers: Headers;
};
;

export type postMembershipFeeResponse = (postMembershipFeeResponseSuccess)

export const getPostMembershipFeeUrl = () => {


  

  return `/membershipFee`
}

export const postMembershipFee = async (membershipFee: MembershipFee[], options?: RequestInit): Promise<postMembershipFeeResponse> => {
  
  return useCustomClient<postMembershipFeeResponse>(getPostMembershipFeeUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      membershipFee,)
  }
);}




export const getPostMembershipFeeMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postMembershipFee>>, TError,{data: BodyType<MembershipFee[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postMembershipFee>>, TError,{data: BodyType<MembershipFee[]>}, TContext> => {

const mutationKey = ['postMembershipFee'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postMembershipFee>>, {data: BodyType<MembershipFee[]>}> = (props) => {
          const {data} = props ?? {};

          return  postMembershipFee(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostMembershipFeeMutationResult = NonNullable<Awaited<ReturnType<typeof postMembershipFee>>>
    export type PostMembershipFeeMutationBody = BodyType<MembershipFee[]>
    export type PostMembershipFeeMutationError = ErrorType<unknown>

    export const usePostMembershipFee = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postMembershipFee>>, TError,{data: BodyType<MembershipFee[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postMembershipFee>>,
        TError,
        {data: BodyType<MembershipFee[]>},
        TContext
      > => {

      const mutationOptions = getPostMembershipFeeMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putMembershipFeeResponse200 = {
  data: Response
  status: 200
}
    
export type putMembershipFeeResponseSuccess = (putMembershipFeeResponse200) & {
  headers: Headers;
};
;

export type putMembershipFeeResponse = (putMembershipFeeResponseSuccess)

export const getPutMembershipFeeUrl = (params: PutMembershipFeeParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/membershipFee?${stringifiedParams}` : `/membershipFee`
}

export const putMembershipFee = async (membershipFeeBody: MembershipFeeBody,
    params: PutMembershipFeeParams, options?: RequestInit): Promise<putMembershipFeeResponse> => {
  
  return useCustomClient<putMembershipFeeResponse>(getPutMembershipFeeUrl(params),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      membershipFeeBody,)
  }
);}




export const getPutMembershipFeeMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putMembershipFee>>, TError,{data: BodyType<MembershipFeeBody>;params: PutMembershipFeeParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putMembershipFee>>, TError,{data: BodyType<MembershipFeeBody>;params: PutMembershipFeeParams}, TContext> => {

const mutationKey = ['putMembershipFee'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putMembershipFee>>, {data: BodyType<MembershipFeeBody>;params: PutMembershipFeeParams}> = (props) => {
          const {data,params} = props ?? {};

          return  putMembershipFee(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutMembershipFeeMutationResult = NonNullable<Awaited<ReturnType<typeof putMembershipFee>>>
    export type PutMembershipFeeMutationBody = BodyType<MembershipFeeBody>
    export type PutMembershipFeeMutationError = ErrorType<unknown>

    export const usePutMembershipFee = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putMembershipFee>>, TError,{data: BodyType<MembershipFeeBody>;params: PutMembershipFeeParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putMembershipFee>>,
        TError,
        {data: BodyType<MembershipFeeBody>;params: PutMembershipFeeParams},
        TContext
      > => {

      const mutationOptions = getPutMembershipFeeMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteMembershipFeeResponse200 = {
  data: Response
  status: 200
}
    
export type deleteMembershipFeeResponseSuccess = (deleteMembershipFeeResponse200) & {
  headers: Headers;
};
;

export type deleteMembershipFeeResponse = (deleteMembershipFeeResponseSuccess)

export const getDeleteMembershipFeeUrl = (params: DeleteMembershipFeeParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/membershipFee?${stringifiedParams}` : `/membershipFee`
}

export const deleteMembershipFee = async (params: DeleteMembershipFeeParams, options?: RequestInit): Promise<deleteMembershipFeeResponse> => {
  
  return useCustomClient<deleteMembershipFeeResponse>(getDeleteMembershipFeeUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteMembershipFeeMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteMembershipFee>>, TError,{params: DeleteMembershipFeeParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteMembershipFee>>, TError,{params: DeleteMembershipFeeParams}, TContext> => {

const mutationKey = ['deleteMembershipFee'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteMembershipFee>>, {params: DeleteMembershipFeeParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteMembershipFee(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteMembershipFeeMutationResult = NonNullable<Awaited<ReturnType<typeof deleteMembershipFee>>>
    
    export type DeleteMembershipFeeMutationError = ErrorType<unknown>

    export const useDeleteMembershipFee = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteMembershipFee>>, TError,{params: DeleteMembershipFeeParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteMembershipFee>>,
        TError,
        {params: DeleteMembershipFeeParams},
        TContext
      > => {

      const mutationOptions = getDeleteMembershipFeeMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Excel for membership history
 */
export type getMembershipFeePrintResponse200 = {
  data: Blob
  status: 200
}
    
export type getMembershipFeePrintResponseSuccess = (getMembershipFeePrintResponse200) & {
  headers: Headers;
};
;

export type getMembershipFeePrintResponse = (getMembershipFeePrintResponseSuccess)

export const getGetMembershipFeePrintUrl = (params?: GetMembershipFeePrintParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/membershipFee/print?${stringifiedParams}` : `/membershipFee/print`
}

export const getMembershipFeePrint = async (params?: GetMembershipFeePrintParams, options?: RequestInit): Promise<getMembershipFeePrintResponse> => {
  
  return useCustomClient<getMembershipFeePrintResponse>(getGetMembershipFeePrintUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetMembershipFeePrintInfiniteQueryKey = (params?: GetMembershipFeePrintParams,) => {
    return [
    'infinite', `/membershipFee/print`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetMembershipFeePrintQueryKey = (params?: GetMembershipFeePrintParams,) => {
    return [
    `/membershipFee/print`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetMembershipFeePrintInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeePrint>>>, TError = ErrorType<unknown>>(params?: GetMembershipFeePrintParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetMembershipFeePrintInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getMembershipFeePrint>>> = ({ signal }) => getMembershipFeePrint(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetMembershipFeePrintInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getMembershipFeePrint>>>
export type GetMembershipFeePrintInfiniteQueryError = ErrorType<unknown>


export function useGetMembershipFeePrintInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeePrint>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetMembershipFeePrintParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeePrint>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeePrint>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeePrintInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeePrint>>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeePrintParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeePrint>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeePrint>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeePrintInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeePrint>>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeePrintParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetMembershipFeePrintInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getMembershipFeePrint>>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeePrintParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetMembershipFeePrintInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetMembershipFeePrintInfiniteQuery = async <TData = Awaited<ReturnType<typeof getMembershipFeePrint>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetMembershipFeePrintParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetMembershipFeePrintInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetMembershipFeePrintQueryOptions = <TData = Awaited<ReturnType<typeof getMembershipFeePrint>>, TError = ErrorType<unknown>>(params?: GetMembershipFeePrintParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetMembershipFeePrintQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getMembershipFeePrint>>> = ({ signal }) => getMembershipFeePrint(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetMembershipFeePrintQueryResult = NonNullable<Awaited<ReturnType<typeof getMembershipFeePrint>>>
export type GetMembershipFeePrintQueryError = ErrorType<unknown>


export function useGetMembershipFeePrint<TData = Awaited<ReturnType<typeof getMembershipFeePrint>>, TError = ErrorType<unknown>>(
 params: undefined |  GetMembershipFeePrintParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeePrint>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeePrint>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeePrint<TData = Awaited<ReturnType<typeof getMembershipFeePrint>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeePrintParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getMembershipFeePrint>>,
          TError,
          Awaited<ReturnType<typeof getMembershipFeePrint>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetMembershipFeePrint<TData = Awaited<ReturnType<typeof getMembershipFeePrint>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeePrintParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetMembershipFeePrint<TData = Awaited<ReturnType<typeof getMembershipFeePrint>>, TError = ErrorType<unknown>>(
 params?: GetMembershipFeePrintParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetMembershipFeePrintQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetMembershipFeePrintQuery = async <TData = Awaited<ReturnType<typeof getMembershipFeePrint>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetMembershipFeePrintParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getMembershipFeePrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetMembershipFeePrintQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



