/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteUserHistoryParams,
  GetUserHistoryParams,
  PutUserHistoryParams,
  Response,
  UserHistory,
  UserHistoryBody
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get
 */
export type getUserHistoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type getUserHistoryIdResponseSuccess = (getUserHistoryIdResponse200) & {
  headers: Headers;
};
;

export type getUserHistoryIdResponse = (getUserHistoryIdResponseSuccess)

export const getGetUserHistoryIdUrl = (id: string,) => {


  

  return `/user_history/${id}`
}

export const getUserHistoryId = async (id: string, options?: RequestInit): Promise<getUserHistoryIdResponse> => {
  
  return useCustomClient<getUserHistoryIdResponse>(getGetUserHistoryIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUserHistoryIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/user_history/${id}`
    ] as const;
    }

export const getGetUserHistoryIdQueryKey = (id?: string,) => {
    return [
    `/user_history/${id}`
    ] as const;
    }

    
export const getGetUserHistoryIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUserHistoryId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserHistoryIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserHistoryId>>> = ({ signal }) => getUserHistoryId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUserHistoryIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUserHistoryId>>>
export type GetUserHistoryIdInfiniteQueryError = ErrorType<unknown>


export function useGetUserHistoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserHistoryId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserHistoryId>>,
          TError,
          Awaited<ReturnType<typeof getUserHistoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUserHistoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserHistoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserHistoryId>>,
          TError,
          Awaited<ReturnType<typeof getUserHistoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUserHistoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserHistoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUserHistoryIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserHistoryId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUserHistoryIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUserHistoryIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUserHistoryId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUserHistoryIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUserHistoryIdQueryOptions = <TData = Awaited<ReturnType<typeof getUserHistoryId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserHistoryIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserHistoryId>>> = ({ signal }) => getUserHistoryId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUserHistoryIdQueryResult = NonNullable<Awaited<ReturnType<typeof getUserHistoryId>>>
export type GetUserHistoryIdQueryError = ErrorType<unknown>


export function useGetUserHistoryId<TData = Awaited<ReturnType<typeof getUserHistoryId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserHistoryId>>,
          TError,
          Awaited<ReturnType<typeof getUserHistoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUserHistoryId<TData = Awaited<ReturnType<typeof getUserHistoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserHistoryId>>,
          TError,
          Awaited<ReturnType<typeof getUserHistoryId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUserHistoryId<TData = Awaited<ReturnType<typeof getUserHistoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUserHistoryId<TData = Awaited<ReturnType<typeof getUserHistoryId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUserHistoryIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUserHistoryIdQuery = async <TData = Awaited<ReturnType<typeof getUserHistoryId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistoryId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUserHistoryIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putUserHistoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type putUserHistoryIdResponseSuccess = (putUserHistoryIdResponse200) & {
  headers: Headers;
};
;

export type putUserHistoryIdResponse = (putUserHistoryIdResponseSuccess)

export const getPutUserHistoryIdUrl = (id: string,) => {


  

  return `/user_history/${id}`
}

export const putUserHistoryId = async (id: string,
    userHistoryBody: UserHistoryBody, options?: RequestInit): Promise<putUserHistoryIdResponse> => {
  
  return useCustomClient<putUserHistoryIdResponse>(getPutUserHistoryIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      userHistoryBody,)
  }
);}




export const getPutUserHistoryIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putUserHistoryId>>, TError,{id: string;data: BodyType<UserHistoryBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putUserHistoryId>>, TError,{id: string;data: BodyType<UserHistoryBody>}, TContext> => {

const mutationKey = ['putUserHistoryId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putUserHistoryId>>, {id: string;data: BodyType<UserHistoryBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putUserHistoryId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutUserHistoryIdMutationResult = NonNullable<Awaited<ReturnType<typeof putUserHistoryId>>>
    export type PutUserHistoryIdMutationBody = BodyType<UserHistoryBody>
    export type PutUserHistoryIdMutationError = ErrorType<unknown>

    export const usePutUserHistoryId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putUserHistoryId>>, TError,{id: string;data: BodyType<UserHistoryBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putUserHistoryId>>,
        TError,
        {id: string;data: BodyType<UserHistoryBody>},
        TContext
      > => {

      const mutationOptions = getPutUserHistoryIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteUserHistoryIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteUserHistoryIdResponseSuccess = (deleteUserHistoryIdResponse200) & {
  headers: Headers;
};
;

export type deleteUserHistoryIdResponse = (deleteUserHistoryIdResponseSuccess)

export const getDeleteUserHistoryIdUrl = (id: string,) => {


  

  return `/user_history/${id}`
}

export const deleteUserHistoryId = async (id: string, options?: RequestInit): Promise<deleteUserHistoryIdResponse> => {
  
  return useCustomClient<deleteUserHistoryIdResponse>(getDeleteUserHistoryIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteUserHistoryIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUserHistoryId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteUserHistoryId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteUserHistoryId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteUserHistoryId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteUserHistoryId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteUserHistoryIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteUserHistoryId>>>
    
    export type DeleteUserHistoryIdMutationError = ErrorType<unknown>

    export const useDeleteUserHistoryId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUserHistoryId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteUserHistoryId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteUserHistoryIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getUserHistoryResponse200 = {
  data: Response
  status: 200
}
    
export type getUserHistoryResponseSuccess = (getUserHistoryResponse200) & {
  headers: Headers;
};
;

export type getUserHistoryResponse = (getUserHistoryResponseSuccess)

export const getGetUserHistoryUrl = (params?: GetUserHistoryParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/user_history?${stringifiedParams}` : `/user_history`
}

export const getUserHistory = async (params?: GetUserHistoryParams, options?: RequestInit): Promise<getUserHistoryResponse> => {
  
  return useCustomClient<getUserHistoryResponse>(getGetUserHistoryUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUserHistoryInfiniteQueryKey = (params?: GetUserHistoryParams,) => {
    return [
    'infinite', `/user_history`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetUserHistoryQueryKey = (params?: GetUserHistoryParams,) => {
    return [
    `/user_history`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetUserHistoryInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUserHistory>>>, TError = ErrorType<unknown>>(params?: GetUserHistoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserHistoryInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserHistory>>> = ({ signal }) => getUserHistory(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUserHistoryInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUserHistory>>>
export type GetUserHistoryInfiniteQueryError = ErrorType<unknown>


export function useGetUserHistoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserHistory>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUserHistoryParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserHistory>>,
          TError,
          Awaited<ReturnType<typeof getUserHistory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUserHistoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserHistory>>>, TError = ErrorType<unknown>>(
 params?: GetUserHistoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserHistory>>,
          TError,
          Awaited<ReturnType<typeof getUserHistory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUserHistoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserHistory>>>, TError = ErrorType<unknown>>(
 params?: GetUserHistoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUserHistoryInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUserHistory>>>, TError = ErrorType<unknown>>(
 params?: GetUserHistoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUserHistoryInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUserHistoryInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUserHistory>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUserHistoryParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUserHistoryInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUserHistoryQueryOptions = <TData = Awaited<ReturnType<typeof getUserHistory>>, TError = ErrorType<unknown>>(params?: GetUserHistoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUserHistoryQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUserHistory>>> = ({ signal }) => getUserHistory(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUserHistoryQueryResult = NonNullable<Awaited<ReturnType<typeof getUserHistory>>>
export type GetUserHistoryQueryError = ErrorType<unknown>


export function useGetUserHistory<TData = Awaited<ReturnType<typeof getUserHistory>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUserHistoryParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserHistory>>,
          TError,
          Awaited<ReturnType<typeof getUserHistory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUserHistory<TData = Awaited<ReturnType<typeof getUserHistory>>, TError = ErrorType<unknown>>(
 params?: GetUserHistoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUserHistory>>,
          TError,
          Awaited<ReturnType<typeof getUserHistory>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUserHistory<TData = Awaited<ReturnType<typeof getUserHistory>>, TError = ErrorType<unknown>>(
 params?: GetUserHistoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUserHistory<TData = Awaited<ReturnType<typeof getUserHistory>>, TError = ErrorType<unknown>>(
 params?: GetUserHistoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUserHistoryQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUserHistoryQuery = async <TData = Awaited<ReturnType<typeof getUserHistory>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUserHistoryParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUserHistory>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUserHistoryQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postUserHistoryResponse200 = {
  data: Response
  status: 200
}
    
export type postUserHistoryResponseSuccess = (postUserHistoryResponse200) & {
  headers: Headers;
};
;

export type postUserHistoryResponse = (postUserHistoryResponseSuccess)

export const getPostUserHistoryUrl = () => {


  

  return `/user_history`
}

export const postUserHistory = async (userHistory: UserHistory[], options?: RequestInit): Promise<postUserHistoryResponse> => {
  
  return useCustomClient<postUserHistoryResponse>(getPostUserHistoryUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      userHistory,)
  }
);}




export const getPostUserHistoryMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUserHistory>>, TError,{data: BodyType<UserHistory[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postUserHistory>>, TError,{data: BodyType<UserHistory[]>}, TContext> => {

const mutationKey = ['postUserHistory'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postUserHistory>>, {data: BodyType<UserHistory[]>}> = (props) => {
          const {data} = props ?? {};

          return  postUserHistory(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostUserHistoryMutationResult = NonNullable<Awaited<ReturnType<typeof postUserHistory>>>
    export type PostUserHistoryMutationBody = BodyType<UserHistory[]>
    export type PostUserHistoryMutationError = ErrorType<unknown>

    export const usePostUserHistory = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUserHistory>>, TError,{data: BodyType<UserHistory[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postUserHistory>>,
        TError,
        {data: BodyType<UserHistory[]>},
        TContext
      > => {

      const mutationOptions = getPostUserHistoryMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putUserHistoryResponse200 = {
  data: Response
  status: 200
}
    
export type putUserHistoryResponseSuccess = (putUserHistoryResponse200) & {
  headers: Headers;
};
;

export type putUserHistoryResponse = (putUserHistoryResponseSuccess)

export const getPutUserHistoryUrl = (params: PutUserHistoryParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/user_history?${stringifiedParams}` : `/user_history`
}

export const putUserHistory = async (userHistoryBody: UserHistoryBody,
    params: PutUserHistoryParams, options?: RequestInit): Promise<putUserHistoryResponse> => {
  
  return useCustomClient<putUserHistoryResponse>(getPutUserHistoryUrl(params),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      userHistoryBody,)
  }
);}




export const getPutUserHistoryMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putUserHistory>>, TError,{data: BodyType<UserHistoryBody>;params: PutUserHistoryParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putUserHistory>>, TError,{data: BodyType<UserHistoryBody>;params: PutUserHistoryParams}, TContext> => {

const mutationKey = ['putUserHistory'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putUserHistory>>, {data: BodyType<UserHistoryBody>;params: PutUserHistoryParams}> = (props) => {
          const {data,params} = props ?? {};

          return  putUserHistory(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutUserHistoryMutationResult = NonNullable<Awaited<ReturnType<typeof putUserHistory>>>
    export type PutUserHistoryMutationBody = BodyType<UserHistoryBody>
    export type PutUserHistoryMutationError = ErrorType<unknown>

    export const usePutUserHistory = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putUserHistory>>, TError,{data: BodyType<UserHistoryBody>;params: PutUserHistoryParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putUserHistory>>,
        TError,
        {data: BodyType<UserHistoryBody>;params: PutUserHistoryParams},
        TContext
      > => {

      const mutationOptions = getPutUserHistoryMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteUserHistoryResponse200 = {
  data: Response
  status: 200
}
    
export type deleteUserHistoryResponseSuccess = (deleteUserHistoryResponse200) & {
  headers: Headers;
};
;

export type deleteUserHistoryResponse = (deleteUserHistoryResponseSuccess)

export const getDeleteUserHistoryUrl = (params: DeleteUserHistoryParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/user_history?${stringifiedParams}` : `/user_history`
}

export const deleteUserHistory = async (params: DeleteUserHistoryParams, options?: RequestInit): Promise<deleteUserHistoryResponse> => {
  
  return useCustomClient<deleteUserHistoryResponse>(getDeleteUserHistoryUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteUserHistoryMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUserHistory>>, TError,{params: DeleteUserHistoryParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteUserHistory>>, TError,{params: DeleteUserHistoryParams}, TContext> => {

const mutationKey = ['deleteUserHistory'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteUserHistory>>, {params: DeleteUserHistoryParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteUserHistory(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteUserHistoryMutationResult = NonNullable<Awaited<ReturnType<typeof deleteUserHistory>>>
    
    export type DeleteUserHistoryMutationError = ErrorType<unknown>

    export const useDeleteUserHistory = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUserHistory>>, TError,{params: DeleteUserHistoryParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteUserHistory>>,
        TError,
        {params: DeleteUserHistoryParams},
        TContext
      > => {

      const mutationOptions = getDeleteUserHistoryMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    