/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteUsersFavoriteIdParams,
  GetUsersAdminParams,
  GetUsersClubParams,
  GetUsersFavoriteOrgParams,
  GetUsersFavoriteProductsParams,
  GetUsersParams,
  GetUsersPartakerParams,
  GetUsersPrintParams,
  GetUsersValidationParams,
  GetUsersWithoutMembershipFeeByYearParams,
  PostUsersAdminParams,
  PostUsersFavoriteAddBody,
  PostUsersFavoriteAddParams,
  Response,
  UserAdmin,
  UserBody,
  UserClubBody,
  UserValidation
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Get
 */
export type getUsersIdResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersIdResponseSuccess = (getUsersIdResponse200) & {
  headers: Headers;
};
;

export type getUsersIdResponse = (getUsersIdResponseSuccess)

export const getGetUsersIdUrl = (id: string,) => {


  

  return `/users/${id}`
}

export const getUsersId = async (id: string, options?: RequestInit): Promise<getUsersIdResponse> => {
  
  return useCustomClient<getUsersIdResponse>(getGetUsersIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/users/${id}`
    ] as const;
    }

export const getGetUsersIdQueryKey = (id?: string,) => {
    return [
    `/users/${id}`
    ] as const;
    }

    
export const getGetUsersIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersId>>> = ({ signal }) => getUsersId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersId>>>
export type GetUsersIdInfiniteQueryError = ErrorType<unknown>


export function useGetUsersIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersId>>,
          TError,
          Awaited<ReturnType<typeof getUsersId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersId>>,
          TError,
          Awaited<ReturnType<typeof getUsersId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersIdQueryOptions = <TData = Awaited<ReturnType<typeof getUsersId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersId>>> = ({ signal }) => getUsersId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersIdQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersId>>>
export type GetUsersIdQueryError = ErrorType<unknown>


export function useGetUsersId<TData = Awaited<ReturnType<typeof getUsersId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersId>>,
          TError,
          Awaited<ReturnType<typeof getUsersId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersId<TData = Awaited<ReturnType<typeof getUsersId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersId>>,
          TError,
          Awaited<ReturnType<typeof getUsersId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersId<TData = Awaited<ReturnType<typeof getUsersId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersId<TData = Awaited<ReturnType<typeof getUsersId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersIdQuery = async <TData = Awaited<ReturnType<typeof getUsersId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putUsersIdResponse200 = {
  data: Response
  status: 200
}
    
export type putUsersIdResponseSuccess = (putUsersIdResponse200) & {
  headers: Headers;
};
;

export type putUsersIdResponse = (putUsersIdResponseSuccess)

export const getPutUsersIdUrl = (id: string,) => {


  

  return `/users/${id}`
}

export const putUsersId = async (id: string,
    userBody: UserBody, options?: RequestInit): Promise<putUsersIdResponse> => {
  
  return useCustomClient<putUsersIdResponse>(getPutUsersIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      userBody,)
  }
);}




export const getPutUsersIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putUsersId>>, TError,{id: string;data: BodyType<UserBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putUsersId>>, TError,{id: string;data: BodyType<UserBody>}, TContext> => {

const mutationKey = ['putUsersId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putUsersId>>, {id: string;data: BodyType<UserBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putUsersId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutUsersIdMutationResult = NonNullable<Awaited<ReturnType<typeof putUsersId>>>
    export type PutUsersIdMutationBody = BodyType<UserBody>
    export type PutUsersIdMutationError = ErrorType<unknown>

    export const usePutUsersId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putUsersId>>, TError,{id: string;data: BodyType<UserBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putUsersId>>,
        TError,
        {id: string;data: BodyType<UserBody>},
        TContext
      > => {

      const mutationOptions = getPutUsersIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteUsersIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteUsersIdResponseSuccess = (deleteUsersIdResponse200) & {
  headers: Headers;
};
;

export type deleteUsersIdResponse = (deleteUsersIdResponseSuccess)

export const getDeleteUsersIdUrl = (id: string,) => {


  

  return `/users/${id}`
}

export const deleteUsersId = async (id: string, options?: RequestInit): Promise<deleteUsersIdResponse> => {
  
  return useCustomClient<deleteUsersIdResponse>(getDeleteUsersIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteUsersIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUsersId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteUsersId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteUsersId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteUsersId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteUsersId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteUsersIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteUsersId>>>
    
    export type DeleteUsersIdMutationError = ErrorType<unknown>

    export const useDeleteUsersId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUsersId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteUsersId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteUsersIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getUsersAdminResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersAdminResponseSuccess = (getUsersAdminResponse200) & {
  headers: Headers;
};
;

export type getUsersAdminResponse = (getUsersAdminResponseSuccess)

export const getGetUsersAdminUrl = (params?: GetUsersAdminParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/admin?${stringifiedParams}` : `/users/admin`
}

export const getUsersAdmin = async (params?: GetUsersAdminParams, options?: RequestInit): Promise<getUsersAdminResponse> => {
  
  return useCustomClient<getUsersAdminResponse>(getGetUsersAdminUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersAdminInfiniteQueryKey = (params?: GetUsersAdminParams,) => {
    return [
    'infinite', `/users/admin`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetUsersAdminQueryKey = (params?: GetUsersAdminParams,) => {
    return [
    `/users/admin`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetUsersAdminInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersAdmin>>>, TError = ErrorType<unknown>>(params?: GetUsersAdminParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersAdminInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersAdmin>>> = ({ signal }) => getUsersAdmin(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersAdminInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersAdmin>>>
export type GetUsersAdminInfiniteQueryError = ErrorType<unknown>


export function useGetUsersAdminInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersAdmin>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersAdminParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersAdmin>>,
          TError,
          Awaited<ReturnType<typeof getUsersAdmin>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersAdminInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersAdmin>>>, TError = ErrorType<unknown>>(
 params?: GetUsersAdminParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersAdmin>>,
          TError,
          Awaited<ReturnType<typeof getUsersAdmin>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersAdminInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersAdmin>>>, TError = ErrorType<unknown>>(
 params?: GetUsersAdminParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersAdminInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersAdmin>>>, TError = ErrorType<unknown>>(
 params?: GetUsersAdminParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersAdminInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersAdminInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersAdmin>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersAdminParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersAdminInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersAdminQueryOptions = <TData = Awaited<ReturnType<typeof getUsersAdmin>>, TError = ErrorType<unknown>>(params?: GetUsersAdminParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersAdminQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersAdmin>>> = ({ signal }) => getUsersAdmin(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersAdminQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersAdmin>>>
export type GetUsersAdminQueryError = ErrorType<unknown>


export function useGetUsersAdmin<TData = Awaited<ReturnType<typeof getUsersAdmin>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersAdminParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersAdmin>>,
          TError,
          Awaited<ReturnType<typeof getUsersAdmin>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersAdmin<TData = Awaited<ReturnType<typeof getUsersAdmin>>, TError = ErrorType<unknown>>(
 params?: GetUsersAdminParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersAdmin>>,
          TError,
          Awaited<ReturnType<typeof getUsersAdmin>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersAdmin<TData = Awaited<ReturnType<typeof getUsersAdmin>>, TError = ErrorType<unknown>>(
 params?: GetUsersAdminParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersAdmin<TData = Awaited<ReturnType<typeof getUsersAdmin>>, TError = ErrorType<unknown>>(
 params?: GetUsersAdminParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersAdminQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersAdminQuery = async <TData = Awaited<ReturnType<typeof getUsersAdmin>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersAdminParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersAdmin>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersAdminQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postUsersAdminResponse200 = {
  data: Response
  status: 200
}
    
export type postUsersAdminResponseSuccess = (postUsersAdminResponse200) & {
  headers: Headers;
};
;

export type postUsersAdminResponse = (postUsersAdminResponseSuccess)

export const getPostUsersAdminUrl = (params: PostUsersAdminParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/admin?${stringifiedParams}` : `/users/admin`
}

export const postUsersAdmin = async (userAdmin: UserAdmin[],
    params: PostUsersAdminParams, options?: RequestInit): Promise<postUsersAdminResponse> => {
  
  return useCustomClient<postUsersAdminResponse>(getPostUsersAdminUrl(params),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      userAdmin,)
  }
);}




export const getPostUsersAdminMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsersAdmin>>, TError,{data: BodyType<UserAdmin[]>;params: PostUsersAdminParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postUsersAdmin>>, TError,{data: BodyType<UserAdmin[]>;params: PostUsersAdminParams}, TContext> => {

const mutationKey = ['postUsersAdmin'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postUsersAdmin>>, {data: BodyType<UserAdmin[]>;params: PostUsersAdminParams}> = (props) => {
          const {data,params} = props ?? {};

          return  postUsersAdmin(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostUsersAdminMutationResult = NonNullable<Awaited<ReturnType<typeof postUsersAdmin>>>
    export type PostUsersAdminMutationBody = BodyType<UserAdmin[]>
    export type PostUsersAdminMutationError = ErrorType<unknown>

    export const usePostUsersAdmin = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsersAdmin>>, TError,{data: BodyType<UserAdmin[]>;params: PostUsersAdminParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postUsersAdmin>>,
        TError,
        {data: BodyType<UserAdmin[]>;params: PostUsersAdminParams},
        TContext
      > => {

      const mutationOptions = getPostUsersAdminMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putUsersClubIdResponse200 = {
  data: Response
  status: 200
}
    
export type putUsersClubIdResponseSuccess = (putUsersClubIdResponse200) & {
  headers: Headers;
};
;

export type putUsersClubIdResponse = (putUsersClubIdResponseSuccess)

export const getPutUsersClubIdUrl = (id: string,) => {


  

  return `/users/club/${id}`
}

export const putUsersClubId = async (id: string,
    userClubBody: UserClubBody, options?: RequestInit): Promise<putUsersClubIdResponse> => {
  
  return useCustomClient<putUsersClubIdResponse>(getPutUsersClubIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      userClubBody,)
  }
);}




export const getPutUsersClubIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putUsersClubId>>, TError,{id: string;data: BodyType<UserClubBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putUsersClubId>>, TError,{id: string;data: BodyType<UserClubBody>}, TContext> => {

const mutationKey = ['putUsersClubId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putUsersClubId>>, {id: string;data: BodyType<UserClubBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putUsersClubId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutUsersClubIdMutationResult = NonNullable<Awaited<ReturnType<typeof putUsersClubId>>>
    export type PutUsersClubIdMutationBody = BodyType<UserClubBody>
    export type PutUsersClubIdMutationError = ErrorType<unknown>

    export const usePutUsersClubId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putUsersClubId>>, TError,{id: string;data: BodyType<UserClubBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putUsersClubId>>,
        TError,
        {id: string;data: BodyType<UserClubBody>},
        TContext
      > => {

      const mutationOptions = getPutUsersClubIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getUsersClubResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersClubResponseSuccess = (getUsersClubResponse200) & {
  headers: Headers;
};
;

export type getUsersClubResponse = (getUsersClubResponseSuccess)

export const getGetUsersClubUrl = (params?: GetUsersClubParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/club?${stringifiedParams}` : `/users/club`
}

export const getUsersClub = async (params?: GetUsersClubParams, options?: RequestInit): Promise<getUsersClubResponse> => {
  
  return useCustomClient<getUsersClubResponse>(getGetUsersClubUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersClubInfiniteQueryKey = (params?: GetUsersClubParams,) => {
    return [
    'infinite', `/users/club`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetUsersClubQueryKey = (params?: GetUsersClubParams,) => {
    return [
    `/users/club`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetUsersClubInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersClub>>>, TError = ErrorType<unknown>>(params?: GetUsersClubParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersClubInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersClub>>> = ({ signal }) => getUsersClub(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersClubInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersClub>>>
export type GetUsersClubInfiniteQueryError = ErrorType<unknown>


export function useGetUsersClubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersClub>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersClubParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersClub>>,
          TError,
          Awaited<ReturnType<typeof getUsersClub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersClubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersClub>>>, TError = ErrorType<unknown>>(
 params?: GetUsersClubParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersClub>>,
          TError,
          Awaited<ReturnType<typeof getUsersClub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersClubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersClub>>>, TError = ErrorType<unknown>>(
 params?: GetUsersClubParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersClubInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersClub>>>, TError = ErrorType<unknown>>(
 params?: GetUsersClubParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersClubInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersClubInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersClub>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersClubParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersClubInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersClubQueryOptions = <TData = Awaited<ReturnType<typeof getUsersClub>>, TError = ErrorType<unknown>>(params?: GetUsersClubParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersClubQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersClub>>> = ({ signal }) => getUsersClub(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersClubQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersClub>>>
export type GetUsersClubQueryError = ErrorType<unknown>


export function useGetUsersClub<TData = Awaited<ReturnType<typeof getUsersClub>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersClubParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersClub>>,
          TError,
          Awaited<ReturnType<typeof getUsersClub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersClub<TData = Awaited<ReturnType<typeof getUsersClub>>, TError = ErrorType<unknown>>(
 params?: GetUsersClubParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersClub>>,
          TError,
          Awaited<ReturnType<typeof getUsersClub>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersClub<TData = Awaited<ReturnType<typeof getUsersClub>>, TError = ErrorType<unknown>>(
 params?: GetUsersClubParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersClub<TData = Awaited<ReturnType<typeof getUsersClub>>, TError = ErrorType<unknown>>(
 params?: GetUsersClubParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersClubQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersClubQuery = async <TData = Awaited<ReturnType<typeof getUsersClub>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersClubParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersClub>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersClubQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postUsersClubResponse200 = {
  data: Response
  status: 200
}
    
export type postUsersClubResponseSuccess = (postUsersClubResponse200) & {
  headers: Headers;
};
;

export type postUsersClubResponse = (postUsersClubResponseSuccess)

export const getPostUsersClubUrl = () => {


  

  return `/users/club`
}

export const postUsersClub = async (userClubBody: UserClubBody, options?: RequestInit): Promise<postUsersClubResponse> => {
  
  return useCustomClient<postUsersClubResponse>(getPostUsersClubUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      userClubBody,)
  }
);}




export const getPostUsersClubMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsersClub>>, TError,{data: BodyType<UserClubBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postUsersClub>>, TError,{data: BodyType<UserClubBody>}, TContext> => {

const mutationKey = ['postUsersClub'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postUsersClub>>, {data: BodyType<UserClubBody>}> = (props) => {
          const {data} = props ?? {};

          return  postUsersClub(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostUsersClubMutationResult = NonNullable<Awaited<ReturnType<typeof postUsersClub>>>
    export type PostUsersClubMutationBody = BodyType<UserClubBody>
    export type PostUsersClubMutationError = ErrorType<unknown>

    export const usePostUsersClub = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsersClub>>, TError,{data: BodyType<UserClubBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postUsersClub>>,
        TError,
        {data: BodyType<UserClubBody>},
        TContext
      > => {

      const mutationOptions = getPostUsersClubMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteUsersFavoriteIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteUsersFavoriteIdResponseSuccess = (deleteUsersFavoriteIdResponse200) & {
  headers: Headers;
};
;

export type deleteUsersFavoriteIdResponse = (deleteUsersFavoriteIdResponseSuccess)

export const getDeleteUsersFavoriteIdUrl = (id: string,
    params: DeleteUsersFavoriteIdParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/favorite/${id}?${stringifiedParams}` : `/users/favorite/${id}`
}

export const deleteUsersFavoriteId = async (id: string,
    params: DeleteUsersFavoriteIdParams, options?: RequestInit): Promise<deleteUsersFavoriteIdResponse> => {
  
  return useCustomClient<deleteUsersFavoriteIdResponse>(getDeleteUsersFavoriteIdUrl(id,params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteUsersFavoriteIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUsersFavoriteId>>, TError,{id: string;params: DeleteUsersFavoriteIdParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteUsersFavoriteId>>, TError,{id: string;params: DeleteUsersFavoriteIdParams}, TContext> => {

const mutationKey = ['deleteUsersFavoriteId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteUsersFavoriteId>>, {id: string;params: DeleteUsersFavoriteIdParams}> = (props) => {
          const {id,params} = props ?? {};

          return  deleteUsersFavoriteId(id,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteUsersFavoriteIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteUsersFavoriteId>>>
    
    export type DeleteUsersFavoriteIdMutationError = ErrorType<unknown>

    export const useDeleteUsersFavoriteId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteUsersFavoriteId>>, TError,{id: string;params: DeleteUsersFavoriteIdParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteUsersFavoriteId>>,
        TError,
        {id: string;params: DeleteUsersFavoriteIdParams},
        TContext
      > => {

      const mutationOptions = getDeleteUsersFavoriteIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Users
 */
export type postUsersFavoriteAddResponse200 = {
  data: Response
  status: 200
}
    
export type postUsersFavoriteAddResponseSuccess = (postUsersFavoriteAddResponse200) & {
  headers: Headers;
};
;

export type postUsersFavoriteAddResponse = (postUsersFavoriteAddResponseSuccess)

export const getPostUsersFavoriteAddUrl = (params: PostUsersFavoriteAddParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/favorite/add?${stringifiedParams}` : `/users/favorite/add`
}

export const postUsersFavoriteAdd = async (postUsersFavoriteAddBody: PostUsersFavoriteAddBody,
    params: PostUsersFavoriteAddParams, options?: RequestInit): Promise<postUsersFavoriteAddResponse> => {
  
  return useCustomClient<postUsersFavoriteAddResponse>(getPostUsersFavoriteAddUrl(params),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      postUsersFavoriteAddBody,)
  }
);}




export const getPostUsersFavoriteAddMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsersFavoriteAdd>>, TError,{data: BodyType<PostUsersFavoriteAddBody>;params: PostUsersFavoriteAddParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postUsersFavoriteAdd>>, TError,{data: BodyType<PostUsersFavoriteAddBody>;params: PostUsersFavoriteAddParams}, TContext> => {

const mutationKey = ['postUsersFavoriteAdd'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postUsersFavoriteAdd>>, {data: BodyType<PostUsersFavoriteAddBody>;params: PostUsersFavoriteAddParams}> = (props) => {
          const {data,params} = props ?? {};

          return  postUsersFavoriteAdd(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostUsersFavoriteAddMutationResult = NonNullable<Awaited<ReturnType<typeof postUsersFavoriteAdd>>>
    export type PostUsersFavoriteAddMutationBody = BodyType<PostUsersFavoriteAddBody>
    export type PostUsersFavoriteAddMutationError = ErrorType<unknown>

    export const usePostUsersFavoriteAdd = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsersFavoriteAdd>>, TError,{data: BodyType<PostUsersFavoriteAddBody>;params: PostUsersFavoriteAddParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postUsersFavoriteAdd>>,
        TError,
        {data: BodyType<PostUsersFavoriteAddBody>;params: PostUsersFavoriteAddParams},
        TContext
      > => {

      const mutationOptions = getPostUsersFavoriteAddMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getUsersFavoriteOrgResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersFavoriteOrgResponseSuccess = (getUsersFavoriteOrgResponse200) & {
  headers: Headers;
};
;

export type getUsersFavoriteOrgResponse = (getUsersFavoriteOrgResponseSuccess)

export const getGetUsersFavoriteOrgUrl = (params?: GetUsersFavoriteOrgParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/favorite/org?${stringifiedParams}` : `/users/favorite/org`
}

export const getUsersFavoriteOrg = async (params?: GetUsersFavoriteOrgParams, options?: RequestInit): Promise<getUsersFavoriteOrgResponse> => {
  
  return useCustomClient<getUsersFavoriteOrgResponse>(getGetUsersFavoriteOrgUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersFavoriteOrgInfiniteQueryKey = (params?: GetUsersFavoriteOrgParams,) => {
    return [
    'infinite', `/users/favorite/org`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetUsersFavoriteOrgQueryKey = (params?: GetUsersFavoriteOrgParams,) => {
    return [
    `/users/favorite/org`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetUsersFavoriteOrgInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersFavoriteOrg>>>, TError = ErrorType<unknown>>(params?: GetUsersFavoriteOrgParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersFavoriteOrgInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersFavoriteOrg>>> = ({ signal }) => getUsersFavoriteOrg(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersFavoriteOrgInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersFavoriteOrg>>>
export type GetUsersFavoriteOrgInfiniteQueryError = ErrorType<unknown>


export function useGetUsersFavoriteOrgInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersFavoriteOrg>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersFavoriteOrgParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersFavoriteOrg>>,
          TError,
          Awaited<ReturnType<typeof getUsersFavoriteOrg>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersFavoriteOrgInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersFavoriteOrg>>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteOrgParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersFavoriteOrg>>,
          TError,
          Awaited<ReturnType<typeof getUsersFavoriteOrg>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersFavoriteOrgInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersFavoriteOrg>>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteOrgParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersFavoriteOrgInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersFavoriteOrg>>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteOrgParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersFavoriteOrgInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersFavoriteOrgInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersFavoriteOrgParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersFavoriteOrgInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersFavoriteOrgQueryOptions = <TData = Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError = ErrorType<unknown>>(params?: GetUsersFavoriteOrgParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersFavoriteOrgQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersFavoriteOrg>>> = ({ signal }) => getUsersFavoriteOrg(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersFavoriteOrgQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersFavoriteOrg>>>
export type GetUsersFavoriteOrgQueryError = ErrorType<unknown>


export function useGetUsersFavoriteOrg<TData = Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersFavoriteOrgParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersFavoriteOrg>>,
          TError,
          Awaited<ReturnType<typeof getUsersFavoriteOrg>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersFavoriteOrg<TData = Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteOrgParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersFavoriteOrg>>,
          TError,
          Awaited<ReturnType<typeof getUsersFavoriteOrg>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersFavoriteOrg<TData = Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteOrgParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersFavoriteOrg<TData = Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteOrgParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersFavoriteOrgQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersFavoriteOrgQuery = async <TData = Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersFavoriteOrgParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteOrg>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersFavoriteOrgQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getUsersFavoriteProductsResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersFavoriteProductsResponseSuccess = (getUsersFavoriteProductsResponse200) & {
  headers: Headers;
};
;

export type getUsersFavoriteProductsResponse = (getUsersFavoriteProductsResponseSuccess)

export const getGetUsersFavoriteProductsUrl = (params?: GetUsersFavoriteProductsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/favorite/products?${stringifiedParams}` : `/users/favorite/products`
}

export const getUsersFavoriteProducts = async (params?: GetUsersFavoriteProductsParams, options?: RequestInit): Promise<getUsersFavoriteProductsResponse> => {
  
  return useCustomClient<getUsersFavoriteProductsResponse>(getGetUsersFavoriteProductsUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersFavoriteProductsInfiniteQueryKey = (params?: GetUsersFavoriteProductsParams,) => {
    return [
    'infinite', `/users/favorite/products`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetUsersFavoriteProductsQueryKey = (params?: GetUsersFavoriteProductsParams,) => {
    return [
    `/users/favorite/products`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetUsersFavoriteProductsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersFavoriteProducts>>>, TError = ErrorType<unknown>>(params?: GetUsersFavoriteProductsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersFavoriteProductsInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersFavoriteProducts>>> = ({ signal }) => getUsersFavoriteProducts(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersFavoriteProductsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersFavoriteProducts>>>
export type GetUsersFavoriteProductsInfiniteQueryError = ErrorType<unknown>


export function useGetUsersFavoriteProductsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersFavoriteProducts>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersFavoriteProductsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersFavoriteProducts>>,
          TError,
          Awaited<ReturnType<typeof getUsersFavoriteProducts>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersFavoriteProductsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersFavoriteProducts>>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteProductsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersFavoriteProducts>>,
          TError,
          Awaited<ReturnType<typeof getUsersFavoriteProducts>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersFavoriteProductsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersFavoriteProducts>>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteProductsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersFavoriteProductsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersFavoriteProducts>>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteProductsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersFavoriteProductsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersFavoriteProductsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersFavoriteProductsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersFavoriteProductsInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersFavoriteProductsQueryOptions = <TData = Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError = ErrorType<unknown>>(params?: GetUsersFavoriteProductsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersFavoriteProductsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersFavoriteProducts>>> = ({ signal }) => getUsersFavoriteProducts(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersFavoriteProductsQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersFavoriteProducts>>>
export type GetUsersFavoriteProductsQueryError = ErrorType<unknown>


export function useGetUsersFavoriteProducts<TData = Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersFavoriteProductsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersFavoriteProducts>>,
          TError,
          Awaited<ReturnType<typeof getUsersFavoriteProducts>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersFavoriteProducts<TData = Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteProductsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersFavoriteProducts>>,
          TError,
          Awaited<ReturnType<typeof getUsersFavoriteProducts>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersFavoriteProducts<TData = Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteProductsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersFavoriteProducts<TData = Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError = ErrorType<unknown>>(
 params?: GetUsersFavoriteProductsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersFavoriteProductsQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersFavoriteProductsQuery = async <TData = Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersFavoriteProductsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersFavoriteProducts>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersFavoriteProductsQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getUsersGetMyInfoResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersGetMyInfoResponseSuccess = (getUsersGetMyInfoResponse200) & {
  headers: Headers;
};
;

export type getUsersGetMyInfoResponse = (getUsersGetMyInfoResponseSuccess)

export const getGetUsersGetMyInfoUrl = () => {


  

  return `/users/getMyInfo`
}

export const getUsersGetMyInfo = async ( options?: RequestInit): Promise<getUsersGetMyInfoResponse> => {
  
  return useCustomClient<getUsersGetMyInfoResponse>(getGetUsersGetMyInfoUrl(),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersGetMyInfoInfiniteQueryKey = () => {
    return [
    'infinite', `/users/getMyInfo`
    ] as const;
    }

export const getGetUsersGetMyInfoQueryKey = () => {
    return [
    `/users/getMyInfo`
    ] as const;
    }

    
export const getGetUsersGetMyInfoInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersGetMyInfo>>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersGetMyInfoInfiniteQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersGetMyInfo>>> = ({ signal }) => getUsersGetMyInfo({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersGetMyInfoInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersGetMyInfo>>>
export type GetUsersGetMyInfoInfiniteQueryError = ErrorType<unknown>


export function useGetUsersGetMyInfoInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersGetMyInfo>>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersGetMyInfo>>,
          TError,
          Awaited<ReturnType<typeof getUsersGetMyInfo>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersGetMyInfoInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersGetMyInfo>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersGetMyInfo>>,
          TError,
          Awaited<ReturnType<typeof getUsersGetMyInfo>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersGetMyInfoInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersGetMyInfo>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersGetMyInfoInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersGetMyInfo>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersGetMyInfoInfiniteQueryOptions(options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersGetMyInfoInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersGetMyInfoInfiniteQueryOptions(options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersGetMyInfoQueryOptions = <TData = Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersGetMyInfoQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersGetMyInfo>>> = ({ signal }) => getUsersGetMyInfo({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersGetMyInfoQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersGetMyInfo>>>
export type GetUsersGetMyInfoQueryError = ErrorType<unknown>


export function useGetUsersGetMyInfo<TData = Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersGetMyInfo>>,
          TError,
          Awaited<ReturnType<typeof getUsersGetMyInfo>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersGetMyInfo<TData = Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersGetMyInfo>>,
          TError,
          Awaited<ReturnType<typeof getUsersGetMyInfo>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersGetMyInfo<TData = Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersGetMyInfo<TData = Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersGetMyInfoQueryOptions(options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersGetMyInfoQuery = async <TData = Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersGetMyInfo>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersGetMyInfoQueryOptions(options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getUsersResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersResponseSuccess = (getUsersResponse200) & {
  headers: Headers;
};
;

export type getUsersResponse = (getUsersResponseSuccess)

export const getGetUsersUrl = (params?: GetUsersParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users?${stringifiedParams}` : `/users`
}

export const getUsers = async (params?: GetUsersParams, options?: RequestInit): Promise<getUsersResponse> => {
  
  return useCustomClient<getUsersResponse>(getGetUsersUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersInfiniteQueryKey = (params?: GetUsersParams,) => {
    return [
    'infinite', `/users`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetUsersQueryKey = (params?: GetUsersParams,) => {
    return [
    `/users`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetUsersInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsers>>>, TError = ErrorType<unknown>>(params?: GetUsersParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsers>>> = ({ signal }) => getUsers(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsers>>>
export type GetUsersInfiniteQueryError = ErrorType<unknown>


export function useGetUsersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsers>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsers>>,
          TError,
          Awaited<ReturnType<typeof getUsers>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsers>>>, TError = ErrorType<unknown>>(
 params?: GetUsersParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsers>>,
          TError,
          Awaited<ReturnType<typeof getUsers>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsers>>>, TError = ErrorType<unknown>>(
 params?: GetUsersParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsers>>>, TError = ErrorType<unknown>>(
 params?: GetUsersParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsers>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersQueryOptions = <TData = Awaited<ReturnType<typeof getUsers>>, TError = ErrorType<unknown>>(params?: GetUsersParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsers>>> = ({ signal }) => getUsers(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersQueryResult = NonNullable<Awaited<ReturnType<typeof getUsers>>>
export type GetUsersQueryError = ErrorType<unknown>


export function useGetUsers<TData = Awaited<ReturnType<typeof getUsers>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsers>>,
          TError,
          Awaited<ReturnType<typeof getUsers>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsers<TData = Awaited<ReturnType<typeof getUsers>>, TError = ErrorType<unknown>>(
 params?: GetUsersParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsers>>,
          TError,
          Awaited<ReturnType<typeof getUsers>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsers<TData = Awaited<ReturnType<typeof getUsers>>, TError = ErrorType<unknown>>(
 params?: GetUsersParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsers<TData = Awaited<ReturnType<typeof getUsers>>, TError = ErrorType<unknown>>(
 params?: GetUsersParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersQuery = async <TData = Awaited<ReturnType<typeof getUsers>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsers>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postUsersResponse200 = {
  data: Response
  status: 200
}
    
export type postUsersResponseSuccess = (postUsersResponse200) & {
  headers: Headers;
};
;

export type postUsersResponse = (postUsersResponseSuccess)

export const getPostUsersUrl = () => {


  

  return `/users`
}

export const postUsers = async ( options?: RequestInit): Promise<postUsersResponse> => {
  
  return useCustomClient<postUsersResponse>(getPostUsersUrl(),
  {      
    ...options,
    method: 'POST'
    
    
  }
);}




export const getPostUsersMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsers>>, TError,void, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postUsers>>, TError,void, TContext> => {

const mutationKey = ['postUsers'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postUsers>>, void> = () => {
          

          return  postUsers(requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostUsersMutationResult = NonNullable<Awaited<ReturnType<typeof postUsers>>>
    
    export type PostUsersMutationError = ErrorType<unknown>

    export const usePostUsers = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsers>>, TError,void, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postUsers>>,
        TError,
        void,
        TContext
      > => {

      const mutationOptions = getPostUsersMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getUsersPartakerResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersPartakerResponseSuccess = (getUsersPartakerResponse200) & {
  headers: Headers;
};
;

export type getUsersPartakerResponse = (getUsersPartakerResponseSuccess)

export const getGetUsersPartakerUrl = (params?: GetUsersPartakerParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/partaker?${stringifiedParams}` : `/users/partaker`
}

export const getUsersPartaker = async (params?: GetUsersPartakerParams, options?: RequestInit): Promise<getUsersPartakerResponse> => {
  
  return useCustomClient<getUsersPartakerResponse>(getGetUsersPartakerUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersPartakerInfiniteQueryKey = (params?: GetUsersPartakerParams,) => {
    return [
    'infinite', `/users/partaker`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetUsersPartakerQueryKey = (params?: GetUsersPartakerParams,) => {
    return [
    `/users/partaker`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetUsersPartakerInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersPartaker>>>, TError = ErrorType<unknown>>(params?: GetUsersPartakerParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersPartakerInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersPartaker>>> = ({ signal }) => getUsersPartaker(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersPartakerInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersPartaker>>>
export type GetUsersPartakerInfiniteQueryError = ErrorType<unknown>


export function useGetUsersPartakerInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersPartaker>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersPartakerParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersPartaker>>,
          TError,
          Awaited<ReturnType<typeof getUsersPartaker>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersPartakerInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersPartaker>>>, TError = ErrorType<unknown>>(
 params?: GetUsersPartakerParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersPartaker>>,
          TError,
          Awaited<ReturnType<typeof getUsersPartaker>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersPartakerInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersPartaker>>>, TError = ErrorType<unknown>>(
 params?: GetUsersPartakerParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersPartakerInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersPartaker>>>, TError = ErrorType<unknown>>(
 params?: GetUsersPartakerParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersPartakerInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersPartakerInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersPartaker>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersPartakerParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersPartakerInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersPartakerQueryOptions = <TData = Awaited<ReturnType<typeof getUsersPartaker>>, TError = ErrorType<unknown>>(params?: GetUsersPartakerParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersPartakerQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersPartaker>>> = ({ signal }) => getUsersPartaker(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersPartakerQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersPartaker>>>
export type GetUsersPartakerQueryError = ErrorType<unknown>


export function useGetUsersPartaker<TData = Awaited<ReturnType<typeof getUsersPartaker>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersPartakerParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersPartaker>>,
          TError,
          Awaited<ReturnType<typeof getUsersPartaker>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersPartaker<TData = Awaited<ReturnType<typeof getUsersPartaker>>, TError = ErrorType<unknown>>(
 params?: GetUsersPartakerParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersPartaker>>,
          TError,
          Awaited<ReturnType<typeof getUsersPartaker>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersPartaker<TData = Awaited<ReturnType<typeof getUsersPartaker>>, TError = ErrorType<unknown>>(
 params?: GetUsersPartakerParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersPartaker<TData = Awaited<ReturnType<typeof getUsersPartaker>>, TError = ErrorType<unknown>>(
 params?: GetUsersPartakerParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersPartakerQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersPartakerQuery = async <TData = Awaited<ReturnType<typeof getUsersPartaker>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersPartakerParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPartaker>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersPartakerQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getUsersPrintResponse200 = {
  data: Blob
  status: 200
}
    
export type getUsersPrintResponseSuccess = (getUsersPrintResponse200) & {
  headers: Headers;
};
;

export type getUsersPrintResponse = (getUsersPrintResponseSuccess)

export const getGetUsersPrintUrl = (params?: GetUsersPrintParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/print?${stringifiedParams}` : `/users/print`
}

export const getUsersPrint = async (params?: GetUsersPrintParams, options?: RequestInit): Promise<getUsersPrintResponse> => {
  
  return useCustomClient<getUsersPrintResponse>(getGetUsersPrintUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersPrintInfiniteQueryKey = (params?: GetUsersPrintParams,) => {
    return [
    'infinite', `/users/print`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetUsersPrintQueryKey = (params?: GetUsersPrintParams,) => {
    return [
    `/users/print`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetUsersPrintInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersPrint>>>, TError = ErrorType<unknown>>(params?: GetUsersPrintParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersPrintInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersPrint>>> = ({ signal }) => getUsersPrint(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersPrintInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersPrint>>>
export type GetUsersPrintInfiniteQueryError = ErrorType<unknown>


export function useGetUsersPrintInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersPrint>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersPrintParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersPrint>>,
          TError,
          Awaited<ReturnType<typeof getUsersPrint>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersPrintInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersPrint>>>, TError = ErrorType<unknown>>(
 params?: GetUsersPrintParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersPrint>>,
          TError,
          Awaited<ReturnType<typeof getUsersPrint>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersPrintInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersPrint>>>, TError = ErrorType<unknown>>(
 params?: GetUsersPrintParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersPrintInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersPrint>>>, TError = ErrorType<unknown>>(
 params?: GetUsersPrintParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersPrintInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersPrintInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersPrint>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersPrintParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersPrintInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersPrintQueryOptions = <TData = Awaited<ReturnType<typeof getUsersPrint>>, TError = ErrorType<unknown>>(params?: GetUsersPrintParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersPrintQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersPrint>>> = ({ signal }) => getUsersPrint(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersPrintQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersPrint>>>
export type GetUsersPrintQueryError = ErrorType<unknown>


export function useGetUsersPrint<TData = Awaited<ReturnType<typeof getUsersPrint>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersPrintParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersPrint>>,
          TError,
          Awaited<ReturnType<typeof getUsersPrint>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersPrint<TData = Awaited<ReturnType<typeof getUsersPrint>>, TError = ErrorType<unknown>>(
 params?: GetUsersPrintParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersPrint>>,
          TError,
          Awaited<ReturnType<typeof getUsersPrint>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersPrint<TData = Awaited<ReturnType<typeof getUsersPrint>>, TError = ErrorType<unknown>>(
 params?: GetUsersPrintParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersPrint<TData = Awaited<ReturnType<typeof getUsersPrint>>, TError = ErrorType<unknown>>(
 params?: GetUsersPrintParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersPrintQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersPrintQuery = async <TData = Awaited<ReturnType<typeof getUsersPrint>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersPrintParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersPrint>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersPrintQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getUsersValidationUserIdResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersValidationUserIdResponseSuccess = (getUsersValidationUserIdResponse200) & {
  headers: Headers;
};
;

export type getUsersValidationUserIdResponse = (getUsersValidationUserIdResponseSuccess)

export const getGetUsersValidationUserIdUrl = (userId: string,) => {


  

  return `/users/validation/${userId}`
}

export const getUsersValidationUserId = async (userId: string, options?: RequestInit): Promise<getUsersValidationUserIdResponse> => {
  
  return useCustomClient<getUsersValidationUserIdResponse>(getGetUsersValidationUserIdUrl(userId),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersValidationUserIdInfiniteQueryKey = (userId?: string,) => {
    return [
    'infinite', `/users/validation/${userId}`
    ] as const;
    }

export const getGetUsersValidationUserIdQueryKey = (userId?: string,) => {
    return [
    `/users/validation/${userId}`
    ] as const;
    }

    
export const getGetUsersValidationUserIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersValidationUserId>>>, TError = ErrorType<unknown>>(userId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersValidationUserIdInfiniteQueryKey(userId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersValidationUserId>>> = ({ signal }) => getUsersValidationUserId(userId, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(userId), ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersValidationUserIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersValidationUserId>>>
export type GetUsersValidationUserIdInfiniteQueryError = ErrorType<unknown>


export function useGetUsersValidationUserIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersValidationUserId>>>, TError = ErrorType<unknown>>(
 userId: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersValidationUserId>>,
          TError,
          Awaited<ReturnType<typeof getUsersValidationUserId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersValidationUserIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersValidationUserId>>>, TError = ErrorType<unknown>>(
 userId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersValidationUserId>>,
          TError,
          Awaited<ReturnType<typeof getUsersValidationUserId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersValidationUserIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersValidationUserId>>>, TError = ErrorType<unknown>>(
 userId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersValidationUserIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersValidationUserId>>>, TError = ErrorType<unknown>>(
 userId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersValidationUserIdInfiniteQueryOptions(userId,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersValidationUserIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersValidationUserId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, userId: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersValidationUserIdInfiniteQueryOptions(userId,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersValidationUserIdQueryOptions = <TData = Awaited<ReturnType<typeof getUsersValidationUserId>>, TError = ErrorType<unknown>>(userId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersValidationUserIdQueryKey(userId);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersValidationUserId>>> = ({ signal }) => getUsersValidationUserId(userId, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(userId), ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersValidationUserIdQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersValidationUserId>>>
export type GetUsersValidationUserIdQueryError = ErrorType<unknown>


export function useGetUsersValidationUserId<TData = Awaited<ReturnType<typeof getUsersValidationUserId>>, TError = ErrorType<unknown>>(
 userId: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersValidationUserId>>,
          TError,
          Awaited<ReturnType<typeof getUsersValidationUserId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersValidationUserId<TData = Awaited<ReturnType<typeof getUsersValidationUserId>>, TError = ErrorType<unknown>>(
 userId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersValidationUserId>>,
          TError,
          Awaited<ReturnType<typeof getUsersValidationUserId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersValidationUserId<TData = Awaited<ReturnType<typeof getUsersValidationUserId>>, TError = ErrorType<unknown>>(
 userId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersValidationUserId<TData = Awaited<ReturnType<typeof getUsersValidationUserId>>, TError = ErrorType<unknown>>(
 userId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersValidationUserIdQueryOptions(userId,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersValidationUserIdQuery = async <TData = Awaited<ReturnType<typeof getUsersValidationUserId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, userId: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidationUserId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersValidationUserIdQueryOptions(userId,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getUsersValidationResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersValidationResponseSuccess = (getUsersValidationResponse200) & {
  headers: Headers;
};
;

export type getUsersValidationResponse = (getUsersValidationResponseSuccess)

export const getGetUsersValidationUrl = (params?: GetUsersValidationParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/validation?${stringifiedParams}` : `/users/validation`
}

export const getUsersValidation = async (params?: GetUsersValidationParams, options?: RequestInit): Promise<getUsersValidationResponse> => {
  
  return useCustomClient<getUsersValidationResponse>(getGetUsersValidationUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersValidationInfiniteQueryKey = (params?: GetUsersValidationParams,) => {
    return [
    'infinite', `/users/validation`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetUsersValidationQueryKey = (params?: GetUsersValidationParams,) => {
    return [
    `/users/validation`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetUsersValidationInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersValidation>>>, TError = ErrorType<unknown>>(params?: GetUsersValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersValidationInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersValidation>>> = ({ signal }) => getUsersValidation(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersValidationInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersValidation>>>
export type GetUsersValidationInfiniteQueryError = ErrorType<unknown>


export function useGetUsersValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersValidation>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersValidationParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersValidation>>,
          TError,
          Awaited<ReturnType<typeof getUsersValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersValidation>>>, TError = ErrorType<unknown>>(
 params?: GetUsersValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersValidation>>,
          TError,
          Awaited<ReturnType<typeof getUsersValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersValidation>>>, TError = ErrorType<unknown>>(
 params?: GetUsersValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersValidationInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersValidation>>>, TError = ErrorType<unknown>>(
 params?: GetUsersValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersValidationInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersValidationInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersValidation>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersValidationParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersValidationInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersValidationQueryOptions = <TData = Awaited<ReturnType<typeof getUsersValidation>>, TError = ErrorType<unknown>>(params?: GetUsersValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersValidationQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersValidation>>> = ({ signal }) => getUsersValidation(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersValidationQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersValidation>>>
export type GetUsersValidationQueryError = ErrorType<unknown>


export function useGetUsersValidation<TData = Awaited<ReturnType<typeof getUsersValidation>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersValidationParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersValidation>>,
          TError,
          Awaited<ReturnType<typeof getUsersValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersValidation<TData = Awaited<ReturnType<typeof getUsersValidation>>, TError = ErrorType<unknown>>(
 params?: GetUsersValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersValidation>>,
          TError,
          Awaited<ReturnType<typeof getUsersValidation>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersValidation<TData = Awaited<ReturnType<typeof getUsersValidation>>, TError = ErrorType<unknown>>(
 params?: GetUsersValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersValidation<TData = Awaited<ReturnType<typeof getUsersValidation>>, TError = ErrorType<unknown>>(
 params?: GetUsersValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersValidationQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersValidationQuery = async <TData = Awaited<ReturnType<typeof getUsersValidation>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersValidationParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersValidation>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersValidationQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postUsersValidationResponse200 = {
  data: Response
  status: 200
}
    
export type postUsersValidationResponseSuccess = (postUsersValidationResponse200) & {
  headers: Headers;
};
;

export type postUsersValidationResponse = (postUsersValidationResponseSuccess)

export const getPostUsersValidationUrl = () => {


  

  return `/users/validation`
}

export const postUsersValidation = async (userValidation: UserValidation, options?: RequestInit): Promise<postUsersValidationResponse> => {
  
  return useCustomClient<postUsersValidationResponse>(getPostUsersValidationUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      userValidation,)
  }
);}




export const getPostUsersValidationMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsersValidation>>, TError,{data: BodyType<UserValidation>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postUsersValidation>>, TError,{data: BodyType<UserValidation>}, TContext> => {

const mutationKey = ['postUsersValidation'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postUsersValidation>>, {data: BodyType<UserValidation>}> = (props) => {
          const {data} = props ?? {};

          return  postUsersValidation(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostUsersValidationMutationResult = NonNullable<Awaited<ReturnType<typeof postUsersValidation>>>
    export type PostUsersValidationMutationBody = BodyType<UserValidation>
    export type PostUsersValidationMutationError = ErrorType<unknown>

    export const usePostUsersValidation = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postUsersValidation>>, TError,{data: BodyType<UserValidation>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postUsersValidation>>,
        TError,
        {data: BodyType<UserValidation>},
        TContext
      > => {

      const mutationOptions = getPostUsersValidationMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getUsersWithoutMembershipFeeByYearResponse200 = {
  data: Response
  status: 200
}
    
export type getUsersWithoutMembershipFeeByYearResponseSuccess = (getUsersWithoutMembershipFeeByYearResponse200) & {
  headers: Headers;
};
;

export type getUsersWithoutMembershipFeeByYearResponse = (getUsersWithoutMembershipFeeByYearResponseSuccess)

export const getGetUsersWithoutMembershipFeeByYearUrl = (params?: GetUsersWithoutMembershipFeeByYearParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/users/withoutMembershipFeeByYear?${stringifiedParams}` : `/users/withoutMembershipFeeByYear`
}

export const getUsersWithoutMembershipFeeByYear = async (params?: GetUsersWithoutMembershipFeeByYearParams, options?: RequestInit): Promise<getUsersWithoutMembershipFeeByYearResponse> => {
  
  return useCustomClient<getUsersWithoutMembershipFeeByYearResponse>(getGetUsersWithoutMembershipFeeByYearUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetUsersWithoutMembershipFeeByYearInfiniteQueryKey = (params?: GetUsersWithoutMembershipFeeByYearParams,) => {
    return [
    'infinite', `/users/withoutMembershipFeeByYear`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetUsersWithoutMembershipFeeByYearQueryKey = (params?: GetUsersWithoutMembershipFeeByYearParams,) => {
    return [
    `/users/withoutMembershipFeeByYear`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetUsersWithoutMembershipFeeByYearInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>>, TError = ErrorType<unknown>>(params?: GetUsersWithoutMembershipFeeByYearParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersWithoutMembershipFeeByYearInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>> = ({ signal }) => getUsersWithoutMembershipFeeByYear(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersWithoutMembershipFeeByYearInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>>
export type GetUsersWithoutMembershipFeeByYearInfiniteQueryError = ErrorType<unknown>


export function useGetUsersWithoutMembershipFeeByYearInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersWithoutMembershipFeeByYearParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>,
          TError,
          Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersWithoutMembershipFeeByYearInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>>, TError = ErrorType<unknown>>(
 params?: GetUsersWithoutMembershipFeeByYearParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>,
          TError,
          Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersWithoutMembershipFeeByYearInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>>, TError = ErrorType<unknown>>(
 params?: GetUsersWithoutMembershipFeeByYearParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersWithoutMembershipFeeByYearInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>>, TError = ErrorType<unknown>>(
 params?: GetUsersWithoutMembershipFeeByYearParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersWithoutMembershipFeeByYearInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersWithoutMembershipFeeByYearInfiniteQuery = async <TData = Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersWithoutMembershipFeeByYearParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersWithoutMembershipFeeByYearInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetUsersWithoutMembershipFeeByYearQueryOptions = <TData = Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError = ErrorType<unknown>>(params?: GetUsersWithoutMembershipFeeByYearParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetUsersWithoutMembershipFeeByYearQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>> = ({ signal }) => getUsersWithoutMembershipFeeByYear(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetUsersWithoutMembershipFeeByYearQueryResult = NonNullable<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>>
export type GetUsersWithoutMembershipFeeByYearQueryError = ErrorType<unknown>


export function useGetUsersWithoutMembershipFeeByYear<TData = Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError = ErrorType<unknown>>(
 params: undefined |  GetUsersWithoutMembershipFeeByYearParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>,
          TError,
          Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersWithoutMembershipFeeByYear<TData = Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError = ErrorType<unknown>>(
 params?: GetUsersWithoutMembershipFeeByYearParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>,
          TError,
          Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetUsersWithoutMembershipFeeByYear<TData = Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError = ErrorType<unknown>>(
 params?: GetUsersWithoutMembershipFeeByYearParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetUsersWithoutMembershipFeeByYear<TData = Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError = ErrorType<unknown>>(
 params?: GetUsersWithoutMembershipFeeByYearParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetUsersWithoutMembershipFeeByYearQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetUsersWithoutMembershipFeeByYearQuery = async <TData = Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetUsersWithoutMembershipFeeByYearParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getUsersWithoutMembershipFeeByYear>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetUsersWithoutMembershipFeeByYearQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



