/**
 * Generated by orval v8.0.0-rc.0 🍺
 * Do not edit manually.
 * VCCI
 * Coded by Meu TEAM
 * OpenAPI spec version: 1.0.0
 */
import {
  useInfiniteQuery,
  useMutation,
  useQuery
} from '@tanstack/react-query';
import type {
  DataTag,
  DefinedInitialDataOptions,
  DefinedUseInfiniteQueryResult,
  DefinedUseQueryResult,
  InfiniteData,
  MutationFunction,
  QueryClient,
  QueryFunction,
  QueryKey,
  UndefinedInitialDataOptions,
  UseInfiniteQueryOptions,
  UseInfiniteQueryResult,
  UseMutationOptions,
  UseMutationResult,
  UseQueryOptions,
  UseQueryResult
} from '@tanstack/react-query';

import type {
  DeleteEventsLinkParams,
  DeleteEventsParams,
  EventArrayBody,
  EventBody,
  EventOrganization,
  EventOrganizationBody,
  GetEventsGroupByMonthParams,
  GetEventsLinkParams,
  GetEventsMyEventsParams,
  GetEventsParams,
  GetEventsSlugSlugParams,
  PostEventsIdExportJoinedOrgsParams,
  PutEventsLinkParams,
  PutEventsParams,
  Response
} from '../models';

import { useCustomClient } from '../mutator/custom-client';
import type { ErrorType , BodyType } from '../mutator/custom-client';



type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1];



/**
 * Export to excel
 */
export type postEventsIdExportJoinedOrgsResponse200 = {
  data: Response
  status: 200
}
    
export type postEventsIdExportJoinedOrgsResponseSuccess = (postEventsIdExportJoinedOrgsResponse200) & {
  headers: Headers;
};
;

export type postEventsIdExportJoinedOrgsResponse = (postEventsIdExportJoinedOrgsResponseSuccess)

export const getPostEventsIdExportJoinedOrgsUrl = (id: string,
    params?: PostEventsIdExportJoinedOrgsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/events/${id}/exportJoinedOrgs?${stringifiedParams}` : `/events/${id}/exportJoinedOrgs`
}

export const postEventsIdExportJoinedOrgs = async (id: string,
    params?: PostEventsIdExportJoinedOrgsParams, options?: RequestInit): Promise<postEventsIdExportJoinedOrgsResponse> => {
  
  return useCustomClient<postEventsIdExportJoinedOrgsResponse>(getPostEventsIdExportJoinedOrgsUrl(id,params),
  {      
    ...options,
    method: 'POST'
    
    
  }
);}




export const getPostEventsIdExportJoinedOrgsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postEventsIdExportJoinedOrgs>>, TError,{id: string;params?: PostEventsIdExportJoinedOrgsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postEventsIdExportJoinedOrgs>>, TError,{id: string;params?: PostEventsIdExportJoinedOrgsParams}, TContext> => {

const mutationKey = ['postEventsIdExportJoinedOrgs'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postEventsIdExportJoinedOrgs>>, {id: string;params?: PostEventsIdExportJoinedOrgsParams}> = (props) => {
          const {id,params} = props ?? {};

          return  postEventsIdExportJoinedOrgs(id,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostEventsIdExportJoinedOrgsMutationResult = NonNullable<Awaited<ReturnType<typeof postEventsIdExportJoinedOrgs>>>
    
    export type PostEventsIdExportJoinedOrgsMutationError = ErrorType<unknown>

    export const usePostEventsIdExportJoinedOrgs = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postEventsIdExportJoinedOrgs>>, TError,{id: string;params?: PostEventsIdExportJoinedOrgsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postEventsIdExportJoinedOrgs>>,
        TError,
        {id: string;params?: PostEventsIdExportJoinedOrgsParams},
        TContext
      > => {

      const mutationOptions = getPostEventsIdExportJoinedOrgsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getEventsIdResponse200 = {
  data: Response
  status: 200
}
    
export type getEventsIdResponseSuccess = (getEventsIdResponse200) & {
  headers: Headers;
};
;

export type getEventsIdResponse = (getEventsIdResponseSuccess)

export const getGetEventsIdUrl = (id: string,) => {


  

  return `/events/${id}`
}

export const getEventsId = async (id: string, options?: RequestInit): Promise<getEventsIdResponse> => {
  
  return useCustomClient<getEventsIdResponse>(getGetEventsIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetEventsIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/events/${id}`
    ] as const;
    }

export const getGetEventsIdQueryKey = (id?: string,) => {
    return [
    `/events/${id}`
    ] as const;
    }

    
export const getGetEventsIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getEventsId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsId>>> = ({ signal }) => getEventsId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsId>>>
export type GetEventsIdInfiniteQueryError = ErrorType<unknown>


export function useGetEventsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsId>>,
          TError,
          Awaited<ReturnType<typeof getEventsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsId>>,
          TError,
          Awaited<ReturnType<typeof getEventsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getEventsId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetEventsIdQueryOptions = <TData = Awaited<ReturnType<typeof getEventsId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsId>>> = ({ signal }) => getEventsId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsIdQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsId>>>
export type GetEventsIdQueryError = ErrorType<unknown>


export function useGetEventsId<TData = Awaited<ReturnType<typeof getEventsId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsId>>,
          TError,
          Awaited<ReturnType<typeof getEventsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsId<TData = Awaited<ReturnType<typeof getEventsId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsId>>,
          TError,
          Awaited<ReturnType<typeof getEventsId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsId<TData = Awaited<ReturnType<typeof getEventsId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsId<TData = Awaited<ReturnType<typeof getEventsId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsIdQuery = async <TData = Awaited<ReturnType<typeof getEventsId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putEventsIdResponse200 = {
  data: Response
  status: 200
}
    
export type putEventsIdResponseSuccess = (putEventsIdResponse200) & {
  headers: Headers;
};
;

export type putEventsIdResponse = (putEventsIdResponseSuccess)

export const getPutEventsIdUrl = (id: string,) => {


  

  return `/events/${id}`
}

export const putEventsId = async (id: string,
    eventBody: EventBody, options?: RequestInit): Promise<putEventsIdResponse> => {
  
  return useCustomClient<putEventsIdResponse>(getPutEventsIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      eventBody,)
  }
);}




export const getPutEventsIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putEventsId>>, TError,{id: string;data: BodyType<EventBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putEventsId>>, TError,{id: string;data: BodyType<EventBody>}, TContext> => {

const mutationKey = ['putEventsId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putEventsId>>, {id: string;data: BodyType<EventBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putEventsId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutEventsIdMutationResult = NonNullable<Awaited<ReturnType<typeof putEventsId>>>
    export type PutEventsIdMutationBody = BodyType<EventBody>
    export type PutEventsIdMutationError = ErrorType<unknown>

    export const usePutEventsId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putEventsId>>, TError,{id: string;data: BodyType<EventBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putEventsId>>,
        TError,
        {id: string;data: BodyType<EventBody>},
        TContext
      > => {

      const mutationOptions = getPutEventsIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteEventsIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteEventsIdResponseSuccess = (deleteEventsIdResponse200) & {
  headers: Headers;
};
;

export type deleteEventsIdResponse = (deleteEventsIdResponseSuccess)

export const getDeleteEventsIdUrl = (id: string,) => {


  

  return `/events/${id}`
}

export const deleteEventsId = async (id: string, options?: RequestInit): Promise<deleteEventsIdResponse> => {
  
  return useCustomClient<deleteEventsIdResponse>(getDeleteEventsIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteEventsIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteEventsId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteEventsId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteEventsId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteEventsId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteEventsId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteEventsIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteEventsId>>>
    
    export type DeleteEventsIdMutationError = ErrorType<unknown>

    export const useDeleteEventsId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteEventsId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteEventsId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteEventsIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getEventsGroupByMonthResponse200 = {
  data: Response
  status: 200
}
    
export type getEventsGroupByMonthResponseSuccess = (getEventsGroupByMonthResponse200) & {
  headers: Headers;
};
;

export type getEventsGroupByMonthResponse = (getEventsGroupByMonthResponseSuccess)

export const getGetEventsGroupByMonthUrl = (params?: GetEventsGroupByMonthParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/events/groupByMonth?${stringifiedParams}` : `/events/groupByMonth`
}

export const getEventsGroupByMonth = async (params?: GetEventsGroupByMonthParams, options?: RequestInit): Promise<getEventsGroupByMonthResponse> => {
  
  return useCustomClient<getEventsGroupByMonthResponse>(getGetEventsGroupByMonthUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetEventsGroupByMonthInfiniteQueryKey = (params?: GetEventsGroupByMonthParams,) => {
    return [
    'infinite', `/events/groupByMonth`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetEventsGroupByMonthQueryKey = (params?: GetEventsGroupByMonthParams,) => {
    return [
    `/events/groupByMonth`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetEventsGroupByMonthInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getEventsGroupByMonth>>>, TError = ErrorType<unknown>>(params?: GetEventsGroupByMonthParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsGroupByMonthInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsGroupByMonth>>> = ({ signal }) => getEventsGroupByMonth(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsGroupByMonthInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsGroupByMonth>>>
export type GetEventsGroupByMonthInfiniteQueryError = ErrorType<unknown>


export function useGetEventsGroupByMonthInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsGroupByMonth>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetEventsGroupByMonthParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsGroupByMonth>>,
          TError,
          Awaited<ReturnType<typeof getEventsGroupByMonth>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsGroupByMonthInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsGroupByMonth>>>, TError = ErrorType<unknown>>(
 params?: GetEventsGroupByMonthParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsGroupByMonth>>,
          TError,
          Awaited<ReturnType<typeof getEventsGroupByMonth>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsGroupByMonthInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsGroupByMonth>>>, TError = ErrorType<unknown>>(
 params?: GetEventsGroupByMonthParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsGroupByMonthInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsGroupByMonth>>>, TError = ErrorType<unknown>>(
 params?: GetEventsGroupByMonthParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsGroupByMonthInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsGroupByMonthInfiniteQuery = async <TData = Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetEventsGroupByMonthParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsGroupByMonthInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetEventsGroupByMonthQueryOptions = <TData = Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError = ErrorType<unknown>>(params?: GetEventsGroupByMonthParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsGroupByMonthQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsGroupByMonth>>> = ({ signal }) => getEventsGroupByMonth(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsGroupByMonthQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsGroupByMonth>>>
export type GetEventsGroupByMonthQueryError = ErrorType<unknown>


export function useGetEventsGroupByMonth<TData = Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError = ErrorType<unknown>>(
 params: undefined |  GetEventsGroupByMonthParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsGroupByMonth>>,
          TError,
          Awaited<ReturnType<typeof getEventsGroupByMonth>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsGroupByMonth<TData = Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError = ErrorType<unknown>>(
 params?: GetEventsGroupByMonthParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsGroupByMonth>>,
          TError,
          Awaited<ReturnType<typeof getEventsGroupByMonth>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsGroupByMonth<TData = Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError = ErrorType<unknown>>(
 params?: GetEventsGroupByMonthParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsGroupByMonth<TData = Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError = ErrorType<unknown>>(
 params?: GetEventsGroupByMonthParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsGroupByMonthQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsGroupByMonthQuery = async <TData = Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetEventsGroupByMonthParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsGroupByMonth>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsGroupByMonthQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getEventsResponse200 = {
  data: Response
  status: 200
}
    
export type getEventsResponseSuccess = (getEventsResponse200) & {
  headers: Headers;
};
;

export type getEventsResponse = (getEventsResponseSuccess)

export const getGetEventsUrl = (params?: GetEventsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/events?${stringifiedParams}` : `/events`
}

export const getEvents = async (params?: GetEventsParams, options?: RequestInit): Promise<getEventsResponse> => {
  
  return useCustomClient<getEventsResponse>(getGetEventsUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetEventsInfiniteQueryKey = (params?: GetEventsParams,) => {
    return [
    'infinite', `/events`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetEventsQueryKey = (params?: GetEventsParams,) => {
    return [
    `/events`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetEventsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getEvents>>>, TError = ErrorType<unknown>>(params?: GetEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEvents>>> = ({ signal }) => getEvents(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getEvents>>>
export type GetEventsInfiniteQueryError = ErrorType<unknown>


export function useGetEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEvents>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetEventsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEvents>>,
          TError,
          Awaited<ReturnType<typeof getEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEvents>>>, TError = ErrorType<unknown>>(
 params?: GetEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEvents>>,
          TError,
          Awaited<ReturnType<typeof getEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEvents>>>, TError = ErrorType<unknown>>(
 params?: GetEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEvents>>>, TError = ErrorType<unknown>>(
 params?: GetEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getEvents>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetEventsQueryOptions = <TData = Awaited<ReturnType<typeof getEvents>>, TError = ErrorType<unknown>>(params?: GetEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEvents>>> = ({ signal }) => getEvents(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsQueryResult = NonNullable<Awaited<ReturnType<typeof getEvents>>>
export type GetEventsQueryError = ErrorType<unknown>


export function useGetEvents<TData = Awaited<ReturnType<typeof getEvents>>, TError = ErrorType<unknown>>(
 params: undefined |  GetEventsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEvents>>,
          TError,
          Awaited<ReturnType<typeof getEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEvents<TData = Awaited<ReturnType<typeof getEvents>>, TError = ErrorType<unknown>>(
 params?: GetEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEvents>>,
          TError,
          Awaited<ReturnType<typeof getEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEvents<TData = Awaited<ReturnType<typeof getEvents>>, TError = ErrorType<unknown>>(
 params?: GetEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEvents<TData = Awaited<ReturnType<typeof getEvents>>, TError = ErrorType<unknown>>(
 params?: GetEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsQuery = async <TData = Awaited<ReturnType<typeof getEvents>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postEventsResponse200 = {
  data: Response
  status: 200
}
    
export type postEventsResponseSuccess = (postEventsResponse200) & {
  headers: Headers;
};
;

export type postEventsResponse = (postEventsResponseSuccess)

export const getPostEventsUrl = () => {


  

  return `/events`
}

export const postEvents = async (eventArrayBody: EventArrayBody, options?: RequestInit): Promise<postEventsResponse> => {
  
  return useCustomClient<postEventsResponse>(getPostEventsUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      eventArrayBody,)
  }
);}




export const getPostEventsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postEvents>>, TError,{data: BodyType<EventArrayBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postEvents>>, TError,{data: BodyType<EventArrayBody>}, TContext> => {

const mutationKey = ['postEvents'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postEvents>>, {data: BodyType<EventArrayBody>}> = (props) => {
          const {data} = props ?? {};

          return  postEvents(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostEventsMutationResult = NonNullable<Awaited<ReturnType<typeof postEvents>>>
    export type PostEventsMutationBody = BodyType<EventArrayBody>
    export type PostEventsMutationError = ErrorType<unknown>

    export const usePostEvents = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postEvents>>, TError,{data: BodyType<EventArrayBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postEvents>>,
        TError,
        {data: BodyType<EventArrayBody>},
        TContext
      > => {

      const mutationOptions = getPostEventsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putEventsResponse200 = {
  data: Response
  status: 200
}
    
export type putEventsResponseSuccess = (putEventsResponse200) & {
  headers: Headers;
};
;

export type putEventsResponse = (putEventsResponseSuccess)

export const getPutEventsUrl = (params: PutEventsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/events?${stringifiedParams}` : `/events`
}

export const putEvents = async (eventBody: EventBody,
    params: PutEventsParams, options?: RequestInit): Promise<putEventsResponse> => {
  
  return useCustomClient<putEventsResponse>(getPutEventsUrl(params),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      eventBody,)
  }
);}




export const getPutEventsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putEvents>>, TError,{data: BodyType<EventBody>;params: PutEventsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putEvents>>, TError,{data: BodyType<EventBody>;params: PutEventsParams}, TContext> => {

const mutationKey = ['putEvents'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putEvents>>, {data: BodyType<EventBody>;params: PutEventsParams}> = (props) => {
          const {data,params} = props ?? {};

          return  putEvents(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutEventsMutationResult = NonNullable<Awaited<ReturnType<typeof putEvents>>>
    export type PutEventsMutationBody = BodyType<EventBody>
    export type PutEventsMutationError = ErrorType<unknown>

    export const usePutEvents = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putEvents>>, TError,{data: BodyType<EventBody>;params: PutEventsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putEvents>>,
        TError,
        {data: BodyType<EventBody>;params: PutEventsParams},
        TContext
      > => {

      const mutationOptions = getPutEventsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteEventsResponse200 = {
  data: Response
  status: 200
}
    
export type deleteEventsResponseSuccess = (deleteEventsResponse200) & {
  headers: Headers;
};
;

export type deleteEventsResponse = (deleteEventsResponseSuccess)

export const getDeleteEventsUrl = (params: DeleteEventsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/events?${stringifiedParams}` : `/events`
}

export const deleteEvents = async (params: DeleteEventsParams, options?: RequestInit): Promise<deleteEventsResponse> => {
  
  return useCustomClient<deleteEventsResponse>(getDeleteEventsUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteEventsMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteEvents>>, TError,{params: DeleteEventsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteEvents>>, TError,{params: DeleteEventsParams}, TContext> => {

const mutationKey = ['deleteEvents'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteEvents>>, {params: DeleteEventsParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteEvents(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteEventsMutationResult = NonNullable<Awaited<ReturnType<typeof deleteEvents>>>
    
    export type DeleteEventsMutationError = ErrorType<unknown>

    export const useDeleteEvents = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteEvents>>, TError,{params: DeleteEventsParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteEvents>>,
        TError,
        {params: DeleteEventsParams},
        TContext
      > => {

      const mutationOptions = getDeleteEventsMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getEventsLinkIdResponse200 = {
  data: Response
  status: 200
}
    
export type getEventsLinkIdResponseSuccess = (getEventsLinkIdResponse200) & {
  headers: Headers;
};
;

export type getEventsLinkIdResponse = (getEventsLinkIdResponseSuccess)

export const getGetEventsLinkIdUrl = (id: string,) => {


  

  return `/events/link/${id}`
}

export const getEventsLinkId = async (id: string, options?: RequestInit): Promise<getEventsLinkIdResponse> => {
  
  return useCustomClient<getEventsLinkIdResponse>(getGetEventsLinkIdUrl(id),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetEventsLinkIdInfiniteQueryKey = (id?: string,) => {
    return [
    'infinite', `/events/link/${id}`
    ] as const;
    }

export const getGetEventsLinkIdQueryKey = (id?: string,) => {
    return [
    `/events/link/${id}`
    ] as const;
    }

    
export const getGetEventsLinkIdInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getEventsLinkId>>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsLinkIdInfiniteQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsLinkId>>> = ({ signal }) => getEventsLinkId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsLinkIdInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsLinkId>>>
export type GetEventsLinkIdInfiniteQueryError = ErrorType<unknown>


export function useGetEventsLinkIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsLinkId>>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsLinkId>>,
          TError,
          Awaited<ReturnType<typeof getEventsLinkId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsLinkIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsLinkId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsLinkId>>,
          TError,
          Awaited<ReturnType<typeof getEventsLinkId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsLinkIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsLinkId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsLinkIdInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsLinkId>>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsLinkIdInfiniteQueryOptions(id,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsLinkIdInfiniteQuery = async <TData = Awaited<ReturnType<typeof getEventsLinkId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsLinkIdInfiniteQueryOptions(id,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetEventsLinkIdQueryOptions = <TData = Awaited<ReturnType<typeof getEventsLinkId>>, TError = ErrorType<unknown>>(id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsLinkIdQueryKey(id);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsLinkId>>> = ({ signal }) => getEventsLinkId(id, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(id),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsLinkIdQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsLinkId>>>
export type GetEventsLinkIdQueryError = ErrorType<unknown>


export function useGetEventsLinkId<TData = Awaited<ReturnType<typeof getEventsLinkId>>, TError = ErrorType<unknown>>(
 id: string, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsLinkId>>,
          TError,
          Awaited<ReturnType<typeof getEventsLinkId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsLinkId<TData = Awaited<ReturnType<typeof getEventsLinkId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsLinkId>>,
          TError,
          Awaited<ReturnType<typeof getEventsLinkId>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsLinkId<TData = Awaited<ReturnType<typeof getEventsLinkId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsLinkId<TData = Awaited<ReturnType<typeof getEventsLinkId>>, TError = ErrorType<unknown>>(
 id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsLinkIdQueryOptions(id,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsLinkIdQuery = async <TData = Awaited<ReturnType<typeof getEventsLinkId>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, id: string, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLinkId>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsLinkIdQueryOptions(id,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Put
 */
export type putEventsLinkIdResponse200 = {
  data: Response
  status: 200
}
    
export type putEventsLinkIdResponseSuccess = (putEventsLinkIdResponse200) & {
  headers: Headers;
};
;

export type putEventsLinkIdResponse = (putEventsLinkIdResponseSuccess)

export const getPutEventsLinkIdUrl = (id: string,) => {


  

  return `/events/link/${id}`
}

export const putEventsLinkId = async (id: string,
    eventOrganizationBody: EventOrganizationBody, options?: RequestInit): Promise<putEventsLinkIdResponse> => {
  
  return useCustomClient<putEventsLinkIdResponse>(getPutEventsLinkIdUrl(id),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      eventOrganizationBody,)
  }
);}




export const getPutEventsLinkIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putEventsLinkId>>, TError,{id: string;data: BodyType<EventOrganizationBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putEventsLinkId>>, TError,{id: string;data: BodyType<EventOrganizationBody>}, TContext> => {

const mutationKey = ['putEventsLinkId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putEventsLinkId>>, {id: string;data: BodyType<EventOrganizationBody>}> = (props) => {
          const {id,data} = props ?? {};

          return  putEventsLinkId(id,data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutEventsLinkIdMutationResult = NonNullable<Awaited<ReturnType<typeof putEventsLinkId>>>
    export type PutEventsLinkIdMutationBody = BodyType<EventOrganizationBody>
    export type PutEventsLinkIdMutationError = ErrorType<unknown>

    export const usePutEventsLinkId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putEventsLinkId>>, TError,{id: string;data: BodyType<EventOrganizationBody>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putEventsLinkId>>,
        TError,
        {id: string;data: BodyType<EventOrganizationBody>},
        TContext
      > => {

      const mutationOptions = getPutEventsLinkIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteEventsLinkIdResponse200 = {
  data: Response
  status: 200
}
    
export type deleteEventsLinkIdResponseSuccess = (deleteEventsLinkIdResponse200) & {
  headers: Headers;
};
;

export type deleteEventsLinkIdResponse = (deleteEventsLinkIdResponseSuccess)

export const getDeleteEventsLinkIdUrl = (id: string,) => {


  

  return `/events/link/${id}`
}

export const deleteEventsLinkId = async (id: string, options?: RequestInit): Promise<deleteEventsLinkIdResponse> => {
  
  return useCustomClient<deleteEventsLinkIdResponse>(getDeleteEventsLinkIdUrl(id),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteEventsLinkIdMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteEventsLinkId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteEventsLinkId>>, TError,{id: string}, TContext> => {

const mutationKey = ['deleteEventsLinkId'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteEventsLinkId>>, {id: string}> = (props) => {
          const {id} = props ?? {};

          return  deleteEventsLinkId(id,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteEventsLinkIdMutationResult = NonNullable<Awaited<ReturnType<typeof deleteEventsLinkId>>>
    
    export type DeleteEventsLinkIdMutationError = ErrorType<unknown>

    export const useDeleteEventsLinkId = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteEventsLinkId>>, TError,{id: string}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteEventsLinkId>>,
        TError,
        {id: string},
        TContext
      > => {

      const mutationOptions = getDeleteEventsLinkIdMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getEventsLinkResponse200 = {
  data: Response
  status: 200
}
    
export type getEventsLinkResponseSuccess = (getEventsLinkResponse200) & {
  headers: Headers;
};
;

export type getEventsLinkResponse = (getEventsLinkResponseSuccess)

export const getGetEventsLinkUrl = (params?: GetEventsLinkParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/events/link?${stringifiedParams}` : `/events/link`
}

export const getEventsLink = async (params?: GetEventsLinkParams, options?: RequestInit): Promise<getEventsLinkResponse> => {
  
  return useCustomClient<getEventsLinkResponse>(getGetEventsLinkUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetEventsLinkInfiniteQueryKey = (params?: GetEventsLinkParams,) => {
    return [
    'infinite', `/events/link`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetEventsLinkQueryKey = (params?: GetEventsLinkParams,) => {
    return [
    `/events/link`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetEventsLinkInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getEventsLink>>>, TError = ErrorType<unknown>>(params?: GetEventsLinkParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsLinkInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsLink>>> = ({ signal }) => getEventsLink(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsLinkInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsLink>>>
export type GetEventsLinkInfiniteQueryError = ErrorType<unknown>


export function useGetEventsLinkInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsLink>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetEventsLinkParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsLink>>,
          TError,
          Awaited<ReturnType<typeof getEventsLink>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsLinkInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsLink>>>, TError = ErrorType<unknown>>(
 params?: GetEventsLinkParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsLink>>,
          TError,
          Awaited<ReturnType<typeof getEventsLink>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsLinkInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsLink>>>, TError = ErrorType<unknown>>(
 params?: GetEventsLinkParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsLinkInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsLink>>>, TError = ErrorType<unknown>>(
 params?: GetEventsLinkParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsLinkInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsLinkInfiniteQuery = async <TData = Awaited<ReturnType<typeof getEventsLink>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetEventsLinkParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsLinkInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetEventsLinkQueryOptions = <TData = Awaited<ReturnType<typeof getEventsLink>>, TError = ErrorType<unknown>>(params?: GetEventsLinkParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsLinkQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsLink>>> = ({ signal }) => getEventsLink(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsLinkQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsLink>>>
export type GetEventsLinkQueryError = ErrorType<unknown>


export function useGetEventsLink<TData = Awaited<ReturnType<typeof getEventsLink>>, TError = ErrorType<unknown>>(
 params: undefined |  GetEventsLinkParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsLink>>,
          TError,
          Awaited<ReturnType<typeof getEventsLink>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsLink<TData = Awaited<ReturnType<typeof getEventsLink>>, TError = ErrorType<unknown>>(
 params?: GetEventsLinkParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsLink>>,
          TError,
          Awaited<ReturnType<typeof getEventsLink>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsLink<TData = Awaited<ReturnType<typeof getEventsLink>>, TError = ErrorType<unknown>>(
 params?: GetEventsLinkParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsLink<TData = Awaited<ReturnType<typeof getEventsLink>>, TError = ErrorType<unknown>>(
 params?: GetEventsLinkParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsLinkQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsLinkQuery = async <TData = Awaited<ReturnType<typeof getEventsLink>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetEventsLinkParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsLink>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsLinkQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Post
 */
export type postEventsLinkResponse200 = {
  data: Response
  status: 200
}
    
export type postEventsLinkResponseSuccess = (postEventsLinkResponse200) & {
  headers: Headers;
};
;

export type postEventsLinkResponse = (postEventsLinkResponseSuccess)

export const getPostEventsLinkUrl = () => {


  

  return `/events/link`
}

export const postEventsLink = async (eventOrganization: EventOrganization[], options?: RequestInit): Promise<postEventsLinkResponse> => {
  
  return useCustomClient<postEventsLinkResponse>(getPostEventsLinkUrl(),
  {      
    ...options,
    method: 'POST',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      eventOrganization,)
  }
);}




export const getPostEventsLinkMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postEventsLink>>, TError,{data: BodyType<EventOrganization[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof postEventsLink>>, TError,{data: BodyType<EventOrganization[]>}, TContext> => {

const mutationKey = ['postEventsLink'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof postEventsLink>>, {data: BodyType<EventOrganization[]>}> = (props) => {
          const {data} = props ?? {};

          return  postEventsLink(data,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PostEventsLinkMutationResult = NonNullable<Awaited<ReturnType<typeof postEventsLink>>>
    export type PostEventsLinkMutationBody = BodyType<EventOrganization[]>
    export type PostEventsLinkMutationError = ErrorType<unknown>

    export const usePostEventsLink = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof postEventsLink>>, TError,{data: BodyType<EventOrganization[]>}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof postEventsLink>>,
        TError,
        {data: BodyType<EventOrganization[]>},
        TContext
      > => {

      const mutationOptions = getPostEventsLinkMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Put
 */
export type putEventsLinkResponse200 = {
  data: Response
  status: 200
}
    
export type putEventsLinkResponseSuccess = (putEventsLinkResponse200) & {
  headers: Headers;
};
;

export type putEventsLinkResponse = (putEventsLinkResponseSuccess)

export const getPutEventsLinkUrl = (params: PutEventsLinkParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/events/link?${stringifiedParams}` : `/events/link`
}

export const putEventsLink = async (eventOrganizationBody: EventOrganizationBody,
    params: PutEventsLinkParams, options?: RequestInit): Promise<putEventsLinkResponse> => {
  
  return useCustomClient<putEventsLinkResponse>(getPutEventsLinkUrl(params),
  {      
    ...options,
    method: 'PUT',
    headers: { 'Content-Type': 'application/json', ...options?.headers },
    body: JSON.stringify(
      eventOrganizationBody,)
  }
);}




export const getPutEventsLinkMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putEventsLink>>, TError,{data: BodyType<EventOrganizationBody>;params: PutEventsLinkParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof putEventsLink>>, TError,{data: BodyType<EventOrganizationBody>;params: PutEventsLinkParams}, TContext> => {

const mutationKey = ['putEventsLink'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof putEventsLink>>, {data: BodyType<EventOrganizationBody>;params: PutEventsLinkParams}> = (props) => {
          const {data,params} = props ?? {};

          return  putEventsLink(data,params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type PutEventsLinkMutationResult = NonNullable<Awaited<ReturnType<typeof putEventsLink>>>
    export type PutEventsLinkMutationBody = BodyType<EventOrganizationBody>
    export type PutEventsLinkMutationError = ErrorType<unknown>

    export const usePutEventsLink = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof putEventsLink>>, TError,{data: BodyType<EventOrganizationBody>;params: PutEventsLinkParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof putEventsLink>>,
        TError,
        {data: BodyType<EventOrganizationBody>;params: PutEventsLinkParams},
        TContext
      > => {

      const mutationOptions = getPutEventsLinkMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Delete
 */
export type deleteEventsLinkResponse200 = {
  data: Response
  status: 200
}
    
export type deleteEventsLinkResponseSuccess = (deleteEventsLinkResponse200) & {
  headers: Headers;
};
;

export type deleteEventsLinkResponse = (deleteEventsLinkResponseSuccess)

export const getDeleteEventsLinkUrl = (params: DeleteEventsLinkParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/events/link?${stringifiedParams}` : `/events/link`
}

export const deleteEventsLink = async (params: DeleteEventsLinkParams, options?: RequestInit): Promise<deleteEventsLinkResponse> => {
  
  return useCustomClient<deleteEventsLinkResponse>(getDeleteEventsLinkUrl(params),
  {      
    ...options,
    method: 'DELETE'
    
    
  }
);}




export const getDeleteEventsLinkMutationOptions = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteEventsLink>>, TError,{params: DeleteEventsLinkParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
): UseMutationOptions<Awaited<ReturnType<typeof deleteEventsLink>>, TError,{params: DeleteEventsLinkParams}, TContext> => {

const mutationKey = ['deleteEventsLink'];
const {mutation: mutationOptions, request: requestOptions} = options ?
      options.mutation && 'mutationKey' in options.mutation && options.mutation.mutationKey ?
      options
      : {...options, mutation: {...options.mutation, mutationKey}}
      : {mutation: { mutationKey, }, request: undefined};

      


      const mutationFn: MutationFunction<Awaited<ReturnType<typeof deleteEventsLink>>, {params: DeleteEventsLinkParams}> = (props) => {
          const {params} = props ?? {};

          return  deleteEventsLink(params,requestOptions)
        }

        


  return  { mutationFn, ...mutationOptions }}

    export type DeleteEventsLinkMutationResult = NonNullable<Awaited<ReturnType<typeof deleteEventsLink>>>
    
    export type DeleteEventsLinkMutationError = ErrorType<unknown>

    export const useDeleteEventsLink = <TError = ErrorType<unknown>,
    TContext = unknown>(options?: { mutation?:UseMutationOptions<Awaited<ReturnType<typeof deleteEventsLink>>, TError,{params: DeleteEventsLinkParams}, TContext>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient): UseMutationResult<
        Awaited<ReturnType<typeof deleteEventsLink>>,
        TError,
        {params: DeleteEventsLinkParams},
        TContext
      > => {

      const mutationOptions = getDeleteEventsLinkMutationOptions(options);

      return useMutation(mutationOptions, queryClient);
    }
    /**
 * Get
 */
export type getEventsMyEventsResponse200 = {
  data: Response
  status: 200
}
    
export type getEventsMyEventsResponseSuccess = (getEventsMyEventsResponse200) & {
  headers: Headers;
};
;

export type getEventsMyEventsResponse = (getEventsMyEventsResponseSuccess)

export const getGetEventsMyEventsUrl = (params?: GetEventsMyEventsParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/events/myEvents?${stringifiedParams}` : `/events/myEvents`
}

export const getEventsMyEvents = async (params?: GetEventsMyEventsParams, options?: RequestInit): Promise<getEventsMyEventsResponse> => {
  
  return useCustomClient<getEventsMyEventsResponse>(getGetEventsMyEventsUrl(params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetEventsMyEventsInfiniteQueryKey = (params?: GetEventsMyEventsParams,) => {
    return [
    'infinite', `/events/myEvents`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetEventsMyEventsQueryKey = (params?: GetEventsMyEventsParams,) => {
    return [
    `/events/myEvents`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetEventsMyEventsInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getEventsMyEvents>>>, TError = ErrorType<unknown>>(params?: GetEventsMyEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsMyEventsInfiniteQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsMyEvents>>> = ({ signal }) => getEventsMyEvents(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsMyEventsInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsMyEvents>>>
export type GetEventsMyEventsInfiniteQueryError = ErrorType<unknown>


export function useGetEventsMyEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsMyEvents>>>, TError = ErrorType<unknown>>(
 params: undefined |  GetEventsMyEventsParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsMyEvents>>,
          TError,
          Awaited<ReturnType<typeof getEventsMyEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsMyEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsMyEvents>>>, TError = ErrorType<unknown>>(
 params?: GetEventsMyEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsMyEvents>>,
          TError,
          Awaited<ReturnType<typeof getEventsMyEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsMyEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsMyEvents>>>, TError = ErrorType<unknown>>(
 params?: GetEventsMyEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsMyEventsInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsMyEvents>>>, TError = ErrorType<unknown>>(
 params?: GetEventsMyEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsMyEventsInfiniteQueryOptions(params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsMyEventsInfiniteQuery = async <TData = Awaited<ReturnType<typeof getEventsMyEvents>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetEventsMyEventsParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsMyEventsInfiniteQueryOptions(params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetEventsMyEventsQueryOptions = <TData = Awaited<ReturnType<typeof getEventsMyEvents>>, TError = ErrorType<unknown>>(params?: GetEventsMyEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsMyEventsQueryKey(params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsMyEvents>>> = ({ signal }) => getEventsMyEvents(params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsMyEventsQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsMyEvents>>>
export type GetEventsMyEventsQueryError = ErrorType<unknown>


export function useGetEventsMyEvents<TData = Awaited<ReturnType<typeof getEventsMyEvents>>, TError = ErrorType<unknown>>(
 params: undefined |  GetEventsMyEventsParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsMyEvents>>,
          TError,
          Awaited<ReturnType<typeof getEventsMyEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsMyEvents<TData = Awaited<ReturnType<typeof getEventsMyEvents>>, TError = ErrorType<unknown>>(
 params?: GetEventsMyEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsMyEvents>>,
          TError,
          Awaited<ReturnType<typeof getEventsMyEvents>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsMyEvents<TData = Awaited<ReturnType<typeof getEventsMyEvents>>, TError = ErrorType<unknown>>(
 params?: GetEventsMyEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsMyEvents<TData = Awaited<ReturnType<typeof getEventsMyEvents>>, TError = ErrorType<unknown>>(
 params?: GetEventsMyEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsMyEventsQueryOptions(params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsMyEventsQuery = async <TData = Awaited<ReturnType<typeof getEventsMyEvents>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, params?: GetEventsMyEventsParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsMyEvents>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsMyEventsQueryOptions(params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getEventsSlugSlugResponse200 = {
  data: Response
  status: 200
}
    
export type getEventsSlugSlugResponseSuccess = (getEventsSlugSlugResponse200) & {
  headers: Headers;
};
;

export type getEventsSlugSlugResponse = (getEventsSlugSlugResponseSuccess)

export const getGetEventsSlugSlugUrl = (slug: string,
    params: GetEventsSlugSlugParams,) => {
  const normalizedParams = new URLSearchParams();

  Object.entries(params || {}).forEach(([key, value]) => {
    
    if (value !== undefined) {
      normalizedParams.append(key, value === null ? 'null' : value.toString())
    }
  });

  const stringifiedParams = normalizedParams.toString();

  return stringifiedParams.length > 0 ? `/events/slug/${slug}?${stringifiedParams}` : `/events/slug/${slug}`
}

export const getEventsSlugSlug = async (slug: string,
    params: GetEventsSlugSlugParams, options?: RequestInit): Promise<getEventsSlugSlugResponse> => {
  
  return useCustomClient<getEventsSlugSlugResponse>(getGetEventsSlugSlugUrl(slug,params),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetEventsSlugSlugInfiniteQueryKey = (slug?: string,
    params?: GetEventsSlugSlugParams,) => {
    return [
    'infinite', `/events/slug/${slug}`, ...(params ? [params]: [])
    ] as const;
    }

export const getGetEventsSlugSlugQueryKey = (slug?: string,
    params?: GetEventsSlugSlugParams,) => {
    return [
    `/events/slug/${slug}`, ...(params ? [params]: [])
    ] as const;
    }

    
export const getGetEventsSlugSlugInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getEventsSlugSlug>>>, TError = ErrorType<unknown>>(slug: string,
    params: GetEventsSlugSlugParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsSlugSlugInfiniteQueryKey(slug,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsSlugSlug>>> = ({ signal }) => getEventsSlugSlug(slug,params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(slug),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsSlugSlugInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsSlugSlug>>>
export type GetEventsSlugSlugInfiniteQueryError = ErrorType<unknown>


export function useGetEventsSlugSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsSlugSlug>>>, TError = ErrorType<unknown>>(
 slug: string,
    params: GetEventsSlugSlugParams, options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsSlugSlug>>,
          TError,
          Awaited<ReturnType<typeof getEventsSlugSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsSlugSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsSlugSlug>>>, TError = ErrorType<unknown>>(
 slug: string,
    params: GetEventsSlugSlugParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsSlugSlug>>,
          TError,
          Awaited<ReturnType<typeof getEventsSlugSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsSlugSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsSlugSlug>>>, TError = ErrorType<unknown>>(
 slug: string,
    params: GetEventsSlugSlugParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsSlugSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsSlugSlug>>>, TError = ErrorType<unknown>>(
 slug: string,
    params: GetEventsSlugSlugParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsSlugSlugInfiniteQueryOptions(slug,params,options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsSlugSlugInfiniteQuery = async <TData = Awaited<ReturnType<typeof getEventsSlugSlug>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, slug: string,
    params: GetEventsSlugSlugParams, options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsSlugSlugInfiniteQueryOptions(slug,params,options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetEventsSlugSlugQueryOptions = <TData = Awaited<ReturnType<typeof getEventsSlugSlug>>, TError = ErrorType<unknown>>(slug: string,
    params: GetEventsSlugSlugParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsSlugSlugQueryKey(slug,params);

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsSlugSlug>>> = ({ signal }) => getEventsSlugSlug(slug,params, { signal, ...requestOptions });

      

      

   return  { queryKey, queryFn, enabled: !!(slug),  retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsSlugSlugQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsSlugSlug>>>
export type GetEventsSlugSlugQueryError = ErrorType<unknown>


export function useGetEventsSlugSlug<TData = Awaited<ReturnType<typeof getEventsSlugSlug>>, TError = ErrorType<unknown>>(
 slug: string,
    params: GetEventsSlugSlugParams, options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsSlugSlug>>,
          TError,
          Awaited<ReturnType<typeof getEventsSlugSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsSlugSlug<TData = Awaited<ReturnType<typeof getEventsSlugSlug>>, TError = ErrorType<unknown>>(
 slug: string,
    params: GetEventsSlugSlugParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsSlugSlug>>,
          TError,
          Awaited<ReturnType<typeof getEventsSlugSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsSlugSlug<TData = Awaited<ReturnType<typeof getEventsSlugSlug>>, TError = ErrorType<unknown>>(
 slug: string,
    params: GetEventsSlugSlugParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsSlugSlug<TData = Awaited<ReturnType<typeof getEventsSlugSlug>>, TError = ErrorType<unknown>>(
 slug: string,
    params: GetEventsSlugSlugParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsSlugSlugQueryOptions(slug,params,options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsSlugSlugQuery = async <TData = Awaited<ReturnType<typeof getEventsSlugSlug>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient, slug: string,
    params: GetEventsSlugSlugParams, options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsSlugSlugQueryOptions(slug,params,options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



/**
 * Get
 */
export type getEventsSlugGetAllSlugResponse200 = {
  data: Response
  status: 200
}
    
export type getEventsSlugGetAllSlugResponseSuccess = (getEventsSlugGetAllSlugResponse200) & {
  headers: Headers;
};
;

export type getEventsSlugGetAllSlugResponse = (getEventsSlugGetAllSlugResponseSuccess)

export const getGetEventsSlugGetAllSlugUrl = () => {


  

  return `/events/slug/getAllSlug`
}

export const getEventsSlugGetAllSlug = async ( options?: RequestInit): Promise<getEventsSlugGetAllSlugResponse> => {
  
  return useCustomClient<getEventsSlugGetAllSlugResponse>(getGetEventsSlugGetAllSlugUrl(),
  {      
    ...options,
    method: 'GET'
    
    
  }
);}





export const getGetEventsSlugGetAllSlugInfiniteQueryKey = () => {
    return [
    'infinite', `/events/slug/getAllSlug`
    ] as const;
    }

export const getGetEventsSlugGetAllSlugQueryKey = () => {
    return [
    `/events/slug/getAllSlug`
    ] as const;
    }

    
export const getGetEventsSlugGetAllSlugInfiniteQueryOptions = <TData = InfiniteData<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsSlugGetAllSlugInfiniteQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>> = ({ signal }) => getEventsSlugGetAllSlug({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsSlugGetAllSlugInfiniteQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>>
export type GetEventsSlugGetAllSlugInfiniteQueryError = ErrorType<unknown>


export function useGetEventsSlugGetAllSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>,
          TError,
          Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsSlugGetAllSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>,
          TError,
          Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsSlugGetAllSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsSlugGetAllSlugInfinite<TData = InfiniteData<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsSlugGetAllSlugInfiniteQueryOptions(options)

  const query = useInfiniteQuery(queryOptions, queryClient) as  UseInfiniteQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsSlugGetAllSlugInfiniteQuery = async <TData = Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseInfiniteQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsSlugGetAllSlugInfiniteQueryOptions(options)

  await queryClient.prefetchInfiniteQuery(queryOptions);

  return queryClient;
}



export const getGetEventsSlugGetAllSlugQueryOptions = <TData = Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError = ErrorType<unknown>>( options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
) => {

const {query: queryOptions, request: requestOptions} = options ?? {};

  const queryKey =  queryOptions?.queryKey ?? getGetEventsSlugGetAllSlugQueryKey();

  

    const queryFn: QueryFunction<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>> = ({ signal }) => getEventsSlugGetAllSlug({ signal, ...requestOptions });

      

      

   return  { queryKey, queryFn,   retry: 3, retryDelay: 1000,  ...queryOptions} as UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData> & { queryKey: DataTag<QueryKey, TData, TError> }
}

export type GetEventsSlugGetAllSlugQueryResult = NonNullable<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>>
export type GetEventsSlugGetAllSlugQueryError = ErrorType<unknown>


export function useGetEventsSlugGetAllSlug<TData = Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
  options: { query:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>> & Pick<
        DefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>,
          TError,
          Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  DefinedUseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsSlugGetAllSlug<TData = Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>> & Pick<
        UndefinedInitialDataOptions<
          Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>,
          TError,
          Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>
        > , 'initialData'
      >, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }
export function useGetEventsSlugGetAllSlug<TData = Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient
  ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> }

export function useGetEventsSlugGetAllSlug<TData = Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}
 , queryClient?: QueryClient 
 ):  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> } {

  const queryOptions = getGetEventsSlugGetAllSlugQueryOptions(options)

  const query = useQuery(queryOptions, queryClient) as  UseQueryResult<TData, TError> & { queryKey: DataTag<QueryKey, TData, TError> };

  query.queryKey = queryOptions.queryKey ;

  return query;
}

export const prefetchGetEventsSlugGetAllSlugQuery = async <TData = Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError = ErrorType<unknown>>(
 queryClient: QueryClient,  options?: { query?:Partial<UseQueryOptions<Awaited<ReturnType<typeof getEventsSlugGetAllSlug>>, TError, TData>>, request?: SecondParameter<typeof useCustomClient>}

  ): Promise<QueryClient> => {

  const queryOptions = getGetEventsSlugGetAllSlugQueryOptions(options)

  await queryClient.prefetchQuery(queryOptions);

  return queryClient;
}



